/*
 *   Copyright (C) 2003,2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MTransmit.h"

#include "common/NCO.h"
#include "common/SoundFile.h"
#include "common/Exception.h"

#include "jt6m/JT6MDefs.h"
#include "jt6m/JT6MLookups.h"

#include <wx/datetime.h>
#include <wx/debug.h>
#include <wx/log.h>

int main(int argc, char **argv)
{
	if (argc < 3) {
		::fprintf(stderr, "Usage: JT6MTransmit <filename> <message>\n");
		return 0;
	}

	wxString fileName = wxString(argv[1]);
	wxString message  = wxString(argv[2]);

	try {
		ISoundDev* soundDev = new CSoundFile(fileName, JT6M_SAMPLE_RATE, 8);

		CJT6MTransmit transmit(soundDev, message);
		transmit.run();
	}
	catch (CException& ex) {
		::fprintf(stderr, "Error: %s\n", ex.getMessage().c_str());
		return 1;
	}

	catch (...) {
		::fprintf(stderr, "An Exception has occurred\n");
		return 1;
	}

	return 0;
}

CJT6MTransmit::CJT6MTransmit(ISoundDev* soundDev, const wxString& message) :
m_soundDev(soundDev),
m_message(message)
{
	wxASSERT(m_soundDev != NULL);
}

CJT6MTransmit::~CJT6MTransmit()
{
}

void CJT6MTransmit::run()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openWrite();

	CJT6MLookups lookups;
	CNCO nco(JT6M_SAMPLE_RATE, JT6M_SEND_VOLUME);

	if ((m_message.Length() % 2) == 1)
		m_message.Append(wxT(' '));

	unsigned int charPos = 0;
	unsigned int syncPos = 0;

	for (int samples = 0; samples < (29 * JT6M_SAMPLE_RATE); samples += JT6M_SYMBOL_LENGTH) {
		int tone = lookups.lookupChar(m_message.GetChar(charPos));

		charPos = (charPos + 1) % m_message.Length();
		syncPos = (syncPos + 1) % 2;

		if (tone == -1)
			tone = lookups.lookupChar(wxT(' '));

		double freq, out[JT6M_SYMBOL_LENGTH];

		freq = double(tone + 50) * double(JT6M_SAMPLE_RATE) / double(JT6M_SYMBOL_LENGTH);
		nco.generate(freq, out, JT6M_SYMBOL_LENGTH);
		m_soundDev->write(out, JT6M_SYMBOL_LENGTH);

		if (syncPos == 1) {
			freq = double(50 * JT6M_SAMPLE_RATE) / double(JT6M_SYMBOL_LENGTH);
			nco.generate(freq, out, JT6M_SYMBOL_LENGTH);
			m_soundDev->write(out, JT6M_SYMBOL_LENGTH);

			samples += JT6M_SYMBOL_LENGTH;
		}
	}

	m_soundDev->close();
}
