/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "FSK441Message.h"

#include <wx/listimpl.cpp>

WX_DEFINE_LIST(CFSK441MessageList);

CFSK441Message::CFSK441Message(const wxString& id, double time, int length, int strength, int DF, const wxString& text) :
m_id(id),
m_time(time),
m_length(length),
m_strength(strength),
m_DF(DF),
m_text(text)
{
}

CFSK441Message::~CFSK441Message()
{
}

wxString CFSK441Message::getId() const
{
	return m_id;
}

double CFSK441Message::getTime() const
{
	return m_time;
}

int CFSK441Message::getLength() const
{
	return m_length;
}

int CFSK441Message::getStrength() const
{
	return m_strength;
}

int CFSK441Message::getDF() const
{
	return m_DF;
}

wxString CFSK441Message::getText() const
{
	return m_text;
}
