/*
 *   Copyright (C) 1991-2003 by John A. Magliacane KD2BD
 *   Copyright (C) 2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	Sun_H
#define	Sun_H

#include <wx/wx.h>
#include <wx/datetime.h>

const double f       = 3.35281066474748E-3;	// Flattening factor
const double secday  = 8.6400E4;		// Seconds per day
const double xkmper  = 6.378137E3;		// WGS 84 Earth radius km
const double omegaE  = 1.00273790934;		// Earth rotations/siderial day
const double AU      = 1.49597870691E8;		// Astronomical unit - km (IAU 76)
const double mfactor = 7.292115E-5;

typedef struct {
	double lat;
	double lon;
	double alt;
	double theta;
} geodetic_t;

typedef struct {
	double x;
	double y;
	double z;
	double w;
} vector_t;

class CSun {

    public:
	CSun();
	virtual ~CSun();

	virtual void findSun(double dayNum);

	virtual double getAzimuth() const;
	virtual double getElevation() const;
	virtual double getRA() const;
	virtual double getDec() const;
	virtual double getRange() const;

	virtual void   setLocation(double latitude, double longitude, double height);

	virtual double getDayNum(const wxDateTime& dateTime) const;

    private:
	double     m_az;
	double     m_el;
	double     m_ra;
	double     m_dec;
	double     m_range;
	geodetic_t m_obs;

	void calculateSolarPosition(double time, vector_t& solar_vector) const;
	void calculateLatLonAlt(double time, vector_t& pos,  geodetic_t& geodetic) const;
	void calculateObs(double time, vector_t& pos, vector_t& vel, geodetic_t& geodetic, vector_t& obsSet) const;
	void calculateRADec(double time, vector_t& pos, vector_t& vel, geodetic_t& geodetic, vector_t& obsSet) const;
	void calculateUserPosVel(double time, geodetic_t& geodetic, vector_t& obsPos, vector_t& obsVel) const;

	void   magnitude(vector_t& v) const;
	double deltaET(double year) const;
	double thetaGJD(double jd) const;
	double modulus(double arg1, double arg2) const;
	double dot(vector_t& v1, vector_t& v2) const;
	double frac(double arg) const;
};

#endif
