/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef SFFT_H
#define SFFT_H

#include <complex>
using namespace std;

class CSFFT {

    public:
	CSFFT(int len, int first, int last);
	virtual ~CSFFT();

	virtual void process(double in, double* bins);
	virtual void process(double in, complex<double>* bins);

    private:
	int m_fftLen;
	int m_first;
	int m_last;
	int m_ptr;

	double*          m_cos;
	double*          m_sin;
	complex<double>* m_history;
	complex<double>* m_bins;
	double           m_corr;

	void process(double in);
};

#endif
