/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	Moon_H
#define	Moon_H

#include <wx/wx.h>
#include <wx/datetime.h>

class CMoon {

    public:
	CMoon();
	virtual ~CMoon();

	virtual void findMoon(double dayNum);

	virtual double getAzimuth() const;
	virtual double getElevation() const;
	virtual double getRA() const;
	virtual double getDec() const;
	virtual double getLHA() const;
	virtual double getGHA() const;
	virtual double getRange() const;

	virtual double getDoppler() const;
	virtual double getPathLoss() const;

	virtual void   setLocation(double latitude, double longitude);
	virtual void   setFrequency(double frequency);

	virtual double getDayNum(const wxDateTime& dateTime) const;

    private:
	double m_az;
	double m_el;
	double m_ra;
	double m_dec;
	double m_lha;
	double m_gha;
	double m_lat;
	double m_lon;
	double m_ro;
	double m_mm;
	double m_dx;
	double m_frequency;

	double fixAngle(double angle) const;
	double primeAngle(double x) const;
};

#endif
