/*
 *   Copyright (C) 2002,2003 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "Average.h"
#include "Exception.h"

#include <wx/log.h>

CAverage::CAverage() :
m_token(0),
m_total(0.0),
m_count(0),
m_maximum(0.0),
m_minimum(0.0)
{
}

CAverage::~CAverage()
{
}

int CAverage::getToken() const
{
	return m_token;
}

int CAverage::getCount() const
{
	return m_count;
}

double CAverage::getTotal() const
{
	return m_total;
}

double CAverage::getAverage() const
{
	if (m_count == 0)
		throw CException(wxT("Divide by zero in Averager"));

	return m_total / double(m_count);
}

double CAverage::getMaximum() const
{
	return m_maximum;
}

double CAverage::getMinimum() const
{
	return m_minimum;
}

void CAverage::setToken(int token)
{
	m_token = token;
}

void CAverage::subtractValue(double value)
{
	if (m_count == 0)
		throw CException(wxT("Invalid subtraction of value in Averager"));

	m_total -= value;
	m_count--;
}

void CAverage::addValue(double value)
{
	if (value > m_maximum)
		m_maximum = value;

	if (m_count == 0 || value < m_minimum)
		m_minimum = value;

	m_total += value;
	m_count++;
}

void CAverage::clear()
{
	m_maximum = 0.0;
	m_minimum = 0.0;
	m_total   = 0.0;
	m_count   = 0;
}
