#ifndef UI_CDINFO_H
#define UI_CDINFO_H
/*
 * $Id: ui_cdinfo.h,v 1.3.4.1 1999/01/15 08:47:35 dirk Exp $
 *
 * This file is part of WorkMan, the civilized CD player program
 * (c) 1991-1997 by Steven Grimm (original author)
 * (c) by Dirk Frsterling (current 'author' = maintainer)
 * The maintainer can be contacted by his e-mail address:
 * milliByte@DeathsDoor.com 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * CD info UI prototypes (ui_cdinfo.c)
 * 
 * This is just one more step to a more modular and understandable code.
 */

#include <xview/xview.h>
#include <xview/panel.h>
#include "workman_ui.h"

void	save_config( Panel_item item, Event *event );
int	update_trackname( Panel_item item, char *string, Xv_opaque client_data,
                  	  Panel_list_op op, Event *event, int row );
void	popup1_buttonpl_notify_callback(Panel_item item, Event *event );
void	text_event_p( Panel_item item, Event *event );
void	keep_settings( window1_objects *ip );
void	set_default_volume( Panel_item item, int value, Event *event );
Panel_setting	update_title( Panel_item item, Event *event );
void	insert_in_tracklist( Panel_item item, Event *event );
void	delete_from_tracklist( Panel_item item, Event *event );
Panel_setting	name_entered( Panel_item item, Event *event );
void	set_which_volume( Panel_item item, int value, Event *event );
void	cdinfo_reset( Panel_item item, Event *event );
void	delete_from_playlist( Panel_item item, Event *event );
void	disable_save( void );

#endif /* UI_CDINFO_H */
