#!/usr/local/bin/perl
# save_email.cgi
# Save scheduled email settings

require './quota-lib.pl';
$access{'email'} && &can_edit_filesys($in{'filesys'}) ||
	&error($text{'email_ecannot'});
&ReadParse();
&foreign_require("cron", "cron-lib.pl");
&error_setup($text{'email_err'});

# Validate inputs
if ($in{'email'}) {
	$in{'interval'} =~ /^\d+$/ || &error($text{'email_einterval'});
	$in{'percent'} =~ /^[0-9\.]+$/ || &error($text{'email_epercent'});
	$in{'domain'} =~ /^[a-z0-9\.\-]+$/i || &error($text{'email_edomain'});
	}

# Save settings
&lock_file($module_config_file);
$config{"email_".$in{'filesys'}} = $in{'email'};
$config{"email_interval_".$in{'filesys'}} = $in{'interval'};
$config{"email_type_".$in{'filesys'}} = $in{'type'};
$config{"email_percent_".$in{'filesys'}} = $in{'percent'};
$config{"email_domain_".$in{'filesys'}} = $in{'domain'};
&save_module_config();
&unlock_file($module_config_file);

# Create cron job, if needed
if ($in{'email'}) {
	$job = &find_email_job();
	if (!$job) {
		$job = { 'user' => 'root',
			 'command' => $email_cmd,
			 'active' => 1,
			 'mins' => '0',
			 'hours' => '*',
			 'days' => '*',
			 'months' => '*',
			 'weekdays' => '*' };
		&cron::create_cron_job($job);
		&cron::create_wrapper($email_cmd, $module_name, "email.pl");
		}
	}

&webmin_log("email", "user", $in{'filesys'}, \%in);
&redirect("list_users.cgi?dir=".&urlize($in{'filesys'}));

