#!/usr/local/bin/perl
# Remove firewall rules and syslog entry

require './bandwidth-lib.pl';
&ReadParse();
$access{'setup'} || &error($text{'turnoff_ecannot'});

# Remove firewall rules
@tables = &firewall::get_iptables_save();
($filter) = grep { $_->{'name'} eq 'filter' } @tables;
$inrule = &find_rule($filter, "INPUT", $config{'iface'}, "i");
$outrule = &find_rule($filter, "OUTPUT", $config{'iface'}, "o");
$fwdinrule = &find_rule($filter, "FORWARD", $config{'iface'}, "i");
$fwdoutrule = &find_rule($filter, "FORWARD", $config{'iface'}, "o");
$anyrule = $inrule || $outrule || $fwdinrule || $fwdoutrule;
if ($anyrule) {
	@{$filter->{'rules'}} = grep { $_ ne $inrule &&
				       $_ ne $outrule &&
				       $_ ne $fwdinrule &&
				       $_ ne $fwdoutrule }@{$filter->{'rules'}};

	# Save and apply firewall
	&lock_file($firewall::iptables_save_file);
	&firewall::run_before_command();
	&firewall::save_table($filter);
	&firewall::run_after_command();
	&unlock_file($firewall::iptables_save_file);
	if (defined(&firewall::apply_iptables)) {
		$err = &firewall::apply_iptables();
		}
	else {
		$err = &firewall::iptables_restore();
		}
	&error($err) if ($err);
	}

# Remove syslog entry
$conf = &syslog::get_config();
$sysconf = &find_sysconf($conf);
if ($sysconf) {
	&lock_file($syslog::config{'syslog_conf'});
	&syslog::delete_log($sysconf);
	&unlock_file($syslog::config{'syslog_conf'});
	$err = &syslog::restart_syslog();
	&error($err) if ($err);
	}

# Remove rotation cron job
$job = &find_cron_job();
if ($job) {
	&lock_file(&cron::cron_file($job));
	&cron::delete_cron_job($job);
	&unlock_file(&cron::cron_file($job));
	}

&webmin_log("turnoff");
&redirect("");

