/* -*- C++ -*-
 
  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
 
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 
*/

#include <Resistor.h>

#include <Strings.h>

#include "../images/resistor.xpm"

QPixmap* Resistor::pixmap_ = 0;

//-----------------------------------------------------------------
Resistor::Resistor( const QPoint& center )
    : Component( center )
{}

//-----------------------------------------------------------------
Resistor::~Resistor()
{}

//-----------------------------------------------------------------
const QString& Resistor::getCatagory() const
  {
    return Strings::LumpedCatagory;
  }

//-----------------------------------------------------------------
const QString& Resistor::getName() const
  {
    return Strings::ResistorName;
  }

//-----------------------------------------------------------------
const QPixmap& Resistor::getPixmap() const
  {
    if (!pixmap_)
      {
        pixmap_ = new QPixmap(resistor);
      }
    return *pixmap_;
  }

//-----------------------------------------------------------------
void Resistor::initComponent()
{
  boundingRect_ = QRect(-16, -6, 32, 12);
  addNode(-16,0);
  addNode(16,0);
  addAttribute( Strings::AttrResistance, "R" );
}

//-----------------------------------------------------------------
void Resistor::drawSymbol(QPainter* p)
{
  p->moveTo(-16,0);
  p->lineTo(-10,0);
  p->lineTo(-8, -6);
  p->lineTo(-4, 6);
  p->lineTo(0, -6);
  p->lineTo(4,6);
  p->lineTo(8,-6);
  p->lineTo(10,0);
  p->lineTo(16,0);
}

//-----------------------------------------------------------------
bool Resistor::initSweep()
{
  TReal r = r_;
  r_ = getAttributeValue( "R" );
  return (r_ != r);
}

//-----------------------------------------------------------------
void Resistor::addToAdmittanceMatrix( TReal, Matrix* yn )
{
  TComplex y( 1/r_, 0 );
  yn->insertComponent( y, node(0)->getNodeNumber(), node(1)->getNodeNumber() );
}
