/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef _H_DOCUMENT_POSITION
#define _H_DOCUMENT_POSITION

#include <Foundation/NSObject.h>
#include <Foundation/NSGeometry.h>


@interface DocumentPosition : NSObject
{
   int     page;
   NSRect  boundingRect;
}

- (id) initWithPage: (int)aPage boundingRect: (NSRect)rect;

+ (DocumentPosition*) positionAtPage: (int)aPage boundingRect: (NSRect)rect;

- (int) page;
- (void) setPage: (int)aPage;
- (NSRect) boundingRect;
- (void) setBoundingRect: (NSRect)rect;
@end

#endif
