/*
 * ===========================
 * VDK Builder
 * Version 0.1.1
 * Revision 0.0
 * March 1999
 * ===========================
 *
 * Copyright (C) 1998,1999 Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * Based on VDK Library
 * Copyright (C) 1998, Mario Motta
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 *
 */
#ifndef _vdkb_form
#define _vdkb_form
#include <vdk/forms.h>
#include <vdk/evlisthandle.h>
#include <vdk/siglisthandle.h>
#include <vdk/evhandle.h>
#include <vdkb2/vdkb_parser.h>
#include <vdkb2/vdkb_evbox.h>
#include <vdk/menu.h>
#include <vdkb2/vdkb_object.h>
#include <vdk/value_sem_list.h>
#include <vdkb2/vdkb_types.h>
class VDKBObjectInspector;
class VDKBConnection
{
 public:
  VDKString sender,signal,slot;
  bool declare;
  VDKBConnection(char* sender, char* signal,
		 char* slot, bool declare = true);
  ~VDKBConnection() {}
  bool operator==(VDKBConnection& c);
  bool operator<(VDKBConnection& c);
};

typedef VDKValueList<VDKBConnection> VDKBConnectionList;
typedef VDKValueListIterator<VDKBConnection> VDKBConnectionListIterator;

class VDKBPropDialog;
class VDKBObjectInspector;

/////////////////////////////////

class VDKBGuiForm:
public VDKForm, public VDKBObject

{
 protected:
  VDKString name,filename;
  VDKBEventBox* innerbox;
  VDKBPropDialog* dialog;
  void RecursiveShowBoxes(VDKBObject* parentobj,
			  EventBoxList& list, int depth = 0);
  VDKEntry* title,*pixfile,*focuswidget;
  VDKCheckButton *free_usize;
  VDKCombo *display_type,*winpos;
  VDKCustomButton *shortname, *set_dsp,*set_ip;
  VDKBObjectInspector* inspector;
  int form_type; // can be: type_vdk_form, type_vdk_gnomefor
 public:
  bool Changed;
  bool ForceToClose;
  VDKBObject* Active;
  VDKPoint DesignedSize;
  VDKBConnectionList SignalList;
  int FormType() { return form_type; }

  VDKBGuiForm(VDKForm* owner, char* name,
	      char* filename,
	      char* title = (char*) NULL,
	      int mode = v_box,
	      int type = type_vdk_form,
	      GtkWindowType display = GTK_WINDOW_TOPLEVEL);

  virtual ~VDKBGuiForm() {}
  void OnChildClosing(VDKForm* child);
  void Setup(void) {}
  virtual void Setup(VDKBParser& parser, char* formname);
  void SetupFormProperties(VDKBParser& parser,
				 char* formname);
  virtual void OnResize(VDKForm*,VDKPoint&);
  bool OnFocusIn(VDKObject*, GdkEvent* );
  bool OnFocusOut(VDKObject*, GdkEvent* );
  VDKString& Name() { return name; }
  VDKString& FileName() { return filename; }
  bool CanClose();
  void WriteFormFile();
  void WriteBoxesOnFrm(FILE* fp);
  void RecursiveWriteBoxesOnFrm(VDKBObject* parentobj,
				EventBoxList& list, FILE* fp);
  void MakeGuiObjects(VDKBParser& parser);
  // in vdkb_parser.cc
  void ReadSignals(VDKBParser& parser);
  void WriteSignals(FILE* fp);
  bool GenerateWidgetName(char* target,
			  const char* widget_class,
			  int* widget_counter);
  int AddToSelf(VDKBObject* widget,GdkEvent* ev);
  int AddContainerToSelf(VDKBEventContainer* widget,GdkEvent* ev);
  bool PackToSelf(VDKBObject* widget,
		  VDKBEventContainer* container,
		  char* buffer,
		  VDKBParser&  parser,
		  char* obj_parent = NULL);
  bool AddVBox(VDKObject*);
  bool AddHBox(VDKObject*);
  bool AddVFrame(VDKObject*);
  bool AddScrolled(VDKObject*);
  bool AddMenubar(VDKObject*);
  bool AddHPaned(VDKObject*);
  bool AddVPaned(VDKObject*);
  bool AddNotebook(VDKObject*);
  bool AddToolbar(VDKObject*);
  bool AddTable(VDKObject*);
  bool AddHandleBox(VDKObject*);
  bool AddVRadioBg(VDKObject*);
  bool AddHRadioBg(VDKObject*);
  //  bool AddPacker(VDKObject*);
  bool AddFixed(VDKObject*);
  bool AddStatusbar(VDKObject*);
#if HAVE_GNOME
  bool AddGnomeAppbar(VDKObject*);
#endif
  VDKBEventBox* InnerBox() { return innerbox; }
  void AddWidget(VDKObject* obj, int justify = l_justify,
		  int expand = TRUE, int fill = TRUE ,
		  int padding = 1, bool forceArgs = false);

  VDKObject* ChildWithName(char* name);
  VDKObject* RecursiveChildWithName(EventBoxList& list,char* name);
  void DisconnectWidget(VDKBObject* wid);
  void ChangeConnectionSenderName(VDKString& newname,
				  VDKString& oldname);
  bool OnButtonPress(VDKObject*, GdkEvent* ev);
  bool SetBoxSize(VDKObject* sender);
  bool ShowBoxes(VDKObject*);
  bool OnExpose(VDKObject*, GdkEvent*);
  bool HandleMinSize(VDKObject* ,GdkEvent* );
  bool HandleBeforeOnKeyRelease(VDKObject* sender, GdkEvent* ev);
  bool HandleCutAndPaste(VDKObject* sender, GdkEvent* ev);
  bool OnKey(VDKObject* sender, GdkEvent* event) ;
  bool OnKeyRelease(VDKObject* sender, GdkEvent* ev);
  bool HandleOnKey(VDKObject* sender, GdkEventKey* event);
  void CutWidget(VDKBObject* active);
  void PasteWidget();
  void ConnectToDrop(VDKObject* obj);
  bool OnDropSignal(VDKObject* sender);
  VDKObjectContainer* ExtraWidget(VDKBObjectInspector* isp);
  bool OnSetFormTitle(VDKObject*);
  bool OnSetGlyph(VDKObject*);
  bool OnSetShortName(VDKObject*);
  bool OnSetFocusWidget(VDKObject*);
  bool OnSetDisplayType(VDKObject*);
  bool OnSetInitialPosition(VDKObject*);
  bool OnSetFreeUsize(VDKObject*);
  DECLARE_EVENT_LIST(VDKBGuiForm);
  DECLARE_SIGNAL_LIST(VDKBGuiForm);
};

/*
size tip win
*/
class SizeTipWin: public VDKForm
{
  VDKLabel*  label;  
  char* tip;
public:
  SizeTipWin(VDKForm* owner, char* tip):
    VDKForm(owner,NULL,v_box,GTK_WINDOW_POPUP),tip(tip)
    {}
  ~SizeTipWin() {}
  void Setup(void);
  void Update(VDKPoint p);
};

#endif
