/* -*- mode: c; c-file-style: "gnu" -*-
 * worker.h -- Worker support code, prototypes
 * Copyright (C) 2003, 2004 Gergely Nagy <algernon@bonehunter.rulez.org>
 *
 * This file is part of Thy.
 *
 * Thy is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 dated June, 1991.
 *
 * Thy is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
 * License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

/** @file worker.h
 * Worker support code, prototypes.
 */

#ifndef _THY_WORKER_H
#define _THY_WORKER_H 1 /**< worker.h multi-inclusion guard. */

#include <inttypes.h>

int thy_worker_init (void);
int thy_worker_register (int idx, const char *fn);
int thy_worker_unregister (int idx);
ssize_t thy_worker_check (int fd, off_t spos, off_t epos);
void thy_worker_quit (void);

#endif /* !_THY_WORKER_H */
