# Author:: Nathaniel Talbott.
# Copyright:: Copyright (c) 2000-2002 Nathaniel Talbott. All rights reserved.
# License:: Ruby license.

$:.unshift("../../../lib")

require 'tc_testcase'
require 'test/unit/testresult'
require 'tc_assertions'
require 'tc_testresult'
require 'tc_testsuite'
require 'tc_error'
require 'util/ts_utilities'

module Test
  module Unit
    class TS_TestUnit
      def initialize
        @simple_tests = TC_TestCase.simple_suite
        @tests = [TC_Assertions.suite, 
          TC_TestResult.suite,
          TC_TestSuite.suite,
          TC_Error.suite,
          Util::TS_Utilities.suite]
      end
      
      def self.suite
        return new
      end
      
      def run(result, &progress_block)
        @simple_tests.each do |test|
          run_test(test, result, &progress_block)
        end
        
        @tests.each do |test|
          if ( test.respond_to?(:name) )
            run_test(test, result, &progress_block)
          else
            test.run(result, &progress_block)
          end
        end
      end
      
      def run_test(test, result, &progress_block)
        yield("Running #{test.name}...") if (block_given?)
        test.run(result, &progress_block)
      end
      
      def size
        size = 0
        @tests.each { |test| size += test.size }
        size
      end
      
      def to_s
        return "TS_TestUnit"
      end
    end
  end
end

if __FILE__ == $0
  require 'test/unit/ui/console/testrunner'
  exit(1) unless(Test::Unit::UI::Console::TestRunner.run(Test::Unit::TS_TestUnit).passed?)
end
