__revision__ = '$Id: __init__.py,v 1.8 2004/06/10 08:51:07 mbrown Exp $'

def PreprocessFiles(dirs, files):
    """
    PreprocessFiles(dirs, files) -> (dirs, files)

    This function is responsible for sorting and trimming the
    file and directory lists as needed for proper testing.
    """
    from Ft.Lib.TestSuite import RemoveTests, SortTests

    ignored_files = ['DatabaseModes',
                     'test_util']
    RemoveTests(files, ignored_files)

    ordered_files = []
    SortTests(files, ordered_files)

    ignored_dirs = ['Protocols']
    RemoveTests(dirs, ignored_dirs)

    ordered_dirs = ['Server',
                    'Common',
                    ]
    SortTests(dirs, ordered_dirs)

    return (dirs, files)
