

from Ft.Server.Common import AclConstants

from Ft.Server.Server import FtServerServerException, Error
import test_helper

def init(tester):
    tester.startTest("Init")
    repo = test_helper.GetRepo(tester)
    if repo.hasResource('/test'):
        t = repo.fetchResource('/test')
        t.delete()
    repo.createContainer("/test/cont",1)
    test = repo.fetchResource('/test')
    test.createUser('user1','user1')
    test.createUser('user2','user2')

    repo.txCommit()
    tester.testDone()
    


def test_acl_interfaces(tester):

    tester.startTest("Get ACL Interfaces")
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource("/test/cont")
    tester.compare(tester.test_data['userName'],cont.getAclIdent())
    tester.compareIn(cont.getAclIdentifiers(),tester.test_data['userName'])
    tester.compare(cont.getParent().getAcl(AclConstants.READ_ACCESS),cont.getAcl(AclConstants.READ_ACCESS))
    tester.testDone()

    tester.startTest("Set ACL Interfaces")
    cont = repo.fetchResource("/test/cont")
    cont.setAcl(AclConstants.READ_ACCESS,'user1')
    cont.setAcl(AclConstants.WRITE_ACCESS,'user1')
    cont.setAcl('foo','user1')
    tester.compare({'user1':AclConstants.ALLOWED},cont.getAcl(AclConstants.READ_ACCESS))
    tester.compare({'user1':AclConstants.ALLOWED},cont.getAcl(AclConstants.WRITE_ACCESS))
    tester.compare({'user1':AclConstants.ALLOWED},cont.getAcl('foo'))
    repo.txCommit()
    repo = test_helper.GetRepo(tester)
    cont = repo.fetchResource("/test/cont")
    tester.compare({'user1':AclConstants.ALLOWED},cont.getAcl(AclConstants.READ_ACCESS))
    tester.compare({'user1':AclConstants.ALLOWED},cont.getAcl(AclConstants.WRITE_ACCESS))
    tester.compare({'user1':AclConstants.ALLOWED},cont.getAcl('foo'))
    tester.testDone()

    tester.startTest("Add Interfaces")
    cont.addAcl(AclConstants.READ_ACCESS,'user2', AclConstants.DENIED)
    ra = cont.getAcl(AclConstants.READ_ACCESS)
    tester.compare(2,len(ra))
    tester.compareIn(ra.keys(),'user1')
    tester.compareIn(ra.keys(),'user2')
    tester.compare(ra['user1'],AclConstants.ALLOWED)
    tester.compare(ra['user2'],AclConstants.DENIED)
    tester.testDone()

    tester.startTest("Remove Interfaces")
    cont.removeAcl(AclConstants.READ_ACCESS,'user2')
    ra = cont.getAcl(AclConstants.READ_ACCESS)
    tester.compare(1,len(ra))
    tester.compareIn(ra.keys(),'user1')
    tester.compare(ra['user1'],AclConstants.ALLOWED)
    tester.testDone()

    repo.txRollback()






def Test(tester):

    init(tester)
    test_acl_interfaces(tester)



