from Ft.Lib.TestSuite import TestMode
from Ft.Server.Server.Commands import Init
from Ft.Server.Server import SCore, Drivers


g_configData = {}


class _DbMode(TestMode.TestMode):
    databaseInited = {}

    def __init__(self):
        self.dbName = 'test_db'
        TestMode.TestMode.__init__(self, self.driverName, self.default)

    def _pre(self, tester):
        tester.test_data['driver'] = self.driverName
        if not tester.test_data.has_key('userName'):
            u, p = ('root', 'root')
            tester.test_data['userName'] = u
            tester.test_data['password'] = p
        if not self.databaseInited.has_key(self.driverName):
            self.createRepo(tester)
            _DbMode.databaseInited[self.driverName] = 1
        return

    def createRepo(self, tester):
        self._properties = {'SystemContainer' : '/ftssSys',
                            'CoreId' : 'Core',
                            'XsltExtensionModule' : [],
                            }
        self._properties['Driver']= self._getDriverProperties()

        tester.test_data['properties'] = self._properties

        tester.startTest("Init new Repo")

        mod = Drivers.LoadDriverModule(self._properties['Driver']['TYPE'])

        uname, passwd = tester.test_data['userName'], tester.test_data['password']
        Init.DoInit(self._properties,
                    uname,
                    passwd,
                    ['core'],
                    quiet = 1,
                    confirm = 0,
                    destroyRepo = mod.Exists(self._properties['Driver']) >= 0,
                    users = [(uname, passwd)],
                    )
        tester.testDone()


class _FlatFileMode(_DbMode):
    driverName = 'FlatFile'
    default = True
    def _getDriverProperties(self):
        return {'TYPE': 'FlatFile', 'Root': 'testserver'}


class _BerkeleyDBMode(_DbMode):
    driverName = 'BerkeleyDB'
    try:
        Drivers.LoadDriverModule(driverName)
    except:
        default = False
    else:
        default = True
    def _getDriverProperties(self):
        return {'TYPE': 'BerkeleyDB',
                'Root': 'testserver',
                'OneMBDocuments':'false',
                'DataStoreContainers':'false',
                'DbXml': 'false',
                }


class _MySQLMode(_DbMode):
    driverName = 'MySQL'
    default = False
    def _getDriverProperties(self):
        return {'TYPE': 'MySQL',
                'DbName': 'testserver',
                'Host': 'localhost',
                'Port': -1,
                'User': 'root',
                'Passwd': "",
                }


class _PostgresMode(_DbMode):
    driverName = 'Postgres'
    try:
        Drivers.LoadDriverModule(driverName)
    except:
        default = False
    else:
        default = True
    def _getDriverProperties(self):
        return {'TYPE': 'Postgres',
                'DbName': 'testserver',
                'Host': None,
                'Port': -1,
                'User': None,
                'Passwd': None,
                }
