


from Ft.Rdf.Parsers import Versa
from Ft.Rdf.Parsers.Versa import BooleanFunctions, Traversal

import test_helper

def test_is_resource(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()-ft:spouse->isResource()"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res, u"http://foo.com#jolson")
    tester.testDone()

    exp = "isResource(resource(foo:molson))"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, res)
    tester.testDone()

    exp = "isResource(resource(foo:molson)-dc:Title->*)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, res)
    tester.testDone()


def test_is_type(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()-ft:spouse->isType(ft:Female)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res, u"http://foo.com#jolson")
    tester.testDone()


    exp = "isType(resource(foo:molson), ft:Person)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, res)
    tester.testDone()

    exp = "isType(resource(foo:molson)-ft:spouse->*, ft:Male)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, res)
    tester.testDone()


def test_is_literal(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    exp = "all()-ft:spouse->isLiteral()"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, len(res))
    tester.testDone()

    exp = "all()-ft:spouse->*-dc:Title->isLiteral()"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res, u'Jessica Olson')
    tester.testDone()

    exp = "isLiteral(resource(foo:molson)-dc:Title->*)"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, res)
    tester.testDone()

    exp = "isLiteral(resource(foo:molson))"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(0, res)
    tester.testDone()


def test_and(tester,model):

    nsMap = {'ft':'http://fourthought.com#',
             'foo':'http://foo.com#',
             'dc':'http://purl.org/dc/elements/1.1#',
             'vcard':'http://4suite.org/nexus/rdfs/vcard#',
             }


    con = Versa.CreateContext(model = model,
                              nsMapping = nsMap)

    tester.startGroup("and")

    #Why start easy :)
    exp = "(resource(@'http://foo.com#molson')-ft:telephone->and(isType(vcard:work), isType(vcard:voice)))-rdf:value->*"
    tester.startTest(exp)
    exp = Versa.Compile(exp)
    res = exp.evaluate(con)
    tester.compare(1, len(res))
    tester.compareIn(res, u'555-1212')
    tester.testDone()

    tester.groupDone()
    

def Test(tester):
    model = test_helper.init(tester)
    test_is_resource(tester,model)
    test_is_type(tester,model)
    test_is_literal(tester,model)
    test_and(tester,model)


if __name__ == '__main__':
    from Ft.Lib.TestSuite import Tester
    tester = Tester.Tester()
    Test(tester)
    
