<?xml version="1.0"?>
<!DOCTYPE xsl:stylesheet [
	<!ENTITY nbsp "&#160;">
	<!ENTITY rdf "http://www.w3.org/1999/02/22-rdf-syntax-ns#">
	<!ENTITY rdfs "http://www.w3.org/2000/01/rdf-schema#">
	<!ENTITY f "http://xmlns.4suite.org/ext">
	<!ENTITY fres "http://xmlns.4suite.org/reserved">
	<!ENTITY dc "http://purl.org/dc/elements/1.1/">
	<!ENTITY fschema "http://schemas.4suite.org/4ss">
]>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fcore="http://xmlns.4suite.org/4ss/score" xmlns:frdf="http://xmlns.4suite.org/4ss/rdf" xmlns:fhttp="http://xmlns.4suite.org/4ss/http" xmlns:exslt="http://exslt.org/common" xmlns:exslt-set="http://exslt.org/sets" xmlns:exslt-math="http://exslt.org/math" xmlns:exslt-functions="http://exslt.org/functions" xmlns:exslt-date-time="http://exslt.org/dates-and-times" xmlns:dc="&dc;" xmlns:fres="&fres;" xmlns:rdf="&rdf;" xmlns:f="&f;" xmlns:fschema="http://schemas.4suite.org/4ss" extension-element-prefixes="f frdf fhttp fcore exslt exslt-set exslt-math exslt-functions exslt-date-time">
	<!--
File:  index.xslt

Description:

    This is the main entry point into the Dask board.


WWW: http://4suite.org        e-mail: support@4suite.org

Copyright 2001-2002 Fourthought Inc, USA.
See  http://4suite.org/COPYRIGHT  for license and copyright information

  -->
   <xsl:template name="rawfile-manager">
     <xsl:variable name="imt" select="frdf:complete($resourcePath,'http://schemas.4suite.org/4ss#rawfile.imt','')/Object"/>
     <xsl:variable name="helpText">
       <xsl:choose>
         <xsl:when test='starts-with($imt,"text")'>
Either enter the text (or xml) for this resource or a local file to upload.  If you do both, the file contents will be used        
         </xsl:when>
         <xsl:otherwise>
Select a file to upload for this resource
         </xsl:otherwise>
       </xsl:choose>
     </xsl:variable>
     <table class="normal" cellpadding="4" cellspacing="1" width="100%">
       <xsl:if test='$resourceType = "http://schemas.4suite.org/4ss#xsltdocument"'>
         <tr>
           <td>
             <table cellspacing="5">
               <tr>
                 <td colspan="2">4Suite Namespace Prefix Conventions:</td>
               </tr>
               <tr>
                 <th align="right">Prefix</th>
                 <th align="left">Namespace</th>
               </tr>
               <tr>
                 <td align="right" class="grayBar">fcore</td>
                 <td>http://xmlns.4suite.org/4ss/score</td>
               </tr>
               <tr>
                 <td class="grayBar" align="right">fhttp</td>
                 <td>http://xmlns.4suite.org/4ss/http</td>
               </tr>
               <tr>
                 <td class="grayBar" align="right">frdf</td>
                 <td>http://xmlns.4suite.org/4ss/rdf</td>
               </tr>
               <tr>
                 <td class="grayBar" align="right">f</td>
                 <td>http://xmlns.4suite.org/ext</td>
               </tr>
               <tr>
                 <td class="grayBar" align="right">fres </td>
                 <td>http://xmlns.4suite.org/reserved</td>
               </tr>
               <tr>
                 <td class="grayBar" align="right">fschema</td>
                 <td>http://schemas.4suite.org/4ss</td>
               </tr>
             </table>
           </td>
         </tr>
       </xsl:if>
       <tr>
         <td colspan="2">
           <span class="blackTitle">Editing Content</span>
         </td>
       </tr>
       <xsl:if test="starts-with($imt,'text')">
         <!-- Its a test-based resource, put up an edit field-->
         <tr>
           <td>
             <textarea COLS="120" ROWS="20" name="textAreaSrc">
               <xsl:value-of select="fcore:get-content($resourcePath)"/>
             </textarea>
           </td>
         </tr>
       </xsl:if>
       <tr>
         <td>
           <input type="file" name="fileSrc" size="40"/>
         </td>
       </tr>
       <tr>
         <td>
           <xsl:value-of select="$helpText"/>
         </td>
         <input type="hidden" name="action" value="changeRawFile"/>
         <input type="hidden" name="managedResourcePath" value="{$resourcePath}"/>
       </tr>
       <tr>
         <td>
           <input type="submit" name="submit" value="Change {$resourcePath}"/>
         </td>
         <td/>
       </tr>
     </table>
   </xsl:template>
</xsl:stylesheet>
