########################################################################
# $Header: /var/local/cvsroot/4Suite/Ft/Server/Client/Commands/Login.py,v 1.13 2004/09/22 21:27:43 mbrown Exp $
"""
Implementation of '4ss login' command
(functions defined here are used by the Ft.Lib.CommandLine framework)

Copyright 2004 Fourthought, Inc. (USA).
Detailed license and copyright information: http://4suite.org/COPYRIGHT
Project home, documentation, distributions: http://4suite.org/
"""

from Ft.Server.Common import ClAuthenticate

__doc__ = """This command will associate a password hash, hostname and \
port with a username, storing the info in a password file on the \
local filesystem. Subsequent invocations of 4ss command-line scripts \
can then automatically look up access info for connecting to a \
repository. The location of the password file is determined by the \
FTSS_PASSWORD_FILE environment variable. If not set, then the location \
is assumed to be a file named '%s' in the directory determined by the \
environment variable HOME (on Unix) or HOMEPATH (on Windows), or the \
environment variable WINDIR (on Windows) (one must be set). If the \
password file does not exist, it will be created when the first entry \
is stored. The location must be writable by the user invoking the \
command. At this time, this command does NOT verify that the username, \
password hash, hostname and port combination is valid; no repository \
connection is made.""" % ClAuthenticate.default_passwdFilename

from Ft.Server.Client.Core import FTRPC_HOST, FTRPC_PORT


def TextLogin(options, args):

    userName = args.get('username')
    if not userName:
        userName = ClAuthenticate.GetUserName(
            prompt='Username for which to set defaults: ', emptyOK=False)

    while True:
        passwd = ClAuthenticate.GetPass('Default password for %s: ' % userName)
        passwd2 = ClAuthenticate.GetPass('Re-enter password to confirm: ')
        if passwd == passwd2:
            break
        else:
            sys.stderr.write('Passwords did not match. Please try again.\n')
            sys.stderr.flush()

    passwdHash = ClAuthenticate.HashPasswd(passwd)

    host = ClAuthenticate.GetHostName('Default host for %s <%s>: ' % (userName, FTRPC_HOST))
    host = host or FTRPC_HOST
    port = ClAuthenticate.GetPort('Default port for %s <%i>: ' % (userName, FTRPC_PORT))
    try:
        port = int(port or FTRPC_PORT)
    except ValueError:
        raise ValueError('Invalid port %r' % port)

    mang = ClAuthenticate.PasswordFileManager()
    mang.setUserEntry(userName, passwdHash, host, port)
    return


def Register():
    from Ft.Lib.CommandLine import Options, Command, Arguments
    cmd = Command.Command('login',
                          'Associate a default password, host, port with a username',
                          '',
                          __doc__,
                          function = TextLogin,
                          arguments = [Arguments.OptionalArgument('username',
                                                                  'User for which to set defaults',
                                                                  str),
                                       ],
                          fileName = __file__,
                          )
    return cmd
