/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.web.filter;

import com.opensymphony.oscache.web.filter.ResponseContent;
import com.opensymphony.oscache.web.filter.SplitServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CacheHttpServletResponseWrapper
extends HttpServletResponseWrapper {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private PrintWriter cachedWriter;
    private ResponseContent result = new ResponseContent();
    private SplitServletOutputStream cacheOut = null;
    private int status = 200;

    public CacheHttpServletResponseWrapper(HttpServletResponse response) {
        super(response);
    }

    public ResponseContent getContent() {
        this.result.commit();
        return this.result;
    }

    public void setContentType(String value) {
        super.setContentType(value);
        this.result.setContentType(value);
    }

    public void setDateHeader(String name, long value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("dateheader: " + name + ": " + value));
        }
        super.setDateHeader(name, value);
    }

    public void setHeader(String name, String value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("header: " + name + ": " + value));
        }
        super.setHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("intheader: " + name + ": " + value));
        }
        super.setIntHeader(name, value);
    }

    public void setStatus(int status) {
        super.setStatus(status);
        this.status = status;
    }

    public void sendError(int status, String string) throws IOException {
        super.sendError(status, string);
        this.status = status;
    }

    public void sendError(int status) throws IOException {
        super.sendError(status);
        this.status = status;
    }

    public void setStatus(int status, String string) {
        super.setStatus(status, string);
        this.status = status;
    }

    public void sendRedirect(String location) throws IOException {
        this.status = 302;
        super.sendRedirect(location);
    }

    public int getStatus() {
        return this.status;
    }

    public void setLocale(Locale value) {
        super.setLocale(value);
        this.result.setLocale(value);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.cacheOut == null) {
            this.cacheOut = new SplitServletOutputStream(this.result.getOutputStream(), (OutputStream)super.getOutputStream());
        }
        return this.cacheOut;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.cachedWriter == null) {
            this.cachedWriter = new PrintWriter((OutputStream)this.getOutputStream());
        }
        return this.cachedWriter;
    }

    public void flushBuffer() throws IOException {
        super.flushBuffer();
        if (this.cacheOut != null) {
            this.cacheOut.flush();
        }
        if (this.cachedWriter != null) {
            this.cachedWriter.flush();
        }
    }
}

