/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.javagroups.log.Trace;
import org.javagroups.persistence.CannotConnectException;
import org.javagroups.persistence.CannotCreateSchemaException;
import org.javagroups.persistence.CannotPersistException;
import org.javagroups.persistence.CannotRemoveException;
import org.javagroups.persistence.CannotRetrieveException;
import org.javagroups.persistence.PersistenceManager;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DBPersistenceManager
implements PersistenceManager {
    private static final String tabName = "replhashmap";
    private static final String insertStat = "insert into replhashmap(key, keyBin, valBin) values  (?, ?, ?)";
    private static final String updateStat = "update replhashmap set keyBin = ?, valBin = ? where key like ?";
    private static final String removeStat = " delete from replhashmap where key like ?";
    private static final String createTableGen = " create table replhashmap(key varchar, keyBin varbinary, valBin varbinary)";
    private static final String createTableOra = " create table replhashmap ( key varchar2(100), keyBin blob, valBin blob)";
    private Properties props;
    private String driverName;
    private String userName;
    private String userPass;
    private String connStr;
    private String createTable;
    private boolean oracleDB;
    private Vector list;
    static /* synthetic */ Class class$org$javagroups$persistence$DBPersistenceManager;

    protected void init(InputStream in) throws Exception {
        this.list = new Vector();
        this.readProps(in);
        this.loadDriver();
        Connection conn = this.getConnection();
        this.closeConnection(conn);
        this.createDBTables();
        this.retrieveAll();
        System.err.println(" Done constructing DB Persist Manager");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(Serializable key, Serializable val) throws CannotPersistException {
        if (!this.entryExists(key)) {
            System.err.println(" entry doesnt exist for " + key.toString());
            try {
                this.addNewEntry(key, val);
                this.list.add(key.toString());
                return;
            }
            catch (Throwable t1) {
                t1.printStackTrace();
                throw new CannotPersistException(t1, " error adding a completely new entry in to DB ");
            }
        }
        Connection conn = null;
        Statement prepStat = null;
        try {
            try {
                conn = this.getConnection();
                Object stat = null;
                String keyStr = null;
                keyStr = key.toString();
                byte[] keyBytes = this.getBytes(key);
                byte[] valBytes = this.getBytes(val);
                System.err.println(" value is " + val);
                prepStat = conn.prepareStatement(updateStat);
                prepStat.setString(3, keyStr);
                prepStat.setBytes(1, keyBytes);
                prepStat.setBytes(2, valBytes);
                prepStat.executeQuery();
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new CannotPersistException(t, "error updating an existing entry in to the database ");
            }
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                if (prepStat != null) {
                    prepStat.close();
                }
                this.closeConnection(conn);
                throw throwable;
            }
            catch (Throwable t) {
                conn = null;
                prepStat = null;
            }
            throw throwable;
        }
        {
            Object var6_13 = null;
        }
        try {}
        catch (Throwable t) {
            return;
        }
        if (prepStat != null) {
            prepStat.close();
        }
        this.closeConnection(conn);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable remove(Serializable key) throws CannotRemoveException {
        Connection conn = null;
        Statement stat = null;
        PreparedStatement prepStat = null;
        ResultSet set = null;
        Serializable val = null;
        try {
            conn = this.getConnection();
            stat = conn.createStatement();
            String exQuery = " select * from replhashmap where key like '" + key.toString() + '\'';
            set = stat.executeQuery(exQuery);
            set.next();
            val = this.getSerializable(set.getBinaryStream(3));
        }
        catch (Throwable t3) {
            t3.printStackTrace();
            throw new CannotRemoveException(t3, " Error retrieving value for given key");
        }
        try {
            try {
                conn = this.getConnection();
                prepStat = conn.prepareStatement(removeStat);
                prepStat.setString(1, key.toString());
                prepStat.executeQuery();
                this.list.remove(key.toString());
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new CannotRemoveException(t, "Could not remove existing entry due to error in jdbc transaction");
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            try {
                set.close();
                stat.close();
                if (prepStat != null) {
                    prepStat.close();
                }
                this.closeConnection(conn);
                throw throwable;
            }
            catch (Throwable t) {
                conn = null;
                stat = null;
            }
            throw throwable;
        }
        {
            Object var8_12 = null;
        }
        try {}
        catch (Throwable t) {
            conn = null;
            stat = null;
            return val;
        }
        set.close();
        stat.close();
        if (prepStat != null) {
            prepStat.close();
        }
        this.closeConnection(conn);
        return val;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void saveAll(Map map) throws CannotPersistException {
        iter = null;
        try {
            keySet = map.keySet();
            iter = keySet.iterator();
            if (true) ** GOTO lbl17
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CannotPersistException(t, "Error with the map entered to saveAll");
        }
        do {
            try {
                key = (Serializable)iter.next();
                val = (Serializable)map.get(key);
                this.save(key, val);
            }
            catch (Throwable t2) {
                t2.printStackTrace();
            }
lbl17:
            // 3 sources

        } while (iter.hasNext());
    }

    public synchronized Map retrieveAll() throws CannotRetrieveException {
        Connection conn = null;
        Statement stat = null;
        ResultSet set = null;
        Map map = null;
        try {
            conn = this.getConnection();
            stat = conn.createStatement();
            set = stat.executeQuery(" select * from replhashmap");
            map = this.retrieveAll(set);
        }
        catch (Throwable t) {
            throw new CannotRetrieveException(t, "Error happened while querying the database for bulk retrieve, try starting DB manually");
        }
        try {
            stat.close();
            this.closeConnection(conn);
        }
        catch (Throwable t1) {
            // empty catch block
        }
        return map;
    }

    private final Map retrieveAll(ResultSet result) throws Exception {
        HashMap<Serializable, Serializable> map = new HashMap<Serializable, Serializable>();
        while (result.next()) {
            InputStream inputStrKey = result.getBinaryStream(2);
            InputStream inputStrVal = result.getBinaryStream(3);
            Serializable key = this.getSerializable(inputStrKey);
            Serializable val = this.getSerializable(inputStrVal);
            map.put(key, val);
            this.list.add(key.toString());
        }
        return map;
    }

    public void clear() throws CannotRemoveException {
        Connection conn = null;
        Statement stat = null;
        try {
            conn = this.getConnection();
            stat = conn.createStatement();
            stat.executeQuery("delete from replhashmap");
        }
        catch (Throwable t) {
            throw new CannotRemoveException(t, " delete all query failed with existing database");
        }
        try {
            stat.close();
            this.closeConnection(conn);
        }
        catch (Throwable t) {
            conn = null;
            stat = null;
        }
    }

    public void shutDown() {
    }

    private final void addNewEntry(Serializable key, Serializable val) throws CannotPersistException, CannotConnectException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStat = conn.prepareStatement(insertStat);
            prepStat.setString(1, key.toString());
            byte[] keyBytes = this.getBytes(key);
            byte[] valBytes = this.getBytes(val);
            prepStat.setBytes(2, keyBytes);
            prepStat.setBytes(3, valBytes);
            prepStat.executeQuery();
            conn.commit();
            System.err.println(" executing insert insert into replhashmap(key, keyBin, valBin) values  (?, ?, ?)");
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CannotPersistException(t, "error adding new entry using creating Db connection and schema");
        }
    }

    private final InputStream getBinaryInputStream(Serializable ser) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream keyoos = new ObjectOutputStream(stream);
        keyoos.writeObject(ser);
        ByteArrayInputStream pipe = new ByteArrayInputStream(stream.toByteArray());
        return pipe;
    }

    private final Serializable getSerializable(InputStream stream) throws Exception {
        ObjectInputStream ooStr = new ObjectInputStream(stream);
        Serializable tmp = (Serializable)ooStr.readObject();
        return tmp;
    }

    private final void addNewEntryGen(Serializable key, Serializable val) throws CannotPersistException, CannotConnectException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStat = conn.prepareStatement(insertStat);
            prepStat.setString(1, key.toString());
            prepStat.setBytes(2, this.getBytes(key));
            prepStat.setBytes(3, this.getBytes(val));
            prepStat.executeUpdate();
        }
        catch (Throwable t) {
            throw new CannotPersistException(t, "error adding new entry using creating Db connection and schema");
        }
    }

    private final void addNewEntryOra(Serializable key, Serializable val) throws CannotPersistException, CannotConnectException {
        Connection conn = this.getConnection();
        try {
            PreparedStatement prepStat = conn.prepareStatement(insertStat);
            prepStat.setString(1, key.toString());
            InputStream keyBin = this.getBinaryInputStream(key);
            InputStream keyVal = this.getBinaryInputStream(val);
            byte[] keyBytes = this.getBytes(key);
            byte[] valBytes = this.getBytes(val);
            prepStat.setBytes(2, keyBytes);
            prepStat.setBytes(3, valBytes);
            prepStat.executeBatch();
        }
        catch (Throwable t) {
            throw new CannotPersistException(t, "error adding new entry using creating Db connection and schema");
        }
    }

    private final boolean entryExists(Serializable key) {
        return this.list.contains(key.toString());
    }

    private final byte[] getBytes(Serializable ser) throws Exception {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream keyoos = new ObjectOutputStream(stream);
        keyoos.writeObject(ser);
        byte[] keyBytes = stream.toByteArray();
        return keyBytes;
    }

    private final void readProps(String filePath) throws Exception {
        FileInputStream _stream = new FileInputStream(filePath);
        this.props = new Properties();
        this.props.load(_stream);
        this.driverName = this.props.getProperty("jdbc.Driver");
        this.connStr = this.props.getProperty("jdbc.Conn").trim();
        this.userName = this.props.getProperty("jdbc.User").trim();
        this.userPass = this.props.getProperty("jdbc.Pass").trim();
        this.createTable = this.props.getProperty("jdbc.table").trim();
    }

    private final void readProps(InputStream input) throws Exception {
        this.props = new Properties();
        this.props.load(input);
        this.driverName = this.props.getProperty("jdbc.Driver");
        this.connStr = this.props.getProperty("jdbc.Conn");
        this.userName = this.props.getProperty("jdbc.User");
        this.userPass = this.props.getProperty("jdbc.Pass");
        this.createTable = this.props.getProperty("jdbc.table");
    }

    private final void loadDriver() throws Exception {
        Class.forName(this.driverName);
    }

    /*
     * WARNING - void declaration
     */
    private final Connection getConnection() throws CannotConnectException {
        try {
            void t;
            this.connStr = this.connStr.trim();
            Connection conn = DriverManager.getConnection(this.connStr, this.userName, this.userPass);
            if (Trace.trace) {
                Trace.info("DBPersistenceManager.getConnection()", "userName=" + this.userName + ", userPass=" + this.userPass + ", connStr=" + this.connStr);
            }
            return t;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new CannotConnectException(t, "Error in creating connection using provided properties ");
        }
    }

    private final void closeConnection(Connection conn) {
        try {
            conn.close();
            conn = null;
        }
        catch (Throwable t) {
            conn = null;
        }
    }

    private final void createDBTables() throws CannotCreateSchemaException, CannotConnectException {
        Connection conn = this.getConnection();
        Statement stat = null;
        try {
            stat = conn.createStatement();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CannotConnectException(e, "there was an error in creating statements for persisting data using created connection");
        }
        try {
            ResultSet set = stat.executeQuery("select * from replhashmap");
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.addSchemaToDB(conn);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void addSchemaToDB(Connection conn) throws CannotCreateSchemaException {
        Statement stat = null;
        Object stat2 = null;
        try {
            try {
                stat = conn.createStatement();
                System.err.println(" executing query for oracle " + this.createTable);
                stat.executeQuery(this.createTable);
            }
            catch (Throwable t) {
                t.printStackTrace();
                throw new CannotCreateSchemaException(t, "error was using schema with blobs");
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (stat != null) {
                    stat.close();
                }
                this.closeConnection(conn);
                throw throwable;
            }
            catch (Throwable t3) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Throwable t3) {
            return;
        }
        if (stat != null) {
            stat.close();
        }
        this.closeConnection(conn);
    }

    static /* synthetic */ Class class$(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.props = null;
        this.driverName = null;
        this.userName = null;
        this.userPass = null;
        this.connStr = null;
        this.createTable = null;
        this.oracleDB = false;
        this.list = null;
    }

    public DBPersistenceManager(String filename) throws Exception {
        this.this();
        String home_dir = System.getProperty("user.home");
        try {
            home_dir = home_dir + '/' + filename;
            this.init(new FileInputStream(home_dir));
            return;
        }
        catch (Exception in) {
            try {
                Class clazz = class$org$javagroups$persistence$DBPersistenceManager;
                if (clazz == null) {
                    clazz = class$org$javagroups$persistence$DBPersistenceManager = DBPersistenceManager.class$("[Lorg.javagroups.persistence.DBPersistenceManager;", false);
                }
                if ((in = clazz.getResourceAsStream("/" + filename)) != null) {
                    this.init(in);
                    return;
                }
            }
            catch (Exception x) {
                Trace.error("DBPersistenceManager.DBPersistenceManager()", "failed reading database properties from " + filename + ", exception=" + x);
            }
            try {
                home_dir = System.getProperty("persist.properties");
                this.init(new FileInputStream(home_dir));
                return;
            }
            catch (Exception exception) {
                throw new Exception("DBPersistenceManager.DBPersistenceManager(): failed reading database properties from " + filename);
            }
        }
    }

    public DBPersistenceManager(InputStream input) throws Exception {
        this.this();
        this.init(input);
    }
}

