/*
 * Decompiled with CFR 0.152.
 */
package org.javagroups.demos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.javagroups.View;
import org.javagroups.blocks.ReplicatedTree;

public class ReplicatedTreeDemo {
    public static void main(String[] args) {
        String start_directory = null;
        String props = "UDP(mcast_addr=224.0.0.36;mcast_port=55566;ip_ttl=32;mcast_send_buf_size=150000;mcast_recv_buf_size=80000):PING(timeout=2000;num_initial_members=3):MERGE2(min_interval=5000;max_interval=10000):FD_SOCK:VERIFY_SUSPECT(timeout=1500):pbcast.NAKACK(gc_lag=50;retransmit_timeout=600,1200,2400,4800):UNICAST(timeout=600,1200,2400,4800):pbcast.STABLE(desired_avg_gossip=20000):FRAG(frag_size=16000;down_thread=false;up_thread=false):pbcast.GMS(join_timeout=5000;join_retry_timeout=2000;shun=false;print_local_addr=true):pbcast.STATE_TRANSFER";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-props")) {
                props = args[++i];
            } else if (args[i].equals("-start_directory")) {
                start_directory = args[++i];
            } else {
                ReplicatedTreeDemo.help();
                return;
            }
            ++i;
        }
        try {
            ReplicatedTree tree = new ReplicatedTree("ReplicatedTreeDemo-Group", props, 10000L);
            ReplicatedTreeView demo = new ReplicatedTreeView(tree, tree.getLocalAddress());
            if (start_directory != null && start_directory.length() > 0) {
                ReplicatedTreeDemo.populateTree(tree, start_directory);
            }
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    static void help() {
        System.out.println("ReplicatedTreeView [-help] [-props <channel properties>] [-start_directory <dirname>]");
    }

    static void populateTree(ReplicatedTree tree, String dir) {
        String[] children;
        File file = new File(dir);
        if (!file.exists()) {
            return;
        }
        tree.put(dir, null);
        if (file.isDirectory() && (children = file.list()) != null && children.length > 0) {
            int i = 0;
            while (i < children.length) {
                ReplicatedTreeDemo.populateTree(tree, dir + '/' + children[i]);
                ++i;
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    static class ReplicatedTreeView
    extends JFrame
    implements WindowListener,
    ReplicatedTree.ReplicatedTreeListener,
    TreeSelectionListener,
    TableModelListener {
        static String SEP = "/";
        DefaultTreeModel tree_model;
        JTree jtree;
        DefaultTableModel table_model;
        JTable table;
        MyNode root;
        String props;
        String selected_node;
        ReplicatedTree tree;
        JPanel tablePanel;
        JMenu operationsMenu;
        JPopupMenu operationsPopup;
        JMenuBar menubar;
        private final int KEY_COL_WIDTH = 20;
        private final int VAL_COL_WIDTH = 300;

        public void windowClosed(WindowEvent event) {
        }

        public void windowDeiconified(WindowEvent event) {
        }

        public void windowIconified(WindowEvent event) {
        }

        public void windowActivated(WindowEvent event) {
        }

        public void windowDeactivated(WindowEvent event) {
        }

        public void windowOpened(WindowEvent event) {
        }

        public void windowClosing(WindowEvent event) {
            System.exit(0);
        }

        public void tableChanged(TableModelEvent evt) {
            if (evt.getType() == 0) {
                int row = evt.getFirstRow();
                int col = evt.getColumn();
                if (col == 0) {
                    String key = (String)this.table_model.getValueAt(row, col);
                    String val = (String)this.table_model.getValueAt(row, col + 1);
                    if (key != null && val != null) {
                        this.tree.put(this.selected_node, key, val);
                    }
                } else {
                    String key = (String)this.table_model.getValueAt(row, col - 1);
                    String val = (String)this.table.getValueAt(row, col);
                    if (key != null && val != null) {
                        this.tree.put(this.selected_node, key, val);
                    }
                }
            }
        }

        public void valueChanged(TreeSelectionEvent evt) {
            TreePath path = evt.getPath();
            String fqn = SEP;
            HashMap data = null;
            int i = 0;
            while (i < path.getPathCount()) {
                String component_name = ((MyNode)path.getPathComponent((int)i)).name;
                if (!component_name.equals(SEP)) {
                    fqn = fqn.equals(SEP) ? fqn + component_name : fqn + SEP + component_name;
                }
                ++i;
            }
            data = this.getData(this.tree, fqn);
            if (data != null) {
                this.getContentPane().add((Component)this.tablePanel, "South");
                this.populateTable(data);
                this.validate();
            } else {
                this.clearTable();
                this.getContentPane().remove(this.tablePanel);
                this.validate();
            }
        }

        public void nodeAdded(String fqn) {
            MyNode n = this.root.add(fqn);
            if (n != null) {
                MyNode p = (MyNode)n.getParent();
                this.tree_model.reload(p);
                this.jtree.scrollPathToVisible(new TreePath(n.getPath()));
            }
        }

        public void nodeRemoved(String fqn) {
            MyNode n = this.root.findNode(fqn);
            if (n != null) {
                n.removeAllChildren();
                TreeNode par = n.getParent();
                n.removeFromParent();
                this.tree_model.reload(par);
            }
        }

        public void nodeModified(String fqn) {
            HashMap data = this.getData(this.tree, fqn);
        }

        public void viewChange(View new_view) {
            Vector mbrship;
            if (new_view != null && (mbrship = new_view.getMembers()) != null) {
                this.tree._put(SEP, "members", mbrship);
                this.tree._put(SEP, "coordinator", mbrship.firstElement());
            }
        }

        public void run() {
        }

        void init() {
            Vector mbrship = null;
            this.addGuiNode(SEP);
            Vector vector = mbrship = this.tree != null && this.tree.getMembers() != null ? (Vector)this.tree.getMembers().clone() : null;
            if (mbrship != null) {
                this.tree._put(SEP, "members", mbrship);
                this.tree._put(SEP, "coordinator", mbrship.firstElement());
            }
        }

        private final void populateTree() {
            this.addGuiNode(SEP);
        }

        void addGuiNode(String fqn) {
            if (fqn == null) {
                return;
            }
            this.root.add(fqn);
            Set children = this.tree.getChildrenNames(fqn);
            if (children != null) {
                Iterator it = children.iterator();
                while (it.hasNext()) {
                    String child_name = (String)it.next();
                    this.addGuiNode(fqn + SEP + child_name);
                }
            }
        }

        String makeFQN(Object[] path) {
            String tmp_name;
            StringBuffer sb = new StringBuffer("");
            if (path == null) {
                return null;
            }
            int i = 0;
            while (i < path.length) {
                tmp_name = ((MyNode)path[i]).name;
                if (!tmp_name.equals(SEP)) {
                    sb.append(SEP + tmp_name);
                }
                ++i;
            }
            tmp_name = sb.toString();
            if (tmp_name.length() == 0) {
                return SEP;
            }
            return tmp_name;
        }

        void clearTable() {
            int num_rows = this.table.getRowCount();
            if (num_rows > 0) {
                int i = 0;
                while (i < num_rows) {
                    this.table_model.removeRow(0);
                    ++i;
                }
                this.table_model.fireTableRowsDeleted(0, num_rows - 1);
                this.repaint();
            }
        }

        void populateTable(HashMap data) {
            String strval = "<null>";
            int num_rows = 0;
            if (data == null) {
                return;
            }
            num_rows = data.size();
            this.clearTable();
            if (num_rows > 0) {
                Iterator it = data.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String key = (String)entry.getKey();
                    Object val = entry.getValue();
                    if (val != null) {
                        strval = val.toString();
                    }
                    this.table_model.addRow(new Object[]{key, strval});
                }
                this.table_model.fireTableRowsInserted(0, num_rows - 1);
                this.validate();
            }
        }

        private final void setTableColumnWidths() {
            this.table.sizeColumnsToFit(1);
            TableColumn column = null;
            column = this.table.getColumnModel().getColumn(0);
            column.setMinWidth(20);
            column.setPreferredWidth(20);
            column = this.table.getColumnModel().getColumn(1);
            column.setPreferredWidth(300);
        }

        private final void createMenus() {
            this.menubar = new JMenuBar();
            this.operationsMenu = new JMenu("Operations");
            AddNodeAction addNode = new AddNodeAction();
            addNode.putValue("Name", "Add to this node");
            RemoveNodeAction removeNode = new RemoveNodeAction();
            removeNode.putValue("Name", "Remove this node");
            AddModifyDataForNodeAction addModAction = new AddModifyDataForNodeAction();
            addModAction.putValue("Name", "Add/Modify data");
            ExitAction exitAction = new ExitAction();
            exitAction.putValue("Name", "Exit");
            this.operationsMenu.add(addNode);
            this.operationsMenu.add(removeNode);
            this.operationsMenu.add(addModAction);
            this.operationsMenu.add(exitAction);
            this.menubar.add(this.operationsMenu);
            this.setJMenuBar(this.menubar);
            this.operationsPopup = new JPopupMenu();
            this.operationsPopup.add(addNode);
            this.operationsPopup.add(removeNode);
            this.operationsPopup.add(addModAction);
        }

        HashMap getData(ReplicatedTree tree, String fqn) {
            if (tree == null || fqn == null) {
                return null;
            }
            Set keys = tree.getKeys(fqn);
            if (keys == null) {
                return null;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            Iterator it = keys.iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                Object value = tree.get(fqn, key);
                if (value == null) continue;
                data.put(key, value);
            }
            return data;
        }

        public static void main(String[] args) {
            int i = 0;
            while (i < args.length) {
                if (args[i].equals("-help")) {
                    System.out.println("ReplicatedTreeView [-help]");
                    return;
                }
                ++i;
            }
            try {
                ReplicatedTree tree = new ReplicatedTree(null);
                tree.setRemoteCalls(false);
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("name", "Framework");
                map.put("pid", new Integer(322649));
                tree.put("/federations/fed1/servers/Framework", map);
                tree.put("/federations/fed1/servers/Security", null);
                ReplicatedTreeView demo = new ReplicatedTreeView(tree, "<null address>");
                tree.put("/federations/fed1/servers/Security/components/RuntimeMonitor", null);
                tree.put("/federations/fed1/servers/fenics", null);
            }
            catch (Exception ex) {
                System.err.println(ex);
            }
        }

        private final /* synthetic */ void this() {
            this.tree_model = null;
            this.jtree = null;
            this.table_model = new DefaultTableModel();
            this.table = new JTable(this.table_model);
            this.root = new MyNode(SEP);
            this.props = null;
            this.selected_node = null;
            this.tree = null;
            this.tablePanel = null;
            this.operationsMenu = null;
            this.operationsPopup = null;
            this.menubar = null;
            this.KEY_COL_WIDTH = 20;
            this.VAL_COL_WIDTH = 300;
        }

        public ReplicatedTreeView(ReplicatedTree tree, Object title) throws Exception {
            this.this();
            this.tree = tree;
            tree.addReplicatedTreeListener(this);
            this.addNotify();
            this.setTitle("ReplicatedTreeDemo: mbr=" + title);
            this.tree_model = new DefaultTreeModel(this.root);
            this.jtree = new JTree(this.tree_model);
            this.jtree.setDoubleBuffered(true);
            this.jtree.getSelectionModel().setSelectionMode(1);
            JScrollPane scroll_pane = new JScrollPane(this.jtree);
            this.populateTree();
            this.getContentPane().add((Component)scroll_pane, "Center");
            this.addWindowListener(this);
            this.table_model.setColumnIdentifiers(new String[]{"Name", "Value"});
            this.table_model.addTableModelListener(this);
            this.setTableColumnWidths();
            this.tablePanel = new JPanel();
            this.tablePanel.setLayout(new BorderLayout());
            this.tablePanel.add((Component)this.table.getTableHeader(), "North");
            this.tablePanel.add((Component)this.table, "Center");
            this.getContentPane().add((Component)this.tablePanel, "South");
            this.jtree.addTreeSelectionListener(this);
            MouseAdapter ml = new MouseAdapter(this){
                final /* synthetic */ ReplicatedTreeView this$0;

                public final void mouseClicked(MouseEvent e) {
                    int selRow = this.this$0.jtree.getRowForLocation(e.getX(), e.getY());
                    TreePath selPath = this.this$0.jtree.getPathForLocation(e.getX(), e.getY());
                    if (selRow != -1) {
                        this.this$0.selected_node = this.this$0.makeFQN(selPath.getPath());
                        this.this$0.jtree.setSelectionPath(selPath);
                        if (e.getModifiers() == 4) {
                            this.this$0.operationsPopup.show(e.getComponent(), e.getX(), e.getY());
                        }
                    }
                }
                {
                    this.this$0 = replicatedTreeView;
                }
            };
            this.jtree.addMouseListener(ml);
            this.createMenus();
            this.setLocation(50, 50);
            this.setSize(this.getInsets().left + this.getInsets().right + 485, this.getInsets().top + this.getInsets().bottom + 367);
            this.init();
            this.setVisible(true);
        }

        class ExitAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }

            ExitAction() {
            }
        }

        class AddNodeAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent e) {
                JTextField fqnTextField = new JTextField();
                if (ReplicatedTreeView.this.selected_node != null) {
                    fqnTextField.setText(ReplicatedTreeView.this.selected_node);
                }
                Object[] information = new Object[]{"Enter fully qualified name", fqnTextField};
                String btnString1 = "OK";
                String btnString2 = "Cancel";
                Object[] options = new Object[]{"OK", "Cancel"};
                int userChoice = JOptionPane.showOptionDialog(null, information, "Add Node", 0, -1, null, options, options[0]);
                if (userChoice == 0) {
                    String userInput = fqnTextField.getText();
                    ReplicatedTreeView.this.tree.put(userInput, null);
                }
            }

            AddNodeAction() {
            }
        }

        class RemoveNodeAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent e) {
                ReplicatedTreeView.this.tree.remove(ReplicatedTreeView.this.selected_node);
            }

            RemoveNodeAction() {
            }
        }

        class AddModifyDataForNodeAction
        extends AbstractAction {
            public void actionPerformed(ActionEvent e) {
                HashMap<String, String> data = ReplicatedTreeView.this.getData(ReplicatedTreeView.this.tree, ReplicatedTreeView.this.selected_node);
                if (data == null) {
                    ReplicatedTreeView.this.clearTable();
                    data = new HashMap<String, String>();
                    data.put("Add Key", "Add Value");
                }
                ReplicatedTreeView.this.populateTable(data);
                ReplicatedTreeView.this.getContentPane().add((Component)ReplicatedTreeView.this.tablePanel, "South");
                ReplicatedTreeView.this.validate();
            }

            AddModifyDataForNodeAction() {
            }
        }

        /*
         * Illegal identifiers - consider using --renameillegalidents true
         */
        class MyNode
        extends DefaultMutableTreeNode {
            String name;

            public MyNode add(String fqn) {
                MyNode ret = null;
                if (fqn == null) {
                    return null;
                }
                MyNode curr = this;
                StringTokenizer tok = new StringTokenizer(fqn, SEP);
                while (tok.hasMoreTokens()) {
                    String child_name = tok.nextToken();
                    MyNode n = curr.findChild(child_name);
                    if (n == null) {
                        n = new MyNode(child_name);
                        if (ret == null) {
                            ret = n;
                        }
                        curr.add(n);
                    }
                    curr = n;
                }
                return ret;
            }

            public void remove(String fqn) {
                this.removeFromParent();
            }

            MyNode findNode(String fqn) {
                if (fqn == null) {
                    return null;
                }
                MyNode curr = this;
                StringTokenizer tok = new StringTokenizer(fqn, SEP);
                while (tok.hasMoreTokens()) {
                    String child_name = tok.nextToken();
                    MyNode n = curr.findChild(child_name);
                    if (n == null) {
                        return null;
                    }
                    curr = n;
                }
                return curr;
            }

            MyNode findChild(String relative_name) {
                if (relative_name == null || this.getChildCount() == 0) {
                    return null;
                }
                int i = 0;
                while (i < this.getChildCount()) {
                    MyNode child = (MyNode)this.getChildAt(i);
                    if (child.name != null && child.name.equals(relative_name)) {
                        return child;
                    }
                    ++i;
                }
                return null;
            }

            String print(int indent) {
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < indent) {
                    sb.append(" ");
                    ++i;
                }
                if (!this.isRoot()) {
                    if (this.name == null) {
                        sb.append("/<unnamed>");
                    } else {
                        sb.append(SEP + this.name);
                    }
                }
                sb.append("\n");
                if (this.getChildCount() > 0) {
                    indent = this.isRoot() ? 0 : (indent += 4);
                    i = 0;
                    while (i < this.getChildCount()) {
                        sb.append(((MyNode)this.getChildAt(i)).print(indent));
                        ++i;
                    }
                }
                return sb.toString();
            }

            public String toString() {
                return this.name;
            }

            private final /* synthetic */ void this() {
                this.name = "<unnamed>";
            }

            MyNode(String name) {
                this.this();
                this.name = name;
            }
        }
    }
}

