// -*- C++ -*- 
/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#ifndef RESOURCE_H
#define RESOURCE_H

#include "namedid.h"
#include "timeblock.h"
#include "note.h"

class RESOURCE : public NAMED_ID
{
public:

    typedef vector<RESOURCE *> PTRLIST;

    RESOURCE( char * id, char * name );

    double efficiency() { return mEfficiency; };
    void setEfficiency(double e);
    double rate();
    void setRate(double r);
    bool IsAvailable( int start, int finish );
    bool IsUsed( int dayNo );
    bool reverseIsAvailable( int start, int finish );
    void AddNote(const string & note);
    NOTE_ITERATOR begin_notes() { return mNotes.begin(); };
    NOTE_ITERATOR end_notes() { return mNotes.end(); };

    void addTimeBlock(TASK *r, int start, int finish, TimeBlock::Type type);
    ResourceTimeBlockIterator begin_booked()  { return mBooked.begin(); };
    ResourceTimeBlockIterator end_booked()  { return mBooked.end(); };
    void addReverseTimeBlock(TASK *r, int start, int finish, TimeBlock::Type type);
    ResourceTimeBlockIterator begin_rbooked()  { return mRbooked.begin(); };
    ResourceTimeBlockIterator end_rbooked()  { return mRbooked.end(); };

    // TO SORT OUT LATER
//    bool isGroup() { return mIsGroup; };
    int is_group;
    PTRLIST belongs_to; ///< if it belongs to groups - the parents
    PTRLIST contains;   ///< if it's a group of resources - its children

    static void setDefaultRate(double rate);
    static double defaultRate() { return sDefaultRate; };

private:
    double mEfficiency;			///< scale to apply to task durations
//    bool mIsGroup;			///< is it a group?
    double mRate;			///< dollars per day for this resource
					///< if different from default!
    NOTES mNotes;			///< notes about this resource

    ResourceTimeBlockList mBooked;	// when is the resource available?
    ResourceTimeBlockList mRbooked;	// when is the resource available?

    void Error(char *fmt, ...);

    static double sDefaultRate;		///< default cost per unit time
};

#endif
