/*
** Copyright (C) 2000 Alan McIvor <alan@mcivor.gen.nz>
**  
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software 
** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
#include <stdarg.h>

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

using namespace std;

#include "messenger.h"
#include "projectFile.h"

ProjectFile::ProjectFile()
{
}

void ProjectFile::Error(char *fmt, ...) 
{
    char buf[1024];
    va_list args;

    va_start(args, fmt);
    vsprintf(buf, fmt, args);
    va_end(args);

    throw ProjectFileException( buf );
}

void ProjectFile::Warning(char *fmt, ...) 
{
    va_list args;

    va_start(args,fmt);
    MESSENGER::Warning(fmt,args);
    va_end(args);
}

void ProjectFile::Debug(char *fmt, ...) 
{
  va_list args;

  va_start(args, fmt);
  MESSENGER::Debug(MESSENGER::PROJECT, fmt, args);
  va_end(args);
}

ProjectFileException::ProjectFileException(string reason)
    : OpenschedException(reason)
{
}

ProjectFileException::~ProjectFileException()
{
}

