<?php
class GrtMessage implements GrtXml {
	private $msgType; // 0..log message, 1..error

	private $msg = "";

	private $msgDetails = array();

	public static $logMessage = 0;

	public static $logError = 1;

	public function __construct($msg, $msgType) {
		$this->msg = $msg;
		$this->msgType = $msgType;
		
		$this->msgDetails = new GrtStringList("", "");
	}

	public function addMessageDetail($msgDetail) {
		$this->msgDetails->add($msgDetail);
	}

	public function getGrtXml() {
		return $this->getGrtXmlKeyTag("");
	}

	public function getGrtXmlKeyTag($keyTag) {
		return "<value type=\"dict\" struct-name=\"GrtMessage\" key=\""
				. $keyTag . "\">" 
				. "<value type=\"int\" key=\"msgType\">"
				. $this->msgType . "</value>\n"
				. "<value type=\"string\" key=\"msg\">" . $this->msg . "</value>\n"
				. $this->msgDetails->getGrtXmlKeyTag(" key=\"details\"") . "</value>\n";
	}
}
?>