//
//  MConnectionInfo.m
//  MySQLGUICommon
//
//  Created by Alfredo Kojima on Wed Jun 23 2004.
//  Copyright (c) 2004 MySQL AB. All rights reserved.
//

#import "MConnectionInfo.h"


@implementation MConnectionInfo

+ (MConnectionInfo*)connectionInfoFromUserConnection: (MYX_USER_CONNECTION*)info
{
  NSString *username;
  NSString *password;
  NSString *hostname;
  int port;
  NSString *schema;
  NSMutableArray *advanced_options;
  NSString *storage_path;
  NSString *notes;
  enum myx_user_connection_type connection_type;
  enum myx_user_connection_storage_type storage_type;
}


- (void)dealloc;

@end


@interface MConnectionInfoList : NSObject {
  @public
  NSMutableArray *connections;
  int last_connection;
}

+ (MConnectionInfoList*)connectionListWithFileContents: (NSString*)file;
- (void)dealloc;

- (void)saveToFile: (NSString*)file;

@end

