/*
 * Decompiled with CFR 0.152.
 */
package viewer.timelines;

import base.drawable.DrawOrderComparator;
import base.drawable.Drawable;
import base.drawable.Shadow;
import base.drawable.TimeBoundingBox;
import base.statistics.BufForTimeAveBoxes;
import java.util.Iterator;
import logformat.slog2.input.TreeTrunk;
import viewer.timelines.SearchCriteria;
import viewer.zoomable.YaxisTree;

public class SearchTreeTrunk {
    private static final boolean INCRE_STARTTIME_ORDER = true;
    private static final boolean IS_NESTABLE = true;
    private static final DrawOrderComparator DRAWING_ORDER = new DrawOrderComparator();
    private TreeTrunk treetrunk;
    private boolean isConnectedComposite;
    private SearchCriteria criteria;
    private Drawable last_found_dobj;

    public SearchTreeTrunk(TreeTrunk treeTrunk, YaxisTree yaxisTree, boolean bl) {
        this.treetrunk = treeTrunk;
        this.criteria = new SearchCriteria(yaxisTree);
        this.isConnectedComposite = bl;
        this.last_found_dobj = null;
    }

    public Drawable previousDrawable(double d) {
        Iterator iterator = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, this.isConnectedComposite, false, true);
        this.criteria.initMatch();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            if (!drawable.getCategory().isVisiblySearchable() || !(drawable.getEarliestTime() <= d) || !drawable.containSearchable() || !this.criteria.isMatched(drawable)) continue;
            this.last_found_dobj = drawable;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public Drawable previousDrawable() {
        if (this.last_found_dobj == null) {
            System.err.println("SearchTreeTrunk.previousDrawable(): Unexpected error, last_found_dobj == null");
            return null;
        }
        Iterator iterator = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, this.isConnectedComposite, false, true);
        this.criteria.initMatch();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            if (!drawable.getCategory().isVisiblySearchable() || DRAWING_ORDER.compare(drawable, this.last_found_dobj) >= 0 || !drawable.containSearchable() || !this.criteria.isMatched(drawable)) continue;
            this.last_found_dobj = drawable;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public Drawable nextDrawable(double d) {
        Iterator iterator = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, this.isConnectedComposite, true, true);
        this.criteria.initMatch();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            if (!drawable.getCategory().isVisiblySearchable() || !(drawable.getEarliestTime() >= d) || !drawable.containSearchable() || !this.criteria.isMatched(drawable)) continue;
            this.last_found_dobj = drawable;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public Drawable nextDrawable() {
        if (this.last_found_dobj == null) {
            System.err.println("SearchTreeTrunk.nextDrawable(): Unexpected error, last_found_dobj == null");
            return null;
        }
        Iterator iterator = this.treetrunk.iteratorOfAllDrawables(TimeBoundingBox.ALL_TIMES, this.isConnectedComposite, true, true);
        this.criteria.initMatch();
        while (iterator.hasNext()) {
            Drawable drawable = (Drawable)iterator.next();
            if (!drawable.getCategory().isVisiblySearchable() || DRAWING_ORDER.compare(drawable, this.last_found_dobj) <= 0 || !drawable.containSearchable() || !this.criteria.isMatched(drawable)) continue;
            this.last_found_dobj = drawable;
            return this.last_found_dobj;
        }
        this.last_found_dobj = null;
        return null;
    }

    public BufForTimeAveBoxes createBufForTimeAveBoxes(TimeBoundingBox timeBoundingBox) {
        Drawable drawable;
        Shadow shadow;
        BufForTimeAveBoxes bufForTimeAveBoxes = new BufForTimeAveBoxes(timeBoundingBox);
        this.criteria.initMatch();
        Iterator iterator = this.treetrunk.iteratorOfLowestFloorShadows(timeBoundingBox, true, true);
        while (iterator.hasNext()) {
            shadow = (Shadow)iterator.next();
            if (!shadow.getCategory().isVisiblySearchable() || !shadow.containSearchable() || !this.criteria.isMatched(shadow)) continue;
            bufForTimeAveBoxes.mergeWithNestable(shadow);
        }
        Iterator iterator2 = this.treetrunk.iteratorOfRealDrawables(timeBoundingBox, this.isConnectedComposite, true, true);
        while (iterator2.hasNext()) {
            drawable = (Drawable)iterator2.next();
            if (!drawable.getCategory().isVisiblySearchable() || !drawable.containSearchable() || !this.criteria.isMatched(drawable)) continue;
            bufForTimeAveBoxes.mergeWithNestable(drawable);
        }
        bufForTimeAveBoxes.setNestingExclusion();
        iterator2 = this.treetrunk.iteratorOfRealDrawables(timeBoundingBox, this.isConnectedComposite, true, false);
        while (iterator2.hasNext()) {
            drawable = (Drawable)iterator2.next();
            if (!drawable.getCategory().isVisiblySearchable() || !drawable.containSearchable() || !this.criteria.isMatched(drawable)) continue;
            bufForTimeAveBoxes.mergeWithNestless(drawable);
        }
        iterator = this.treetrunk.iteratorOfLowestFloorShadows(timeBoundingBox, true, false);
        while (iterator.hasNext()) {
            shadow = (Shadow)iterator.next();
            if (!shadow.getCategory().isVisiblySearchable() || !shadow.containSearchable() || !this.criteria.isMatched(shadow)) continue;
            bufForTimeAveBoxes.mergeWithNestless(shadow);
        }
        return bufForTimeAveBoxes;
    }
}

