/*

    mp - Programmer Text Editor

    i18n.

    Copyright (C) 1991-2000 Angel Ortega <angel@triptico.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

    http://www.triptico.com

*/

#include <stdio.h>
#include <string.h>

#include "mp_lang.h"


/*******************
	Data
********************/

/* language info */

int _mpi_language=-1;


struct lang_str
{
	char * msgid;
	char * msgstr;
};


struct lang
{
	char ** ids;
	struct lang_str * strs;
};


#ifdef NO_LANGUAGES

struct lang langs[] =
{
	{ NULL, NULL }
};

#else /* NO_LANGUAGES */

#include "mp_lang_es.inc"
#include "mp_lang_de.inc"

struct lang langs[] =
{
	{ _es_ids, _es_strs },
	{ _de_ids, _de_strs },
	{ NULL, NULL }
};

#endif /* NO_LANGUAGES */


/*******************
	Code
********************/

char * L(char * msgid)
{
	int n;

	/* default messages */
	if(_mpi_language == -1 || langs[_mpi_language].strs == NULL)
		return(msgid);

	/* find string in the current language */
	for(n=0;langs[_mpi_language].strs[n].msgid != NULL;n++)
	{
		if(strcmp(msgid,langs[_mpi_language].strs[n].msgid) == 0)
			return(langs[_mpi_language].strs[n].msgstr);
	}

	return(msgid);
}


void mpl_set_language(char * langname)
{
	int n;

	for(_mpi_language=0;langs[_mpi_language].ids != NULL;_mpi_language++)
	{
		for(n=0;langs[_mpi_language].ids[n] != NULL;n++)
		{
			if(strcmp(langname,langs[_mpi_language].ids[n])==0)
				return;
		}
	}

	_mpi_language=-1;
}
