#ifndef SWITCH_H
#define SWITCH_H

#include <vector>

#include "Tools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class SwitchSurfaces : public OrientatingSurfacesBase
{
    SURFACES_SINGLETON_OBJECT(SwitchSurfaces);
};



//----------------------------------------------------------------------------
class SwitchBase : public StaticDecorationBase,
                   public OrientatingDecorationBase
{
  public:
    //------------------------------------------------------------------------
    class InitializationData
        : public StaticDecorationBase::InitializationData,
          public OrientatingDecorationBase::InitializationData
    {
      public:
        InitializationData();
        InitializationData(const XMLNode *switchNode);
        ~InitializationData();

        std::vector<unsigned> objectIds;
    };


    //------------------------------------------------------------------------
    virtual ~SwitchBase();

    //------------------------------------------------------------------------
    /**
     * Called to toggle all objects stored in m_objectIds;
     */
    void toggle();

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

    //------------------------------------------------------------------------
    static SwitchBase *create(const InitializationData &init);
    static SwitchBase *create(const XMLNode *switchNode);

  protected:
    //------------------------------------------------------------------------
    SwitchBase(const InitializationData &init);

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    //------------------------------------------------------------------------
    std::vector<unsigned> m_objectIds;
};

//----------------------------------------------------------------------------
class TopSwitch : public SwitchBase
{
  public:
    TopSwitch(const InitializationData &init);
    ~TopSwitch();
};

//----------------------------------------------------------------------------
class BottomSwitch : public SwitchBase
{
  public:
    BottomSwitch(const InitializationData &init);
    ~BottomSwitch();
};

//----------------------------------------------------------------------------
class LeftSwitch : public SwitchBase
{
  public:
    LeftSwitch(const InitializationData &init);
    ~LeftSwitch();
};

//----------------------------------------------------------------------------
class RightSwitch : public SwitchBase
{
  public:
    RightSwitch(const InitializationData &init);
    ~RightSwitch();
};

#endif //SWITCH_H
