#include <pglineedit.h>
#include <pgimage.h>

#include "Configuration.h"
#include "Ship.h"
#include "PlayerConfiguration.h"

#include "PlayerMenu.h"


MENU_SINGLETON_INIT(Player);

//----------------------------------------------------------------------
PlayerMenu::PlayerMenu()
{
    getWidget(ID_PLAYER_MENU_SHIP_PREV)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&PlayerMenu::onShipPrev);
    getWidget(ID_PLAYER_MENU_SHIP_NEXT)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&PlayerMenu::onShipNext);

    getWidget(ID_PLAYER_MENU_OK)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&PlayerMenu::onOk);
    getWidget(ID_PLAYER_MENU_CANCEL)->SetEventObject(
        MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&PlayerMenu::onCancel);
  
    getWidget(ID_PLAYER_MENU_OK)->Show();
    getWidget(ID_PLAYER_MENU_CANCEL)->Show();
    getWidget(ID_PLAYER_MENU_NAMELAB)->Show();
    getWidget(ID_PLAYER_MENU_NAMEEDIT)->Show();
    getWidget(ID_PLAYER_MENU_SHIPLAB)->Show();
    getWidget(ID_PLAYER_MENU_SHIP_PREV)->Show();
    getWidget(ID_PLAYER_MENU_SHIPSEL)->Show();
    getWidget(ID_PLAYER_MENU_SHIP_NEXT)->Show();
}

//----------------------------------------------------------------------
PlayerMenu::~PlayerMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(PlayerMenu::onShipPrev)
{
    m_shipType = (ShipSurfaces::Ship)(m_shipType - 1);
    updateShipPreview();

    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(PlayerMenu::onShipNext)
{
    m_shipType = (ShipSurfaces::Ship)(m_shipType + 1);
    updateShipPreview();

    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(PlayerMenu::onOk)
{
    PlayerConfiguration *playerConfiguration =
        PlayerConfiguration::getInstance();

    playerConfiguration->getPlayer()->setName(
        getWidget(ID_PLAYER_MENU_NAMEEDIT)->GetText());
    playerConfiguration->getPlayer()->setShipType(m_shipType);

    playerConfiguration->writeConfiguration();

    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(PlayerMenu::onCancel)
{
    MenuManager::getInstance()->changeTo(getPrevious(), true, false);
    return true;
}

//----------------------------------------------------------------------
void PlayerMenu::eventShow()
{
    const std::string &name =
        PlayerConfiguration::getInstance()->getPlayer()->getName();
    PG_LineEdit* nameWidget = (PG_LineEdit*)getWidget(ID_PLAYER_MENU_NAMEEDIT);
    nameWidget->SetText(name.c_str());

    m_shipType =
        PlayerConfiguration::getInstance()->getPlayer()->getShipType();
    updateShipPreview();

    getWidget(ID_PLAYER_MENU)->Show();
}

//----------------------------------------------------------------------
void PlayerMenu::eventHide()
{
  getWidget(ID_PLAYER_MENU)->Hide();
}

//----------------------------------------------------------------------
void PlayerMenu::updateShipPreview()
{
    PG_Widget* shipLabel = getWidget(ID_PLAYER_MENU_SHIPSEL);
    shipLabel->RemoveAllChilds();
    PG_Point pos = {0,0};
    PG_Image* shipImage = new PG_Image(
        shipLabel, pos,
        const_cast<SDL_Surface*>(
            ShipSurfaces::getInstance()->getSurface(
                m_shipType, SURFACES_ROTATION_STEPS / 2)),
        false);
    shipImage->SetTransparency(0);
    shipImage->Show();


    if (m_shipType > 0)
    {
        getWidget(ID_PLAYER_MENU_SHIP_PREV)->Show();
    }
    else
    {
        getWidget(ID_PLAYER_MENU_SHIP_PREV)->Hide();
    }

    if (m_shipType < ShipSurfaces::S_TOTAL_NUMBER-1)
    {
        getWidget(ID_PLAYER_MENU_SHIP_NEXT)->Show();
    }
    else
    {
        getWidget(ID_PLAYER_MENU_SHIP_NEXT)->Hide();
    }
}
