#ifndef SINGLEPLAYERGAME_H
#define SINGLEPLAYERGAME_H

#include <string>
#include <list>

#include "LevelReader.h"

//----------------------------------------------------------------------------
class SinglePlayerGame
{
  public:
    //------------------------------------------------------------------------
    ~SinglePlayerGame();

    //------------------------------------------------------------------------
    bool hasMoreLevels() const;

    //------------------------------------------------------------------------
    void nextLevel();


    //------------------------------------------------------------------------
    inline const std::string &getMission() const
    {
        return m_mission;
    }

    inline const std::string &getLevel() const
    {
        return *m_levelIter;
    }


    //------------------------------------------------------------------------
    static void init(const char *mission, unsigned level);

    //------------------------------------------------------------------------
    static void destroy();

    //------------------------------------------------------------------------
    static inline SinglePlayerGame *getInstance()
    {
        return sm_instance;
    }

  protected:

    //------------------------------------------------------------------------
    SinglePlayerGame(const char *mission, unsigned level);

  private:

    //------------------------------------------------------------------------
    static SinglePlayerGame *sm_instance;

    std::string m_mission;
    LevelReader m_levelReader;
    LevelReader::iterator m_levelIter;
};

#endif //SINGLEPLAYERGAME_H
