/* 
 * $Id: ctkviewport.c,v 1.5 2000/06/27 04:42:30 terpstra Exp $
 *
 * CTK - Console Toolkit
 *
 * Copyright (C) 1998-2000 Stormix Technologies Inc.
 *
 * License: LGPL
 *
 * Authors: Kevin Lindsay, Wesley Terpstra
 *  
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License as published by the Free Software Foundation; either
 *    version 2 of the License, or (at your option) any later version.
 *    
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *    
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#include <stdio.h>

#include "ctk.h"

gpointer ctk_viewport_destroy(CtkObject *object);

void
    ctk_viewport_init(CtkViewport *viewport)
{		

	viewport->hadjustment = NULL;
	viewport->vadjustment = NULL;
	
	ctk_bin_init(&viewport->bin);	
}

CtkWidget *
    ctk_viewport_new(CtkAdjustment *hadjustment,
			   CtkAdjustment *vadjustment)
{
	CtkViewport *viewport;

	viewport = g_malloc(sizeof(CtkViewport));

	ctk_viewport_init(viewport);

	viewport->hadjustment = hadjustment;
	viewport->vadjustment = vadjustment;

	((CtkObject *)viewport)->type = CtkTypeViewport;
	((CtkObject *)viewport)->destroy_func = ctk_viewport_destroy;

	return ((CtkWidget *)viewport);
}

/* Destroy Data */
gpointer
    ctk_viewport_destroy(CtkObject *object)
{

	if (((CtkViewport *)object)->hadjustment)
	    g_free(((CtkViewport *)object)->hadjustment);

	if (((CtkViewport *)object)->vadjustment)
	    g_free(((CtkViewport *)object)->vadjustment);

	return NULL;
}
