/*
 *  cache.h
 *  mod_musicindex
 *
 *  $Id: cache.h,v 1.18 2004/06/15 21:09:43 varenet Exp $
 *
 *  Created by Thibaut VARENE on Fri Jul 04 2003.
 *  Copyright (c) 2003-2004 Thibaut VARENE
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation; either version 2.1, or (at your option)
 *  any later version.
 *
 */

#ifndef CACHE_H
#define CACHE_H

#include "mod_musicindex.h"
#include <string.h>

#define CACHE_VERS	3	/**< Cache version number, used for automatic purging of outdated cache */
#define CACHE_NF	13	/**< Number of fields expected in cache */

#undef CACHE_SQL
#ifdef CACHE_SQL
/* to be continued */

#else /* Flat file cache */

 #ifdef sun	/* Defined on Sun Solaris */
  #warning no flat file cache support on that system.
  #define NO_CACHE
 #endif

 #include <dirent.h>	/* opendir & friends */
 #include <errno.h>
 #include <stdio.h>	/* fprintf / fscanf / fileno */
 #include <sys/file.h>	/* flock */
 #include <sys/stat.h>	/* file handling */
 #include <sys/types.h>	/* file handling */
 #include <unistd.h>	/* file handling */
 
#endif	/* CACHE_SQL */

#ifndef NO_CACHE

 #define CA_FATAL	10	/**< Something bad happened */
 #define CA_MISSARG	20	/**< Argument missing */
 #define CA_CREATE	30	/**< Requesting file creation */
 #define CA_LOCKED	40	/**< Cache entry is locked and unusuable */

short cache_check_dir(request_rec *, mu_config *, char *);

mu_ent *make_cache_entry(apr_pool_t *pool, mu_ent *head,
	FILE *in, mu_config *conf, mu_ent_names *names, request_rec *r);

short cache_write_file(request_rec *, mu_ent *, mu_config *, mu_ent_names *);

#else /* NO_CACHE */

#define cache_check_dir(r, conf, path) 0
#define cache_write_file(r, p, conf, names)

#endif /* NO_CACHE */
#endif /* CACHE_H */
