#ifndef __KMULTIPAGE_H
#define __KMULTIPAGE_H

#include <dcopclient.h>
#include <dcopobject.h>
#include <kparts/part.h>
#include <kparts/browserextension.h>
#include <klibloader.h>
#include <qstringlist.h>

#include "centeringScrollview.h"
#include "kmultipageInterface.h"
#include "pageSize.h"


class KInstance;
class KMultiPageExtension;
class QLabel;
class QPainter;


// TODO remove virtual inheritance for KDE 4. It's the reason for the strange DCOPObject construction
class KMultiPage : public KParts::ReadOnlyPart, virtual public kmultipageInterface
{
  Q_OBJECT

public:

  KMultiPage(QWidget *parentWidget, const char *widgetName, QObject *parent, const char *name);
  virtual ~KMultiPage();
  /// returns the scrollview used for the display
  virtual CenteringScrollview *scrollView() { return _scrollView; };

  // Methods which are associated with the DCOP functionality of the
  // kmultipage. This method returns the file name (not the URL) of
  // the currently loaded file.
  QString name_of_current_file();

  // Methods which are associated with the DCOP functionality of the
  // kmultipage. This method can be implemented by the multipage,
  // e.g. to jump to a certain location.
  virtual ASYNC  jumpToReference(QString /*reference*/) {}

  // Methods which are associated with the DCOP functionality of the
  // kmultipage. This method checks if a given file is loaded.
  bool   is_file_loaded(QString filename);

// Interface definition start ------------------------------------------------

  /// returns the list of supported file formats. These strings will
  /// be in the format explained in the documentation to
  /// KFileDialog.setFilter(), e.g. ""*.cpp *.cxx *.c++|C++ Source
  /// Files". The use of mimetype-filters is allowed, but
  /// discouraged. Among other penalties, if a multipage gives a
  /// mimetype-filter, e.g. "application/x-dvi", the open file dialog
  /// in kviewshell will not allow the user to see and select
  /// compressed dvi-files.
  virtual QStringList fileFormats() = 0;

  /// opens a file
  virtual bool openFile() = 0;

  /// closes a file
  virtual bool closeURL() = 0;

  /// displays the given page
  virtual bool gotoPage(int page) = 0;

  /// sets a zoom factor. The multipage implementation might refuse to
  //use a given zoom factor, even if it falls within the bounds given
  //by the constants MinZoom and MaxZoom which are defined in
  //zoomlimits.h. In that case, the multipage implementation chooses a
  //different zomm factor. The implementation returns the factor which
  //has actually been used.
  virtual double setZoom(double z) = 0;

  /// calculates the zoom needed to fit into a given width
  virtual double zoomForWidth(int width) = 0;

  /// calculates the zoom needed to fit into a given height
  virtual double zoomForHeight(int height) = 0;

  /// sets the paper size
  virtual void setPaperSize(double w, double h) = 0;

  /// returns a nice little preview of the page
  virtual bool preview(QPainter *, int, int) { return false; };

  /// prints
  virtual bool print(const QStringList &pages, int current) = 0;

  /// reads in settings
  virtual void readSettings() {};

  /// writes settings
  virtual void writeSettings() {};

  /// redisplays the contents of the current page
  virtual void redisplay() {} ;

  /// multipage implementations that offer read- and write
  /// functionality should re-implement this method and return true
  /// here.
  virtual bool isReadWrite() {return false;};

  /// multipage implementations that offer read- and write
  /// functionality should re-implement this method.
  virtual bool isModified() {return false;};

public slots:
  /** reloads the file form disk and redisplays */
  virtual void reload() {};

  /** Opens a file requestor and starts a basic copy KIO-Job. A
      multipage implementation that wishes to offer saving in various
      formats must re-implement this slot. */
  virtual void slotSave();
  
  /** The standard implementation just calls slotSave. */
  virtual void slotSave_defaultFilename();

  /** Tells the multipage if scrollbars should be used. */
  void slotShowScrollbars(bool);

  /** Used internally. */
  void slotIOJobFinished ( KIO::Job *job );

  /** Switches to fullscreen mode and back */
  virtual void slotSetFullPage(bool fullpage);

signals:
  /** Emitted to indicate the number of pages in the file. The
      receiver will set the current page to zero and call the
      gotoPage()-method. */
  void numberOfPages(int nr);

  void askingToCheckActions();

  /// emitted when a new preview is available
  void previewChanged(bool previewAvailable);

  /** This signal is emitted to indicate to the multipage that the
      document specifies a page size. Depending on the settings, this
      page size will then be set. */
  void documentSpecifiedPageSize(const pageSize &size);

  void viewModeChanged();

// Interface definition end --------------------------------------------------


private:
  QLabel *mainWidget;
  CenteringScrollview *_scrollView;

  // This is set in slotShowScrollbars() to remember the status of the
  // scrollbars when we switch from fullscreen mode back to normal
  // mode
  bool showScrollBars;

  /** This int remembers the style of the frame of the centering
      scrollview when fullscreen mode is switched on. It is then
      restored when it is switched off */
  int      frameStyle;

  /** color of the viewport's background in _scrollView. This is also
      stored on entering the fullscreen mode. */
  QColor   backgroundColor;
};


#endif
