/*********************************************************************
 * Filename:      wireless.c
 * Version:       $Id: $ 
 * Description:   Functions for controlling attributes of a wireless network
 * Author:        Colin Walters <walters@gnu.org>
 * Created at:    Wed Jul 10 13:04:23 2002
 * Modified at:   Wed Jul 10 13:04:23 2002
 * Modified by:   Colin Walters <walters@gnu.org>
 ********************************************************************/

#define _GNU_SOURCE 1

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <sys/types.h>
#include <sys/param.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <dirent.h>
#include <fcntl.h>

#include "intuitively.h"
#include "wireless.h"

#define IWCONFIG_EXEC "/sbin/iwconfig"

int
run_iwconfig2(const char *interface, const char *arg1, const char *arg2) {
  int pid = fork();
  if (pid < 0)
    return -1;
  if (pid == 0) {
    execl(IWCONFIG_EXEC, "iwconfig", interface, arg1, arg2, NULL);
    fprintf(stderr, "Failed to exec \"%s\"\n", IWCONFIG_EXEC);
    exit(1);
  } else {
    int status;
    waitpid(pid, &status, 0);
    if (WIFEXITED(status)) {
      return 0;
    } else {
      return 1;
    }
  }
}

int wireless_set_encryption_key(const char *interface, const char *key) {
  return run_iwconfig2(interface, "enc", key);
}
  
int wireless_set_essid(const char *interface, const char *essid) {
  return run_iwconfig2(interface, "essid", essid);
}

static FILE *popen_iwconfig(const char *interface) {
  char *buf = malloc(strlen(IWCONFIG_EXEC) + strlen(interface) +2);
  strcat(buf, IWCONFIG_EXEC);
  strcat(buf, " ");
  strcat(buf, interface);
  return popen(buf, "r");
}

int wireless_get_encryption_key(const char *interface, char **key) {
  FILE *output = popen_iwconfig(interface);
  char *line = NULL;
  int size = 0;
  while (getline(&line, &size, output) > 0
	 && line[0] != '\n') {
    char *ptr;
    if ((ptr = strstr(line, "Encryption key:")) != NULL) {
      char *end;
      int size;
      ptr += strlen("Encryption key:");
      end = ptr;
      while (*end != '\n' && *end != '\0')
	end++;
      if (*end != '\n')
	goto lose;
      size = end-ptr;
      *key = malloc(size + 1);
      memcpy(*key, ptr, size);
      *key[size] = '\0';
      return 0;
    }
  }
 lose:
  pclose(output);
  return -1;
}

int wireless_get_essid(const char *interface, char **essid) {
  FILE *output = popen_iwconfig(interface);
  char *line = NULL;
  int size = 0;
  while (getline(&line, &size, output) > 0) {
    if (!strncmp(line, interface, strlen(interface))) {
      char *ptr;
      if ((ptr = strstr(line, "ESSID:")) != NULL) {
	char *end;
	int size;
	ptr += strlen("ESSID:") + 1;
	end = ptr;
	while (*end != '\n' && *end != '\0' && *end != '"')
	  end++;
	if (*end != '"')
	  goto lose;
	size = end-ptr;
	*essid = malloc(size + 1);
        memcpy(*essid, ptr, size);
	*essid[size] = '\0';
	pclose(output);
	return 0;
      }
    }
  }
 lose:
  pclose(output);
  return -1;
}
