/* 
 * ImageWindow.h created by phr on 2000-10-17 17:08:05 +0000
 *
 * Project ImageViewer
 *
 * Created with ProjectCenter - http://www.gnustep.org
 *
 * $Id: ImageWindow.h,v 1.5 2003/06/29 17:28:34 probert Exp $
 */

#ifndef _IMAGEWINDOW_H_
#define _IMAGEWINDOW_H_

#include <AppKit/AppKit.h>
#include "ImageShowing.h"

@interface ImageWindow : NSObject <ImageShowing>
{
  id delegate;
  NSWindow *window;
  NSString *imagePath;
  NSDictionary *attr;
  NSSize imageSize;
  NSImageRep *rep;
  int reps;
}

- (id)initWithContentsOfFile:(NSString *)path;

- (id)delegate;
- (void)setDelegate:(id)aDelegate;

- (void)windowWillClose:(NSNotification *)notif;
- (void)windowDidBecomeKey:(NSNotification *)aNotification;

- (NSString *)path;
- (NSString *)imagePath;
- (NSString *)imageName;
- (NSString *)imageType;
- (NSString *)imageSize;
- (NSString *)imageFileModificationDate;
- (NSString *)imageFilePermissions;
- (NSString *)imageFileOwner;
- (NSString *)imageResolution;
- (NSString *)bitsPerSample;
- (NSString *)colorSpaceName;
- (NSString *)hasAlpha;
- (NSString *)imageReps;

@end

@interface NSObject (ImageWindowDelegates)

- (void)imageWindowWillClose:(id)sender;

@end

#endif // IMAGEWINDOW_H_

