%define prefix  /usr

Summary: A universal source code to formatted text converter.
Name: highlight
Version: 2.2
Release: 8
Group: Development/Tools 
License: GPL
Vendor: Andre Simon <andre.simon1@gmx.de>
URL: http://www.andre-simon.de/

Source0:	http://www.andre-simon.de/zip/%{name}-%{version}-%{release}.tar.bz2
Buildroot:      %{_tmppath}/%{name}-%{version}-%{release}-root
Prefix:		%{prefix}

%description
A utility that converts sourcecode to HTML, XHTML, RTF, LaTeX, TeX, XSL-FO, XML or ANSI escape sequences with syntax highlighting 
(HTML is formatted by Cascading Style Sheets). 
It supports several programming and markup languages like 
ADA 95, Agda, AMPL, Aspect, Assembler, Amtrix, Avenue, (G)AWK, Bash, BlitzBasic,
BibTex,  BMS, C, C++, C Sharp, ClearBasic, Clipper, Cobol, Coldfusion MX, CSS,
DOS-Batch, Eiffel, Erlang, Euphoria, Express, Felix, Fortran, Frink, Haskell, HTML,
httpd.conf, Icon, IDL, INI, IO, Jasmin, Java, JavaScript, JSP, LaTeX, LDIF, Lisp, Lotos,
Lotus Script, Lua, Make, Maya, Matlab, Maple, Modelica, Modula, Nasal, OCaml, (Object)
Pascal, Objective C, Paradox, PATROL, Perl, PHP, Pike, PL/1, PL/SQL, PostScript, POV
Ray, Progress, Prolog, Python, Relax NG Compact, Rexx, RPM Spec,  Ruby, Small, SML,
SNMPv2, Spin, Squirrel, SuperX++, Sybase, VHDL, Visual Basic, XML.
The utility offers indentation and reformatting capabilities.
It is easily possible to create new language definitions and colour themes.

%prep
%setup -q -n highlight-%{version}-%{release}  

%build
make

%install
if [ -d $RPM_BUILD_ROOT ]; then rm -r $RPM_BUILD_ROOT; fi
mkdir -p $RPM_BUILD_ROOT%{prefix}
make prefix=$RPM_BUILD_ROOT%{prefix} install-strip
install -d $RPM_BUILD_ROOT%{prefix}/share/highlight/themes $RPM_BUILD_ROOT%{prefix}/share/highlight/langDefs
install -d $RPM_BUILD_ROOT%{prefix}/share/highlight/helpmsg $RPM_BUILD_ROOT%{prefix}/share/highlight/indentSchemes
install -d $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/examples/cgi/php 
install -d $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/examples/cgi/perl 
install -d $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/examples/python-binding

mkdir -p $RPM_BUILD_ROOT%{_mandir}/man1
mkdir -p $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/

install -m644 ./man/highlight.1.gz $RPM_BUILD_ROOT%{_mandir}/man1/
install -m644 ./langDefs/*.lang  $RPM_BUILD_ROOT%{prefix}/share/highlight/langDefs/
install -m644 ./langDefs/extensions.conf $RPM_BUILD_ROOT%{prefix}/share/highlight/
install -m644 ./themes/*.style $RPM_BUILD_ROOT%{prefix}/share/highlight/themes/
install -m644 ./indentSchemes/*.indent $RPM_BUILD_ROOT%{prefix}/share/highlight/indentSchemes/
install -m644 ./helpmsg/*.help $RPM_BUILD_ROOT%{prefix}/share/highlight/helpmsg/
install -m644 ./examples/cgi/php/* $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/examples/cgi/php
install -m644 ./examples/cgi/perl/* $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/examples/cgi/perl
install -m644 ./examples/python-binding/* $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/examples/python-binding
install -m644 ./ChangeLog ./AUTHORS ./COPYING ./TODO ./README ./README_DE ./README_ES ./README_INDENT ./INSTALL  $RPM_BUILD_ROOT%{prefix}/share/doc/highlight/
mkdir -p $RPM_BUILD_ROOT%{prefix}/local/bin/
install -m755 ./highlight/highlight  $RPM_BUILD_ROOT%{prefix}/local/bin/

%clean
#make clean

%postun
rmdir %{prefix}/share/highlight/themes %{prefix}/share/highlight/langDefs %{prefix}/share/highlight/helpmsg
rmdir %{prefix}/share/highlight/examples/cgi/perl %{prefix}/share/highlight/examples/cgi/php %{prefix}/share/highlight/utils/cgi %{prefix}/share/highlight/examples/python-binding %{prefix}/share/highlight/examples/
rmdir %{prefix}/share/highlight

%files
%defattr(-,root,root)

%{prefix}/share/highlight/extensions.conf

%{prefix}/share/doc/highlight/ChangeLog
%{prefix}/share/doc/highlight/AUTHORS
%{prefix}/share/doc/highlight/README
%{prefix}/share/doc/highlight/README_DE
%{prefix}/share/doc/highlight/README_ES
%{prefix}/share/doc/highlight/README_INDENT
%{prefix}/share/doc/highlight/COPYING
%{prefix}/share/doc/highlight/TODO
%{prefix}/share/doc/highlight/INSTALL

%{prefix}/share/highlight/langDefs/*.lang
%{prefix}/share/highlight/themes/*.style
%{prefix}/share/highlight/indentSchemes/*.indent
%{prefix}/share/highlight/helpmsg/*.help
%{prefix}/share/man/man1/highlight.1.gz

%{prefix}/share/doc/highlight/examples/cgi/perl/highlight.cgi
%{prefix}/share/doc/highlight/examples/cgi/php/SyntaxHighlighter.php
%{prefix}/share/doc/highlight/examples/python-binding/example.py
%{prefix}/share/doc/highlight/examples/python-binding/highlightmodule.cpp
%{prefix}/share/doc/highlight/examples/python-binding/setup.py
%{prefix}/share/doc/highlight/examples/python-binding/README_PYTHON

%{prefix}/local/bin/highlight

%changelog
* Tue Feb 26 2002 Andre Simon <andre.simon1@gmx.de>
- Initial build

