/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satmodules.h: maintains a list of open modules. This list is saved when the
                program exits and is read when the program starts. The modules
		should call the add/remove functions with the module name as
		argument. satmodules_add_module should be called when the
		module is created, and satmodules_remove_module should be
		called when the module is closed.

  Copyright (C)  2001-2003  Alexandru Csete.

  Authors:   Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

/* Gnome config path names */
#define SATMODULES_LIST_PATH  "/gpredict/openmodules/lists"
#define SATMODULES_MAP_PATH   "/gpredict/openmodules/maps"
#define SATMODULES_SKY_PATH   "/gpredict/openmodules/skys"
#define SATMODULES_GLOBE_PATH "/gpredict/openmodules/globes"


/* module types */
enum moduletype {
	SATMOD_TYPE_LIST = 0,
	SATMOD_TYPE_MAP,
	SATMOD_TYPE_SKY,
	SATMOD_TYPE_GLOBE,
	SATMOD_TYPE_MAX         /* number of module types */
};


guint satmodules_init (void);
gboolean satmodules_test_module (gchar *, guint);
gboolean satmodules_test_open_modules (gchar *, guint);
void satmodules_add_module (gchar *, guint);
void satmodules_remove_module (gchar *, guint);
void satmodules_get_modules (guint, gint *, gchar ***);
void satmoudules_close (void);
