/****************************************************************************
** eh.cc
**
** Michael S. Borella <mike@borella.net>
**
** Methods for the error handler class
**
****************************************************************************/

#include <strstream>
#include "eh.h"

// default dispostion is to halt upon errors
eh_disp_t EH::_disposition = EH_DISP_HALT;

// default callback function is set to nothing
void (*EH::_callback)(string) = NULL;

//---------------------------------------------------------------------------
//
// EH::EH()
//
// Constructor method.  Do something intelligent with the error string.
//
//---------------------------------------------------------------------------

EH::EH(string s)
{
  action(s, "", 0);
}

//---------------------------------------------------------------------------
//
// EH::EH(string, string, int)
//
// Constructor method.  Do something intelligent with the error string.
//
//---------------------------------------------------------------------------

EH::EH(string s, string f, int l)
{
  action(s, f, l);
}
//---------------------------------------------------------------------------
//
// EH::action()
//
// Decides what to do based on the current disposition
//
//---------------------------------------------------------------------------

void EH::action(string s, string f, int l)
{
  char buf [128];
  strstream ss(buf, sizeof buf);

  if (!f.empty())
    ss << f << ":" << l << "  " << s;
  else
    ss << s;
  ss << ends;

  switch(_disposition)
    {
    case EH_DISP_HALT:
      cerr << buf << endl;
      abort();
      break;

    case EH_DISP_CONTINUE:
      cerr << buf << endl;
      break;

    case EH_DISP_IGNORE:
      break;

    case EH_DISP_CALLBACK:
      if (_callback == NULL)
	{
	  cerr << "EH: must set callback function" << endl;
	  abort();
	}
      _callback(s);
      break;
    }

  return;
}

