proc GetPoint_Img {img x y } {
    global profileWidth
    global profileHeight

    if {$img == "NULL"} {
         return NULL
    }

    if {$x >= 0 && $x < $profileWidth &&
        $y >= 0 && $y < $profileHeight } { 
         set imgz [powGetImageZ $img $x $y] 
    } else {
         set imgz 0
    }
    return $imgz
}

proc UpdateProfile {obj} { 
    global powDWP
    global profile_gn
    global profile_img

    set xdlg ${powDWP}xdlg
    foreach [list gx0 gy0 gx1 gy1] [$obj getGraphCoords] {}
    set e0 [powGraphToPixel $profile_img $gx0 $gy0]  
    set e1 [powGraphToPixel $profile_img $gx1 $gy1]   
    foreach [list x0 y0] $e0 {} 
    foreach [list x1 y1] $e1 {} 
    set x0 [expr round($x0 + 1)]
    set y0 [expr round($y0 + 1)]
    set x1 [expr round($x1 + 1)]
    set y1 [expr round($y1 + 1)] 

    set g0 [format "(%-.8g, %-.8g)" $gx0 $gy0 ] 
    set g1 [format "(%-.8g, %-.8g)" $gx1 $gy1 ] 
    set p0 [format "(%d, %d)" $x0 $y0 ] 
    set p1 [format "(%d, %d)" $x1 $y1 ] 
   
    $xdlg.frame.row1.pix1 configure -text $p0
    $xdlg.frame.row1.pix2 configure -text $p1
    $xdlg.frame.row2.graph1 configure -text $g0
    $xdlg.frame.row2.graph2 configure -text $g1
}

proc DrawProfile {obj} {
    global profile_gn
    global profile_img 
    global powPlotParam
    
    foreach [list gx0 gy0 gx1 gy1] [$obj getGraphCoords] {}
    set e0 [powGraphToPixel $profile_img $gx0 $gy0]  
    set e1 [powGraphToPixel $profile_img $gx1 $gy1]   
    foreach [list x0 y0] $e0 {} 
    foreach [list x1 y1] $e1 {} 
    set x0 [expr round($x0)]
    set y0 [expr round($y0)]
    set x1 [expr round($x1)]
    set y1 [expr round($y1)]
   
    set tx [expr abs($x1-$x0)] 
   
    set tx [expr abs($x1-$x0)] 
    set ty [expr abs($y1-$y0)] 
    if {$tx == 0 && $ty == 0 } { 
       return 
    }
    if {$tx >= $ty } {
        if {$x0 > $x1 } {
          set step -1 
        } else {
          set step 1 
        }
        set k  [expr double($y1-$y0)/double($x1-$x0) ]
        set tpoints [expr (abs($x1-$x0+1))]
        set usex 1
    } else {
        if {$y0 > $y1 } {
          set step -1 
        } else {
          set step 1 
        }
        set k  [expr double($x1-$x0)/double($y1-$y0) ]
        set tpoints [expr abs(($y1-$y0+1))]
        set usex 0
    } 
   
    set xi $x0
    set yi $y0  

    set a [GetPoint_Img $profile_img $xi $yi]
    if {$a != "NULL"} {
         lappend zlist $a  
    } else {
         lappend zlist 0
    }
    set zlist [GetPoint_Img $profile_img $xi $yi]
    set xlist 1
    for {set i 1} {$i < $tpoints } {incr i} { 
       if {$usex == 1} {
          incr xi $step
          set yi [expr round($k*($xi-$x0))+$y0]
       } else {
          incr yi $step
          set xi [expr round($k*($yi-$y0))+$x0]
       }    
       lappend xlist [expr $i + 1]
       set a [GetPoint_Img $profile_img $xi $yi]
       if {$a != "NULL"} {
         lappend zlist $a  
       } else {
         lappend zlist 0
       }
    } 


    powCreateDataFromList ${profile_gn}_cx_data $xlist 
    set xlabel "pixel index "
    set xunit " pixel"

    powCreateDataFromList ${profile_gn}_cz_data $zlist 

    powCreateVector ${profile_gn}_cx_vector ${profile_gn}_cx_data 0 NULL NULL
    powCreateVector ${profile_gn}_cz_vector ${profile_gn}_cz_data 0 NULL NULL

    powCreateCurve ${profile_gn}_xsec_curve ${profile_gn}_cx_vector \
        NULL ${profile_gn}_cz_vector NULL 

    if ![info exists powPlotParam(xdimdisp,${profile_gn}_xsec)] { 
       set powPlotParam(xdimdisp,${profile_gn}_xsec) 200
       set powPlotParam(ydimdisp,${profile_gn}_xsec) 200
    }
    powCreateGraph ${profile_gn}_xsec ${profile_gn}_xsec_curve NULL \
            $xunit NULL $xlabel Counts \
        $powPlotParam(xdimdisp,${profile_gn}_xsec) \
        $powPlotParam(ydimdisp,${profile_gn}_xsec)
  
    powSetCurveOptions ${profile_gn}_xsec ${profile_gn}_xsec_curve pDisp No 
    powSetCurveOptions ${profile_gn}_xsec ${profile_gn}_xsec_curve lDisp Yes 
    powSetCurveOptions ${profile_gn}_xsec ${profile_gn}_xsec_curve lStyle " " 
    
} 

proc ProfileCallback { obj msg } {
    global powDWP
    set xdlg ${powDWP}xdlg

    if ![winfo exists $xdlg ] {
       return 
    } 
    
    if {$msg == "shapeIsBeingModified"} {
       UpdateProfile $obj
    } 

    if {$msg == "shapeHasChanged"} {
       DrawProfile $obj
       UpdateProfile $obj
    } 

}

proc ProfileDlg {} {
    global currgn
    global currimg
    global powbg
    global powDWP

    global profile_gn
    global profile_img
    global profileRegion
    global profileWidth
    global profileHeight


    set xdlg ${powDWP}xdlg

    if [winfo exists $xdlg ] {
       focus $xdlg
       raise $xdlg
       return
    } 

    if ![info exists currimg ] {
       tk_messageBox -type ok -icon error \
           -message "Select an image first."
       return
    }
    

    powToplevel $xdlg .pow  "-width 200 -bg $powbg"
    wm title $xdlg "Profile" 

    frame $xdlg.frame -borderwidth 4  
    frame $xdlg.frame.title -width 300
    frame $xdlg.frame.row0 
    frame $xdlg.frame.row1
    frame $xdlg.frame.row2
    label $xdlg.frame.title.title -text "Profile:" -background yellow \
            -relief flat   -width 8 -anchor w
    button $xdlg.frame.title.help -text Help -anchor e  \
            -command {powHelp Profile.html} 
    label $xdlg.frame.row0.holder -text "" -width 18 \
         -anchor w -relief flat
    label $xdlg.frame.row0.start -text "Start" -width 25 \
         -anchor w -relief flat
    label $xdlg.frame.row0.stop -text "Stop" -width 25  -anchor w -relief flat
    label $xdlg.frame.row1.pixelname -text "Image Pixel:" \
              -width 18 -relief flat -anchor w
    label $xdlg.frame.row1.pix1 -justify left -anchor w \
             -relief sunken -width 25
    label $xdlg.frame.row1.pix2 -justify left -anchor w \
             -relief sunken -width 25
    label $xdlg.frame.row2.graphname -text "Graph coordinates:" \
              -width 18 -relief flat -anchor w
    label $xdlg.frame.row2.graph1 -justify left -anchor w \
           -relief sunken -width 25
    label $xdlg.frame.row2.graph2 -justify left -anchor w \
           -relief sunken -width 25
    button $xdlg.frame.close -text Exit -command {
           delete object $profileRegion
           destroy ${powDWP}xdlg
    }
    pack $xdlg.frame.title.title -side left -anchor w
    pack $xdlg.frame.title.help  -side right -anchor e 
    pack $xdlg.frame.row0.holder  -side left 
    pack $xdlg.frame.row0.start  -side left 
    pack $xdlg.frame.row0.stop -side left
    pack $xdlg.frame.row1.pixelname -side left
    pack $xdlg.frame.row1.pix1 -side left
    pack $xdlg.frame.row1.pix2 -side left
    pack $xdlg.frame.row2.graphname -side left
    pack $xdlg.frame.row2.graph1 -side left
    pack $xdlg.frame.row2.graph2 -side left
    pack $xdlg.frame.title -anchor w -pady 5 -padx 2 -fill x
    pack $xdlg.frame.row0 -anchor w -pady 2  -padx 2
    pack $xdlg.frame.row1 -anchor w -pady 2 -padx 2
    pack $xdlg.frame.row2 -anchor w -pady 2 -padx 2
    pack $xdlg.frame.close  -expand 1 -anchor w -pady 5 -padx 2
    pack $xdlg.frame

    
    set profileRegion [gRegionList $currgn .pow.pow]  
    $profileRegion setOwner ProfileCallback
    $profileRegion setAllowsMultiple 0
    $profileRegion setDefault "+" Line 

    set profile_gn $currgn
    set profile_img $currimg

    set temp [ powFetchImageInfoHash  $profile_img ] 
    set temp [split $temp ]
    set profileWidth [lindex $temp 3]
    set profileHeight [lindex $temp 5] 

    set halfx [expr round($profileWidth*0.5) ]
    set halfy [expr round($profileHeight*0.5) ]
    set gx0 [expr round($halfx*0.5) + 1]
    set gy0 [expr round($halfy*0.5) + 1]
    set gx1 [expr round($halfx*1.5) + 1]
    set gy1 [expr round($halfy*1.5) + 1]
    set descr [list $gx0 $gy0 $gx1 $gy1]
    $profileRegion addRegion + Line $descr pixels
    set elem [ $profileRegion rgnAtIndex 0]


   bind $xdlg <<CloseWindow>> {
      delete object profileRegion
      destroy ${powDWP}xdlg
   }

    tkwait window $xdlg
}



