set helpMsg "Usage: POWplot ?-cmap code? ?-display client? ?fitsimage?
 code: 0 Chose the best colormap
       1 Force to install private pseudo colormap
       2 Force to use truecolor colormap (if don't have it will crash!) 
       3 Force to use screen default colormap
 client: XPA entry point of form IP_Address:portNumber, pointing to
         a remote POW session to which plot commands should be sent"


set ppFitsDataType(8) 0
set ppFitsDataType(16) 1
set ppFitsDataType(32) 2
set ppFitsDataType(-32) 3
set ppFitsDataType(-64) 4

set instPos [lsearch $argv "-cmap"]
set colorCode 0

# if install colormap
if { $instPos != -1} {
    if { [catch {set colorCode [lindex $argv [expr $instPos+1]]}] == 1} {
	puts $helpMsg
	exit
    }
    if { ($colorCode != 0) && ($colorCode != 1) && ($colorCode != 2) \
	&& ($colorCode != 3) } {
	puts $helpMsg
	exit
    }	
    set argv [lreplace $argv $instPos [expr $instPos+1]]
    incr argc -2 
}

wm withdraw .
update idletask

#
# Load libraries
#

set POWLIB "$env(POW_LIBRARY)/.."
set env(POW_HELPDIR) $env(POW_LIBRARY)

package require Itcl
package require Itk
package require Iwidgets

load [glob $POWLIB/libfitstcl.s\[ol\]*]
load [glob $POWLIB/libpow.s\[ol\]*]

# Look for client/server flag

set instPos [lsearch $argv "-display"]
if { $instPos != -1 } {
   set client [lindex $argv [expr $instPos+1]]
   set argv [lreplace $argv $instPos [expr $instPos+1]]
   incr argc -2
   ::powCmds::remote $client
} else {
   # None specified, so ask POW for default value
   set client [::powCmds::remote]
}

::powCmds::init 10 $colorCode

foreach filename $argv {
    regsub -all {[^a-zA-Z0-9.]} [file tail $filename] "_" gname
    set filehandle [fits open $filename 0]
    set imghandle [$filehandle load image]
    set dims [$filehandle info imgdim]
    set n1 [lindex $dims 0]
    if { [llength $dims]==1 } {
       set n2 1
    } else {
       set n2 [lindex $dims 1]
    }
    set data_type [lindex [lindex [$filehandle get keyword BITPIX] 0] 1]
    set data_type $ppFitsDataType($data_type)
    if { ([catch {$filehandle get keyword BZERO}] == 0) ||
         ([catch {$filehandle get keyword BSCALE}] == 0) } {
        set data_type 4
    }

#    powCreateData ${gname}_data $imghandle $data_type [expr $n1 * $n2] 0

    set lstData [list $imghandle $data_type [list $n1 $n2] ]
    ::powCmds::array $lstData ${gname}_data PTR $tcl_platform(byteOrder)

    # Try to get WCS (or scaling) information

    set x0 1
    set y0 1
    set xinc 1
    set yinc 1
    set x_label ""
    set y_label ""
    set x_unit  "pixels"
    set y_unit  "pixels"

    set wcsinfo [$filehandle get wcs -m]
    if { [lindex $wcsinfo 4] != "none" } {
       set x_label [lindex [lindex $wcsinfo 3] 0]
       set y_label [lindex [lindex $wcsinfo 3] 1]
       set x_unit "NULL"
       set y_unit "NULL"
    }

#    powCreateImage ${gname}_img ${gname}_data \
#      0 0 $n1 $n2 $x0 $xinc $y0 $yinc pixels pixels counts
#    powCreateGraph $gname NULL ${gname}_img \
#      $x_unit $y_unit $x_label $y_label 300 300

    ::powCmds::wcs ${gname}_img $wcsinfo
    ::powCmds::create image ${gname}_img ${gname}_data $n1 $n2

    ::powCmds::graph -name $gname \
          xlabel $x_label \
          ylabel $y_label \
          xunits $x_unit \
          yunits $y_unit
    ::powCmds::create graph $gname NULL ${gname}_img

    $filehandle close
}

bind . <<powExit>> {exit}

if { $client != "" } {
   exit
}
