# First draft 05/01/96    Jianjun

#constrct a FitsTable object
# FitsTable FitsTableObjName FitsFileObjName chdu 

class Table {
    constructor {args} {}
    destructor         {}

# public member 
    public method makeTable {}
    public method refresh { {doChildren 1} }
    public method calculateCols {colname colform formula}
    public method getCalcCols {}
    public method scplotCmd {{xyname {}}}
    public method delRowsWithCondition {cond}
    public method delRowsFromList {entry}
    public method closeCmd {} 
    public method bringToFront {}
    public method setFileName { fName }
    public method addChild { child }
    public method freeChild { child }
    public method plotCols { xColumn xeColumn yColumn yeColumn \
          {inCurrGraph 0} {rows -} }

    public method modifyTableCell {col row val}

    public method openVectorTable { colNum }

    public variable fileName ""
    public variable numRows
    public variable isFailedToCopy 0
    public variable fFObj
    public variable chdu


# protected member
    protected method drawTable {}
    protected method drawTableFrame {}
    protected method plotCmd {}
    protected method evaluateExpr { axis expr rows }
    protected method relocateDividLine {x index}
    protected method finalDividLine {x index}
    protected method startDividLine {x index}
    protected method setupTable { }
    protected method redrawTable {prevCols}
    protected method setVScroll {args}
    protected method setHScroll {args}
    protected method addColsToTable {prevCols prevRows}
    protected method delColsFrTable {prevCols prevRows}
    protected method addRowsToTable {prevCols prevRows}
    protected method delRowsFrTable {prevCols prevRows}
    protected method addColsToFile {inWin} 
    protected method addRowsToFile {inWin} 
    protected method updateLast { }

    ################
    # Subclasses need to implement these methods...
    #          all col/row params are zero-based

    protected method getRawData       {col row}
    protected method getFormattedData {col row}
    protected method readTabData      {fCol fRow nCols nRows}
    protected method getRawDataBlock  {fCol fRow lCol lRow}
    protected method putRawDataBlock  {fCol fRow data}

    #
    ################

    protected method jumpFrEnt {}
    protected method jump {lineNum}
    protected method selRowsFrExpr {delete}
    protected method copyCell {col row}

    protected method writeTabData {col row val}
    protected method updateColSel {col}
    protected method resizeCan {x y}
    protected method layoutCan {x y}
    protected method getXYSize {x y}
    protected method refacing {}
    protected method saveAs {}
    protected method saveASCII {}
    protected method calXPos {fCol nCols}
    protected method reframe {}
    protected method setScrolls {}
    protected method getLastFirstCol {}
    protected method closeFrWm {w} 
    protected method realCloseCmd {} 
    protected method saveFile {}
    protected method updateNumRows {}
    protected method updateNumCols {}
    protected method addCols {}
    protected method delCols {}
    protected method tryDelCols {}
    protected method addRows {}
    protected method setArrayAToB {a b}
    protected method editCell {} 
    protected method selCell {}
    protected method unselCell {}
    protected method cellUp {} 
    protected method cellDown {} 
    protected method cellLeft {} 
    protected method cellRight {} 
    protected method pageUp {}
    protected method pageDown {}
    protected method getArray {name index}
    protected method calculateCmd {}
    protected method collapse {seed bed}
    protected method sortRange {bed}
    protected method sortCmd {} 
    protected method sortColumn {}

    public    method doSort { keys dirs unique }

    protected method getSortKey {key}
    protected method resetSKey {}
    protected method cpyToCB {}
    protected method cpyFrCB {}
    protected method getFitsFileCmd {}
    protected method makeHistogram {}
    protected method histoCmd {} 
    protected method changeUniqLabel {}
    protected method statCmd {}
    protected method statSelCmd {}
    protected method makeJustification {} 
    protected method updateRestDisps {} 
    protected method saveTableToAscii {win asciiFileName} 
    protected method setStartMark {col row}
    protected method buildMenus {}
    protected method buildNewMenus {}
    protected method postMenus {}
    protected method updateHL {}
    protected common colSel
    protected common asciiColWidth 80
    protected common psortkey 
    protected common ssortkey 
    protected common tsortkey 
    protected common psortcheck 1
    protected common ssortcheck 1
    protected common tsortcheck 1
    protected common addcolname ""
    protected common addcolunit ""
    protected common addcolform ""
    protected common addcoldisp ""
    protected common isUniqMerge 0
    protected variable numEntry
    protected variable currentCol
    protected variable currentRow
    protected variable cellVar
    protected variable cstartx ""
    protected variable cstarty ""
    protected variable oldcstartx ""
    protected variable oldcstarty ""
    protected variable cendx ""
    protected variable cendy ""
    protected common insColNum "End of Table"
    protected common colSName
    protected common colMin
    protected common colMax
    protected common colMean
    protected common colFMin
    protected common colFMax
    protected common colStd
    protected common colRowRange
    protected common colNumVal

    protected variable showRows 20
    protected variable showCols 6
    protected variable firstRow 1 
    protected variable firstCol 1
    protected variable oldfirstCol 1
    protected variable lastFirstCol 1
    protected variable droot ""
    protected variable mBar
    protected variable DC
    protected variable xPos
    protected variable yPos
    protected variable absXPos
    protected variable vecSize
    protected variable curVec
    protected variable cellWidth
    protected variable cellPixWidth
    protected variable oldCellPixWidth
    protected variable tabType
    protected variable numCols
    protected variable columnName
    protected variable columnType
    protected variable columnUnit
    protected variable columnForm
    protected variable columnWidth
    protected variable columnNull
    protected variable columnDim
    protected variable colNames
    protected variable dType
    protected variable showColList
    protected variable colState
    protected variable tabData
    protected variable colData
    protected variable colInfo
    protected variable anyColSelected 0
    protected variable anyRowSelected 0
    protected variable colSelList
    protected variable dispCols
    protected variable startX
    protected variable imgForm
    protected variable colNull
    protected variable colType
    protected variable colForm
    protected variable colName
    protected variable colDim
    protected variable father
    protected common gid 0
    protected variable curColType ""
    protected variable isDirPlot 0
    protected variable justStarted 1
    protected variable fitsfileCmd
    protected variable isBeingDestroyed 0
    protected variable myChildren {}

#private member
    private method readInTable { }
    private method setEndMark {col row}
    private method unsetMark {}
}

body Table::constructor {args} {
    
}

body Table::destructor {} {

}



body Table::readInTable { } {
    global charPix

    set maxWidth [expr int([winfo screenwidth .]/$charPix)-10]
    set dispCols [llength $colSelList]

    for {set i 0} {$i < $dispCols} {incr i} {
	set tmpName [lindex $colSelList $i]
        if { [catch {set cI [$fFObj getColInfo $tmpName]}] } {
            set colSelList [lreplace $colSelList $i $i]
            incr i -1
            incr dispCols -1
        } else {
            set colInfo($tmpName) [join $cI]
        }
    }
    setarray colState 0 [expr $dispCols-1] 0

    for {set i 0} {$i < $dispCols} {incr i} {
# in the coInfo list. the elements are
# Index 0 : column name     1 : column type    2 : column unit
#       3 : column TDISP    4 : column format  5 : column width   6 : is Zero
#       7 : is Scaled       8 : column null value
	set columnName($i)  [lindex $colSelList $i]
	set columnType($i)  [lindex $colInfo($columnName($i)) 1]
	set columnUnit($i)  [lindex $colInfo($columnName($i)) 2]
	set columnForm($i)  [lindex $colInfo($columnName($i)) 4]
	set columnWidth($i) [lindex $colInfo($columnName($i)) 5]
	set columnNull($i)  [lindex $colInfo($columnName($i)) 8]

       # Check for TDIM keyword

       set colNo [lsearch $colNames $columnName($i)]
       incr colNo
       if { [catch {set key [$fFObj getKeyword TDIM$colNo]}] } {
          set columnDim($i) 1
       } else {
          set key "[string trim [lindex [lindex $key 0] 1] {' ()}]"
          set columnDim($i) [split $key ,]
       }

       # Determine vector size of column

        if { $tabType == "Binary Table" } {
            regsub -all {[A-Z]} $columnType($i) "" vecSize($i)
	    if { $vecSize($i) == "" } {
               set vecSize($i) 1
            } elseif { [string index $vecSize($i) end] == ")" } {
               # Pull out variable length
               if { ![regexp {\((.*)\)} $vecSize($i) dmy val] } {
                  set val 0
               }
               set vecSize($i) [expr -$val]
	    }
            if { [regexp A $columnType($i)] && $vecSize($i)!=0 } {
               set vecSize($i) 1
            }
	} else {
	    set vecSize($i) 1
	}
	set curVec($i) 1

        if { ![info exists cellWidth($i)] } {
           set headMax 0
           foreach l [list xx$columnName($i) $columnType($i) $columnUnit($i)] {
              set wdth [font measure titleFont $l]
              if { $wdth > $headMax } {set headMax $wdth}
           }
           set headMax [expr int( 1.0*$headMax/$charPix + 0.999 )]
           set cellWidth($i) [expr ($headMax > $columnWidth($i)) \
                 ? $headMax : $columnWidth($i) ]
           if { $cellWidth($i) > $maxWidth } {
              set cellWidth($i) $maxWidth
           }
        }
    }
    
    calAbsXPos
}

#body Table::calAbsXPos {} {
#    set absXPos(0) [expr $DC(lmar) + $DC(width)/2 +$DC(rightspace)]
#    for {set i 0} {$i < $dispCols} {incr i} {
#	set cellPixWidth($i) [expr $charPix*$cellWidth($i)+4]
#	set absXPos([expr $i+1]) [expr $absXPos($i)+$cellPixWidth($i)+$DC(rightspace)] 
#    }
#}

body Table::makeTable {} {
    global charPix

    set DC(height)      20
    set DC(width)       [expr ($numRows !=0 )? \
	                       (int(log10($numRows))+4)*$charPix : 100 ] 
    set DC(headroom)    80
    set DC(footroom)    40
    set DC(vscrollsize) 15
    set DC(hscrollsize) 15
    set DC(rightspace)   6
    set DC(interline)    0

    set DC(tmar)         6
    set DC(lmar)         8


    #Read in all the needed data
    readInTable

    #Draw the table 
    drawTable

    buildMenus
}


body Table::setFileName { fName } {
    set fileName $fName
    set rName [urlTail $fName]
    set dName [getFullDirPath $fName]
    wm title $droot "fv: $tabType of $rName\[[expr $chdu-1]\] in $dName"
}


body Table::drawTable {} {
    global isMac
    
    set droot ".[namespace tail $this]"
    if { [winfo exists $droot] } {
       destroy $droot
    }
    
    powToplevel  $droot  .dummy
    setFileName $fileName

    set firstRow 1
    set firstCol  1

    setupTable

    frame         $droot.table 
    bind $droot <Destroy> +[code $this closeFrWm %W]

    set can       $droot.table.can
    set hdr       $droot.table.hdr
    canvas         $hdr \
	-width $DC(xsize) \
	-height $DC(headroom) -highlightthickness 0
    canvas        $can \
	-width $DC(xsize) \
	-height  $DC(ysize) \
	-relief ridge -borderwidth 5
    bind $can <Configure> +[code $this resizeCan %w %h]
    bind $can <Up>    [code $this cellUp]
    bind $can <Down>  [code $this cellDown]
    bind $can <Left>  [code $this cellLeft]
    bind $can <Right> [code $this cellRight]
    bind $can <Prior> [code $this pageUp]
    bind $can <Next>  [code $this pageDown]
    bind $can <KeyPress> "\
          focus $droot.usrEntry.sel_e; \
          event generate $droot.usrEntry.sel_e <KeyPress> -when now \
          -keysym %K -keycode %k"

    scrollbar  $droot.table.vscroll -width $DC(vscrollsize) -orient vertical \
	-command [code $this setVScroll]
    scrollbar  $droot.table.hscroll -width $DC(hscrollsize) -orient horizontal \
	-command [code $this setHScroll]

    if { $numRows } {
       $droot.table.vscroll set 0.0 \
	     [expr double($showRows)/$numRows] 
    } else {
       $droot.table.vscroll set 0.0 1.0
    }
    if { $colSelList == "" } {
       $droot.table.hscroll set 0.0 1.0
    } else {
       $droot.table.hscroll set 0.0 \
	     [expr double($showCols)/[llength $colSelList]]
    }


    pack $droot.table.hdr      -side top    -fill x  -anchor w
    pack $droot.table.vscroll  -side right  -fill y 
    pack $droot.table.hscroll  -side bottom -fill x 
    pack $droot.table.can      -side top    -fill both  -expand 1


    frame         $droot.usrEntry  -height $DC(footroom) \
	-relief raised -borderwidth 0
    entry 	    $droot.usrEntry.goto_e -width 10 \
	-relief sunken -bd 2
    bind $droot.usrEntry.goto_e <Return> [code $this jumpFrEnt]
    button 	    $droot.usrEntry.goto_b -text "Go to:" \
	-command [code $this jumpFrEnt]

    label $droot.usrEntry.sel -text "  Edit cell:"
    entry $droot.usrEntry.sel_e -width 22 \
	-textvariable [scope cellVar] -relief sunken -bd 2
    bind $droot.usrEntry.sel_e <Return> [code $this editCell]
    
    pack $droot.usrEntry.goto_b -side left 
    pack $droot.usrEntry.goto_e -side left
    pack $droot.usrEntry.sel    -side left
    pack $droot.usrEntry.sel_e  -side left 
    pack $droot.usrEntry        -side bottom -fill x 
    pack $droot.table           -side top    -fill both -expand 1

# draw the lines and entries ... 
    drawTableFrame

    # Bind window to menu events

    bind $droot <<PostMenus>>   [code $this postMenus]

    bind $droot <<SaveFile>>    [code $this saveFile]
    bind $droot <<SaveFileAs>>  [code $this saveAs]
    bind $droot <<Export>>      [code $this saveASCII]
    bind $droot <<CloseWindow>> [code $this closeCmd]

    bind $droot <<Copy>>        [code $this cpyToCB]
    bind $droot <<Paste>>       [code $this cpyFrCB]
}


body Table::buildMenus {} {
    global isMac
    
    if { $isMac } {
        set mBar .mbar.table
    } else {
        set mBar $droot.mbar
    }
    $droot config -menu $mBar
    
    if { ![winfo exists $mBar] } {
       buildNewMenus
    }
}


body Table::buildNewMenus {} {
   global isMac isWin

   menu $mBar
   if { $isMac } {
      set evtWndw ""
      set cmdkey "Cmd"
      $mBar add cascade -menu $mBar.apple
      $mBar add cascade -menu $mBar.file  -label File
      $mBar add cascade -menu $mBar.edit  -label Edit
      $mBar add cascade -menu $mBar.tools -label Tools
      $mBar add cascade -menu .mbar.wind  -label Windows
      $mBar add cascade -menu $mBar.help  -label Help
      buildApplMenu $mBar.apple
   } else {
      set evtWndw $droot
      set cmdkey "Alt"
      $mBar add cascade -menu $mBar.file  -label File
      $mBar add cascade -menu $mBar.edit  -label Edit
      $mBar add cascade -menu $mBar.tools -label Tools
      $mBar add cascade -menu $mBar.help  -label Help
   }
   
   # FILE

   if { $isMac } {
      buildFileMenu $mBar.file
      $mBar.file entryconfig "Export" -label "Export as Text..." \
            -state normal
      $mBar.file entryconfig "Save As..." -state normal
      $mBar.file entryconfig "Close"      -state normal
   } else {
      menu $mBar.file -tearoff False
      $mBar.file add command -label "Save" -underline 0 \
            -command "doMenuEvent <<SaveFile>>" -accelerator "$cmdkey+S"
      $mBar.file add command -label "Export as Text..." \
            -command "doMenuEvent <<Export>>"
      $mBar.file add command -label "Close" \
            -command "doMenuEvent <<CloseWindow>>" -accelerator "$cmdkey+W"
   }
   
   # EDIT

   buildEditMenu $mBar.edit

   # TOOLS

   menu $mBar.tools -tearoff False

   # HELP

   buildHelpMenu $mBar.help tableDisplay "Table Display"
        
   # Configure the Post Commands

   if { $isMac || $isWin } {
            
       # The Mac and Windows post all menus at once, so we only need
       # to do the post on the top level
            
       $mBar configure -postcommand "doMenuEvent <<PostMenus>> $evtWndw"

   } else {
            
       # Unix has to post each individual menu

       $mBar.file configure -postcommand \
               "doMenuEvent <<PostMenus>> $evtWndw"
       $mBar.edit configure -postcommand \
               "doMenuEvent <<PostMenus>> $evtWndw"
       $mBar.tools configure -postcommand \
               "doMenuEvent <<PostMenus>> $evtWndw"
   }
}


body Table::postMenus {} {
   
   if { [$fFObj isFileChanged] && ![$fFObj isReadOnly] } {
      $mBar.file entryconfigure Save -state normal
   } else {
      $mBar.file entryconfigure Save -state disabled
   }

   set clipType [lindex [fvClipBoard report] 0]
   if { ($clipType == "table") && !$isFailedToCopy } {
      $mBar.edit entryconfigure "Paste" -state normal
   } else {
      $mBar.edit entryconfigure "Paste" -state disabled
   }

   if { $cstartx == "" } {
      $mBar.edit entryconfigure "Copy" -state disabled
   } else {
      $mBar.edit entryconfigure "Copy" -state normal
   }

}


body Table::scplotCmd {{xyname {}}} {
    global charPix

    set DC(height)      20
    set DC(width)       [expr ($numRows !=0 )? \
	                       (int(log10($numRows))+4)*$charPix : 100 ] 
    set DC(headroom)    80
    set DC(footroom)    40
    set DC(vscrollsize) 15
    set DC(hscrollsize) 15
    set DC(rightspace)   6
    set DC(interline)    0

    set DC(tmar)         6
    set DC(lmar)         8

    set colSelList $colNames
# let the destructor know
    set isDirPlot 1
#
    readInTable

    set argc [llength $xyname]
    if { $argc<2 || $argc>6 } {
       plotCmd
    } elseif { $argc>3 } {
       eval plotCols $xyname
    } else {
       if { $argc==2 } {
          set flag 0
          foreach {x y} $xyname {}
       } else {
          foreach {x y flag} $xyname {}
       }
       plotCols $x {} $y {} $flag
    }

    delete object $this
}

body Table::plotCmd {} {

    set nameList [list RowNumber ElementNumber]
    set vecList [list 1 1]
    if { $tabType == "Vector Table" } {
	for {set i 0} {$i < $dispCols} {incr i} {
            lappend vecList 1
            set str ""
            set delim ""
            set j $i
            foreach dim $colDim {
               set str "$str$delim[expr $j % $dim + 1]"
               set j [expr $j/$dim]
               set delim ","
            }
	    lappend nameList "$colName\[$str\]"
	}	
    } else {
	for {set i 0} {$i < $dispCols} {incr i} {
           if { $vecSize($i) > 0 } {
#              lappend vecList  $vecSize($i)
              lappend vecList  $columnDim($i)
              lappend nameList [lindex $colSelList $i]
           }
	}
    }

    if { [winfo exists .pltSel] } {
       .pltSel quitCmd
    }
    FitsPlotSel .pltSel $this $nameList $vecList [code $this plotCols]
    wm title .pltSel "Select Plot Columns"

    tkwait window .pltSel
}

body Table::evaluateExpr { axis expr rows } {

   if { $expr == "RowNumber" } {
      foreach [list type nelem dim] \
            [list 41 [range count $rows $numRows] 1] {}
      set expr "#ROW"
   } else {
      if { [catch {set xinfo [$fFObj getExprInfo $expr]} err] } {
         error "Cannot plot expression for $axis.\n\n$err"
      }
      foreach [list type nelem dim] $xinfo {}
      if { $type!=41 && $type!=82 } {
         error "Cannot plot expression type for $axis.\
               Expression must evaluate to INT or REAL"
      }
      if { $nelem==-1 } {
         #  Scalar constants could be applied to either nRows or nElems
         #  so just return a solitary value and expand later as needed
         set rows 1
      } elseif { $nelem < -1 } {
         #  Treat vector constants as a regular vector column
         set nelem [expr -$nelem]
      }
   }
   foreach [list ptr type len] [$fFObj loadExpr $expr NULL $rows] {}
   return [list $ptr $type $len $nelem $dim]
}

body Table::histoCmd {} {
    global HistoParam

    set nameList $colSelList
    set tmpName [namespace tail $this]

    FitsHistoParam .his_$tmpName $fFObj $nameList
    wm title .his_$tmpName "fv: Histogram"
    tkwait window .his_$tmpName
    if { $HistoParam == "" } return
    makeHistogram
}

body Table::makeHistogram {} {
    global HistoParam
    global histoFileID
    global backupDir
    global fitsFileMode

    set oldMode $fitsFileMode
    # Set Read-Only flag
    set fitsFileMode 1

    eval $fFObj makeHistogram $HistoParam

    set fftmp [openFitsFile [file join $backupDir histo.tmp$histoFileID]]

    $fftmp plotHisto
    $fftmp changeFile

    set fitsFileMode $oldMode
}

body Table::plotCols { xColumn xeColumn yColumn yeColumn \
      {inCurrGraph 0} {rows "-"} } {
   global powWCS

   if { $rows=="-" } {
      set nRows $numRows
   } else {
      set nRows [range count $rows $numRows]
   }

   set graphID [namespace tail $this]_$gid

   #
   #  Analyze the expressions
   #

   foreach axis [list x y xe ye] {
      set axisValue [subst \$${axis}Column]
      set exprData($axis,expr) $axisValue
      if { $axisValue == "" || $axisValue == "NULL" } {

         #  No expression supplied.  OK for errorbars, not allowed for x/y

         if { [string length $axis]==1 } {
            error "[string toupper $axis] axis is empty"
         } else {
            set exprData($axis,nelem) 0
            set exprData($axis,name1) "NULL"
         }

      } elseif { $axisValue == "ElementNumber" } {

         #   Have to delay data creation until we know how big
         #   the other axes are

         set exprData($axis,nelem) 1
         set exprData($axis,name1) "NULL"

      } else {

         #  nelem value will be -1 for scalar constants
         set eData [evaluateExpr $axis $axisValue $rows]
         foreach p [list ptr type len nelem dim] v $eData {
            set exprData($axis,$p) $v
            set $p $v
         }

      }
   }

   #
   #  Create the vectors
   #

   set nelem [getmax $exprData(x,nelem)  $exprData(y,nelem) \
                     $exprData(xe,nelem) $exprData(ye,nelem)]
   if { $nelem == 1 } {
      # All parameters are scalars
      set nelem $nRows
   } elseif { $nelem < 1 } {
      # All parameters are constants or blank, plot just solitary point
      set nelem 1
   }
   foreach axis [list x y xe ye] {
      if { $exprData($axis,expr) == "ElementNumber" } {

         set exprData($axis,cnt)   1
         set exprData($axis,name1) ${axis}1_v_$graphID
         set exprData($axis,len)   $nelem
         powCreateVectorEN $exprData($axis,name1) ElementNumber_$graphID \
               $nelem 1 1 NULL

      } elseif { $exprData($axis,nelem) == -1 } {

         set val [ptr2lst $exprData($axis,ptr) $exprData($axis,type) 1]
         set exprData($axis,cnt)   1
         set exprData($axis,name1) ${axis}1_v_$graphID 
         set exprData($axis,len)   $nelem
         powCreateVectorEN $exprData($axis,name1) ${axis}_$graphID \
               $nelem $val 0 NULL
         fits free $exprData($axis,ptr)

      } elseif { $exprData($axis,nelem) != 0 } {

         #   Test for vector-length compatibility amongst axes
         if { $exprData($axis,nelem) != $nelem && \
               ($exprData($axis,len) != $nelem || $exprData($axis,nelem) != 1)\
                } {
            error "[string toupper $axis] axis data length is\
                  incompatible with other axes"
         }

         powCreateData ${axis}_$graphID $exprData($axis,ptr) \
               $exprData($axis,type) $exprData($axis,len) -1

         set cnt 0
         set offset 0
         while { $offset < $exprData($axis,len) } {
            incr cnt
            set exprData($axis,name$cnt) ${axis}${cnt}_v_$graphID
            powCreateVector $exprData($axis,name$cnt) ${axis}_$graphID \
                  $offset $nelem 1
            incr offset $nelem
         }
         set exprData($axis,cnt) $cnt

      } else {

         set exprData($axis,cnt) 1

      }
   }


# get the x and y units
   set xUnit NULL
   set yUnit NULL
    if { $tabType != "Vector Table"} {
	for {set i 0} {$i < $dispCols} {incr i} {
	    if { $columnName($i) == $xColumn} {
		set xUnit $columnUnit($i)
		if {$xUnit == ""} {set xUnit NULL}
	    }
	    if { $columnName($i) == $yColumn} {
		set yUnit $columnUnit($i)
		if {$yUnit == ""} {set yUnit NULL}
	    }
	}
    }

    set cleanFileName [urlTail $fileName]
    set graphHandle ${cleanFileName}_[expr $chdu-1]_$gid

    if { [winfo exist .pow.pow]!=1 } { 
	[code powInit .dummy]
    }

# get the wcs info if it exists
    if { $tabType != "Vector Table" && $fvPref::ifWCSInfo } {
       # Get the WCS info (if needed) and pass them to pow

       set RAColNum [lsearch $colNames $xColumn]
       set DecColNum [lsearch $colNames $yColumn]
       if { ($RAColNum != -1) && ($DecColNum != -1) } {
          incr RAColNum
          incr DecColNum
          
          set wcsinfo [$fFObj getWcs $RAColNum $DecColNum]
          if { [lindex $wcsinfo 4] != "none" } {
             set xColumn [lindex [lindex $wcsinfo 3] 0]
             set yColumn [lindex [lindex $wcsinfo 3] 1]
             set xUnit "NULL"
             set yUnit "NULL"
          }
       }
    }

    foreach axis [list x y xe ye] {
       set ${axis}i 1
       set looping($axis) 1
    }
    set crvs ""
    set cnt 0
    while { $looping(x) || $looping(y) || $looping(xe) || $looping(ye) } {
       incr cnt
       set crvName c${cnt}_$graphHandle
       if { [info exists wcsinfo] && $wcsinfo!="" } {
          set powWCS($crvName) $wcsinfo
       }
       powCreateCurve $crvName $exprData(x,name$xi) $exprData(xe,name$xei) \
             $exprData(y,name$yi) $exprData(ye,name$yei)
       lappend crvs $crvName
       foreach axis [list x y xe ye] {
          incr ${axis}i
          if { [subst \$${axis}i] > $exprData($axis,cnt) } {
             set ${axis}i 1
             set looping($axis) 0
          }
       }
    }

#    powCreateCurve $graphHandle x_v_$graphID $xeName y_v_$graphID $yeName

    if { $inCurrGraph && [powGetCurrentGraph]!="" } {
       powAddCurves [powGetCurrentGraph] $crvs
    } else {
       powCreateGraph $graphHandle $crvs NULL $xUnit $yUnit \
	     $xColumn $yColumn \
	     [lindex $fvPref::graphDispSize 0] [lindex $fvPref::graphDispSize 1]
    }
    incr gid
}

body Table::relocateDividLine {x index } {
    set dx [expr $x - $startX]
    set startX $x
    $droot.table.can move tmpLine $dx 0
    
}

body Table::startDividLine {x index } {
    $droot.table.can create line $x 0 $x $DC(ysize) \
	    -width 4 -fill red -tag tmpLine
    set startX $x
}

body Table::finalDividLine {x index} {
    global charPix

    $droot.table.can delete tmpLine
    set dx [expr $x - $xPos($index)]

    if { $index == 0} {
	set moveX $dx
	set DC(width) [expr $DC(width)+$dx]
	$droot.table.can move check [expr $moveX/2] 0
	$droot.table.can itemconfigure check -width $DC(width)
# DC(width) is an important param. it will effect several other things.
# Need to do extra here
	calAbsXPos
	calXPos $firstCol $showCols
	getLastFirstCol
    } else {
	set prIndex [expr $index -1 ]
	set dx1 [expr $x - $xPos($prIndex)]
	set prAbsIndex [expr $prIndex + $firstCol -1 ]
	
	if { [expr abs($dx)] < $charPix} return
	
	if { $x < $xPos($prIndex) } return
	
	set tmp $cellPixWidth($prAbsIndex)
	set cellWidth($prAbsIndex) [expr $dx1/$charPix ]
	calAbsXPos
	set moveX [expr $cellPixWidth($prAbsIndex) -$tmp]
	
	calXPos $firstCol $showCols
	getLastFirstCol
	$droot.table.can itemconfigure entry_$prIndex \
	    -width $cellPixWidth($prAbsIndex)
	$droot.table.hdr itemconfigure colInfo_$prIndex \
	    -width $cellPixWidth($prAbsIndex)
	$droot.table.can move entry_$prIndex [expr $moveX/2]  0
	$droot.table.hdr move colInfo_$prIndex [expr $moveX/2]  0
    }
    for {set i $index} {$i <= $showCols} {incr i} {
        $droot.table.can move colLine_$i $moveX 0
        $droot.table.can move entry_$i $moveX 0
        $droot.table.hdr move colInfo_$i $moveX 0
    }

    setHScroll [expr $firstCol-1]
}

body Table::calXPos {fCol nCols} {
    set xPos(0) [expr $DC(lmar) + $DC(width) + $DC(rightspace)]
    set tmpPos $absXPos([expr $fCol-1])
    for {set i 0} {$i < $nCols} {incr i} {
        set colIndex [expr $fCol+$i]
        set xPos([expr $i+1]) [expr $absXPos($colIndex)-$tmpPos+$xPos(0)]
    }
}

body Table::setupTable { } {

    set lastCol [llength $colSelList]

    if {$showRows > $numRows} {
	set showRows $numRows
    }

    if {$showCols > $lastCol} {
	set showCols $lastCol
    }

    if { $firstCol > [expr $lastCol -$showCols+1]} {
	set firstCol [expr $lastCol -$showCols+1]
    }
    if { $firstRow > [expr $numRows -$showRows+1]} {
	set firstRow [expr $numRows -$showRows+1]
    }

    set DC(xsize) [expr $absXPos([expr $firstCol-1+$showCols]) \
		       - $absXPos([expr $firstCol-1]) + $absXPos(0) \
		       - $DC(rightspace)/2 ]
    set DC(ysize) [expr 2*$DC(tmar) + $showRows*($DC(height)+$DC(interline))]

    getLastFirstCol

    updateLast
}

body Table::getLastFirstCol {} {
    # base on the size of the canvas, find out the beginning of the
    # last page of the table.
    set tmpWidth  [expr $DC(lmar) + $DC(width) + $DC(rightspace)/2]
    for { set i $dispCols} {$i > 0} {incr i -1} {
	set tmpWidth [expr $tmpWidth+$cellPixWidth([expr $i-1])+$DC(rightspace)]
	if { $tmpWidth > $DC(xsize) } {
	    break
	}
    }
    set lastFirstCol [expr $i +1]
}

body Table::drawTableFrame {} {

    set hdr $droot.table.hdr
    set can $droot.table.can

#calculate the xPos
    calXPos $firstCol $showCols

    if { ($tabType == "Image") || ($tabType == "Vector Table") } {
	for {set i 0} {$i < $showCols } {incr i} {
	    set tmpColName [lindex $colSelList [expr $firstCol-1+$i]]
	    set tmpColNum  [expr $firstCol-1+$i]
	    set tmpColWid($i)   $cellPixWidth($tmpColNum) 
	    set tmpColXPos($i)  [expr $xPos($i) + $cellPixWidth($tmpColNum)/2]
	    checkbutton $hdr.name$i -text $tmpColName -font titleFont \
		-variable [scope colSel($this,$i)] \
		-selectcolor $fvPref::checkBBgColor  \
		-activeforeground black -activebackground $fvPref::globalBgColor \
		-command [code $this updateColSel $i]
	    $hdr create window $tmpColXPos($i) \
		[expr $DC(height)/2] -width $cellPixWidth($i) \
		-window $hdr.name$i -tags colInfo_$i
#	    $mBar entryconfigure Edit -state disabled
#	    if { $tabType == "Vector Table"} {
#		$mBar.file entryconfigure "Save"    -state disabled
#		$mBar.file entryconfigure "Export*" -state disabled
#	    }
	}
    } else {
	for {set i 0} {$i < $showCols} {incr i} {
	    set tmpColNum  [expr $firstCol-1+$i]
	    set tmpColName [lindex $colSelList $tmpColNum ]
	    set tmpColXPos($i)  [expr $xPos($i) + $cellPixWidth($tmpColNum)/2]
	    set tmpColWid($i)  $cellPixWidth($tmpColNum) 
	    checkbutton $hdr.name$i -text $columnName($tmpColNum)  \
		-font titleFont -variable [scope colSel($this,$i)] \
		-selectcolor $fvPref::checkBBgColor  \
		-activeforeground black -activebackground $fvPref::globalBgColor \
		-command [code $this updateColSel $i]
	    label $hdr.type$i -text $columnType($tmpColNum) \
		-font titleFont
	    label $hdr.unit$i -text $columnUnit($tmpColNum)  \
		-font titleFont
	    if { $vecSize($tmpColNum) > 1 || $vecSize($tmpColNum) < 0 } {
		button $hdr.vecB$i -text "expand" -font titleFont -state normal\
		    -borderwidth 2 \
		    -command [code $this openVectorTable $tmpColNum]
	    } else {
		button $hdr.vecB$i -text "" -font titleFont -state disabled \
		    -command {} -borderwidth 0
	    }
	    $hdr create window $tmpColXPos($i) [expr $DC(height)/2] \
		-width $tmpColWid($i) \
		-window $hdr.name$i -tags colInfo_$i
	    $hdr create window $tmpColXPos($i) [expr $DC(height)*3/2] \
		-width $tmpColWid($i) \
		-window $hdr.type$i -tags colInfo_$i
	    $hdr create window $tmpColXPos($i) [expr $DC(height)*5/2] \
		-width $tmpColWid($i) \
		-window $hdr.unit$i -tags colInfo_$i
	    $hdr create window $tmpColXPos($i) [expr $DC(height)*7/2] \
		-width $tmpColWid($i) \
		-window $hdr.vecB$i -tags colInfo_$i
	}
    }

    set yPos(0) $DC(tmar)

    for {set j 0} {$j < $showRows} {incr j} {
	set realRowNum [expr $firstRow+$j]
	if { $tabType == "Image"} {
	    set rowIndex [expr $numRows - $realRowNum+1]
	} else {
	    set rowIndex $realRowNum
	}
	label $can.b$j -text $rowIndex -font titleFont

	set yPos([expr $j+1]) [expr $DC(tmar) + ($j+1)*($DC(height) + $DC(interline))]
	$can create window [expr $DC(lmar)+$DC(width)/2] \
	    [expr $yPos($j)+$DC(height)/2]  -window $can.b$j  \
	    -width $DC(width) -height [expr $DC(height)-1] \
	    -tags check
    }

    set tmpHeight [expr $DC(height) -1]
    
    for {set j 0} {$j < $showRows } {incr j} {
	set tmpColYPos($j) [expr $yPos($j)+$DC(height)/2] 
	for {set i 0} {$i < $showCols} {incr i} {
	    set id ${i}_$j
            entry $can.e$id -width $cellWidth($i) \
		-textvariable [scope numEntry($id)] -state disabled \
		-relief sunken -bd 0 -justify right -font entryFont
            bind $can.e$id <Button-1> [code $this setStartMark $i $j]
	    bind $can.e$id <Button-3> [code $this setEndMark $i $j]
	    bind $can.e$id <Shift-Button-1> [code $this setEndMark $i $j]
#	    bind $can.e$id <Button-2> [code $this unsetMark ]
   	    $can create  window $tmpColXPos($i) $tmpColYPos($j) \
		-height $tmpHeight \
		-width  $tmpColWid($i) \
		-window $can.e$id -tags entry_$i
	}

    }

#
    reframe
}

body Table::redrawTable {prevCols} {

   calXPos $firstCol $showCols

   # Reposition/Resize the header/cells

   set minCols [getmin [list $prevCols $showCols]]
   set idx [expr $firstCol-1]
   for {set i 0} {$i < $minCols } {incr i; incr idx} {
      foreach {oldx oldy} [$droot.table.can coord entry_$i] {}
      set dx [expr $xPos($i)+$cellPixWidth($idx)/2 - $oldx]
      $droot.table.can move entry_$i   $dx 0
      $droot.table.hdr move colInfo_$i $dx 0
      $droot.table.can itemconfigure entry_$i   -width $cellPixWidth($idx) 
      $droot.table.hdr itemconfigure colInfo_$i -width $cellPixWidth($idx) 
   }

   # Reposition the lines

   for {set i 0} {$i <= $minCols } {incr i} {   
      foreach {oldx oldy} [$droot.table.can coord colLine_$i] {}
      set dx [expr $xPos($i)-$DC(rightspace)/2-1 - $oldx]
      $droot.table.can move  colLine_$i $dx 0
      $droot.table.can raise colLine_$i
   }

   # Do we need to add/delete any columns?

   if { $prevCols > $showCols } {
      delColsFrTable $prevCols $showRows
   } elseif { $prevCols < $showCols} {
      addColsToTable $prevCols $showRows 
   }
}

body Table::setVScroll {args} {

    set oldfirstRow $firstRow
# unselected the previously selected cell
    unselCell
#
    if { [llength $args]==1 } {
	set firstRow [expr $args+1]
    } else {
	set stype [lindex $args 2]
	set snum  [lindex $args 1]
	if {$snum == ""} return

	if { [string match "page*" $stype] } {
	    set tmpjump [expr $snum*$showRows]
	} elseif { [string match "unit*" $stype] } {
	    set tmpjump $snum
	} elseif { $stype == ""} {
	    set tmpjump [expr 1+round($snum*$numRows)-$firstRow]
	} else {
	    error "unknown scroll command $stype"
	    return
	}
	set firstRow [expr $firstRow+$tmpjump]
    }

    if {$firstRow < 1} {
	set firstRow 1
    }

    if {$firstRow > [expr $numRows-$showRows+1] } {
	set firstRow [expr $numRows-$showRows+1]
    }

    updateLast

    refacing
# reselect cell
    selCell
}

body Table::refacing {} {

    if { $numRows } {
       $droot.table.vscroll set [expr double($firstRow-1)/$numRows]  \
	     [expr double($firstRow + $showRows - 1)/$numRows]
    } else {
       $droot.table.vscroll set 0.0 1.0
    }

    for {set j 0} {$j < $showRows} {incr j} {
	if { $tabType == "Image" } {
	    set rowIndex [expr $numRows -  ($firstRow+$j) +1]
	} else {
	    set rowIndex [expr $j+$firstRow]
	}	
	$droot.table.can.b$j configure -text $rowIndex
    }
}

body Table::setScrolls {} {
#horizontal
   if { $colSelList == "" } {
      $droot.table.hscroll set 0.0 1.0
   } else {
      $droot.table.hscroll set [expr ($firstCol-1.0)/[llength $colSelList] ] \
	    [expr ($firstCol+$showCols-1.0)/[llength $colSelList]]
   }
#vertical is set in refacing 
}


body Table::setHScroll {args} {

    set oldfirstCol $firstCol
    set oldShowCols $showCols
    set oldShowRows $showRows
# unselected the cell
    unselCell

    if { [llength $args]==1 } {
	set firstCol [expr $args+1]
    } else {
	set stype [lindex $args 2]
	set snum  [lindex $args 1]
	if {$snum == ""} return

	if { [string match "page*" $stype] } {
	    set tmpjump [expr $snum*$showCols]
        } elseif { [string match "unit*" $stype] } {
	    set tmpjump $snum
	} elseif { $stype == ""} {
	    set tmpjump [expr 1+round($snum*[llength $colSelList])-$firstCol]
	} else {
	    error "unknown scroll command $stype"
	    return
	}
	set firstCol [expr $firstCol+$tmpjump]
    }

    if {$firstCol < 1} {
	set firstCol 1
    } elseif {$firstCol > $lastFirstCol } {
	set firstCol $lastFirstCol
    }

 # determine how many cols and rows to display
    getXYSize $DC(xsize) $DC(ysize)

    if { [expr $firstCol+$showCols-1] > $dispCols } {
	set $firstCol $oldfirstCol
	return
    }

    redrawTable $oldShowCols

# update the table entries
    updateLast

    if { ($tabType == "Image") || ($tabType == "Vector Table")} {
        for {set i 0} {$i < $showCols} {incr i} {
	    set tmpColNum [expr $firstCol+$i-1]
	    set [scope colSel($this,$i)] $colState($tmpColNum)
            set tmpColName [lindex $colSelList [expr $i+$firstCol-1]]
            $droot.table.hdr.name$i configure \
                -text $tmpColName  -command [code $this updateColSel $i]
        }
    } else {
        for {set i 0} {$i < $showCols} {incr i} {
            set tmpColName [lindex $colSelList [expr $i+$firstCol-1]]
	    set tmpColNum [expr $firstCol+$i-1]
	    set [scope colSel($this,$i)] $colState($tmpColNum)
            $droot.table.hdr.name$i configure \
                -text $columnName($tmpColNum) -command [code $this updateColSel $i]
            $droot.table.hdr.type$i configure \
                -text $columnType($tmpColNum)
            $droot.table.hdr.unit$i configure \
                -text $columnUnit($tmpColNum)
	    if { $vecSize($tmpColNum) > 1 || $vecSize($tmpColNum) < 0 } {
		$droot.table.hdr.vecB$i configure -text "expand" -font titleFont \
		    -state normal -borderwidth 2\
		    -command [code $this openVectorTable $tmpColNum]
	    } else {
		$droot.table.hdr.vecB$i configure -text "" -borderwidth 0\
		    -font titleFont -command {} -state disabled 
                
	    }
        }
    }

# reselected the previously selected cell
    selCell
#
    if { $colSelList=="" } {
       $droot.table.hscroll set 0.0 1.0
    } else {
       $droot.table.hscroll set [expr ($firstCol-1.0)/[llength $colSelList] ] \
	     [expr ($firstCol+$showCols-1.0)/[llength $colSelList]]
    }

# justify
    makeJustification
}

body Table::addColsToTable {prevCols prevRows} {

    set hdr $droot.table.hdr
    set can $droot.table.can

    calXPos $firstCol $showCols
    if { ($tabType == "Image") || ($tabType == "Vector Table") } {
	for {set i $prevCols} {$i < $showCols} {incr i} {
	    set absColIndex [expr $firstCol -1+$i]
	    set tmpColName [lindex $colSelList $absColIndex]
	    checkbutton $hdr.name$i -text $tmpColName -font titleFont \
		-variable [scope colSel($this,$i)] \
		-selectcolor $fvPref::checkBBgColor  \
		-activeforeground black -activebackground $fvPref::globalBgColor \
		-command [code $this updateColSel $i]
	    $hdr create window [expr $xPos($i) + \
  	        $cellPixWidth($absColIndex)/2] \
		[expr $DC(height)/2] -width  $cellPixWidth($absColIndex)  \
		-window $hdr.name$i -tags colInfo_$i

	    for {set j 0} {$j < $showRows } {incr j} {
		set id ${i}_$j
		if { [winfo exist $can.e$id] == 0} { 
		    entry $can.e$id \
			-width $cellWidth($absColIndex) \
			-font entryFont -state disabled \
		        -textvariable [scope numEntry($id)] \
			-relief sunken -bd 0 -justify right
		
		    bind $can.e$id <Button-1> [code $this setStartMark $i $j]
		    bind $can.e$id <Button-3> [code $this setEndMark $i $j]
                    bind $can.e$id <Shift-Button-1> [code $this setEndMark $i $j]
#		    bind $can.e$id <Button-2> [code $this unsetMark]
		    $can create  window \
			[expr $xPos($i)+$cellPixWidth($absColIndex)/2]\
			[expr $yPos($j)+$DC(height)/2]  \
			-height [expr $DC(height) -1] \
			-width $cellPixWidth($i) \
			-window $can.e$id -tags entry_$i
                }
	    }
	  
	}

	for {set i $prevCols} {$i <= $showCols} {incr i} {	
	    set tmpx [expr $xPos($i)-$DC(rightspace)/2-1]
	    $can create line $tmpx 0 $tmpx $DC(ysize) -width 3 \
		-tags colLine_$i
	    $can bind colLine_$i <B1-Motion> \
		[code $this relocateDividLine %x $i]
	    $can bind colLine_$i <Button-1> \
		[code $this startDividLine %x $i]
	    $can bind colLine_$i <ButtonRelease-1> \
		[code $this finalDividLine %x $i]
	    
	}

    } else {  
	for {set i $prevCols} {$i < $showCols} {incr i} {
	    set absColIndex [expr $firstCol -1+$i]
	    set tmpColName [lindex $colSelList $absColIndex]
	    set tmpColNum  [expr $firstCol-1+$i]
	    checkbutton $hdr.name$i -text $columnName($tmpColNum) \
                -font titleFont \
		-variable [scope colSel($this,$i)] \
		-selectcolor $fvPref::checkBBgColor  \
		-activeforeground black \
                -activebackground $fvPref::globalBgColor \
		-command [code $this updateColSel $i]
	    label $hdr.type$i -text $columnType($tmpColNum) -font titleFont
	    label $hdr.unit$i -text $columnUnit($tmpColNum) -font titleFont
	    if { $vecSize($tmpColNum) > 1 || $vecSize($tmpColNum) < 0 } {
		button $hdr.vecB$i -text "expand" -font titleFont -state normal\
		    -borderwidth 2\
		    -command [code $this openVectorTable $tmpColNum]
	    } else {
		button $hdr.vecB$i -text "" -font titleFont -command {} \
		    -state disabled  -borderwidth 0
	    }
	    $hdr create window [expr $xPos($i) + $cellPixWidth($absColIndex)/2]\
		[expr $DC(height)/2] -width $cellPixWidth($absColIndex)  \
		-window $hdr.name$i -tags colInfo_$i
	    $hdr create window [expr $xPos($i) + $cellPixWidth($absColIndex)/2]\
		[expr $DC(height)*3/2 ] -width $cellPixWidth($absColIndex)  \
		-window $hdr.type$i -tags colInfo_$i
	    $hdr create window [expr $xPos($i) + $cellPixWidth($absColIndex)/2]\
		[expr $DC(height)*5/2 ] \
		-width $cellPixWidth($absColIndex)  \
		-window $hdr.unit$i -tags colInfo_$i            
	    $hdr create window [expr $xPos($i) + $cellPixWidth($absColIndex)/2]\
		[expr $DC(height)*7/2 ] \
		-width $cellPixWidth($absColIndex) \
		-window $hdr.vecB$i -tags colInfo_$i   

	    for {set j 0} {$j < $showRows } {incr j} {
               set id ${i}_$j
               catch {entry $can.e$id \
                     -width $cellWidth($absColIndex) \
                     -font entryFont -state disabled \
                     -textvariable [scope numEntry($id)] \
                     -relief sunken -bd 0 -justify right}
               bind $can.e$id <Button-1> [code $this setStartMark $i $j]
               bind $can.e$id <Button-3> [code $this setEndMark $i $j]
               bind $can.e$id <Shift-Button-1> [code $this setEndMark $i $j]
               $can create  window \
                     [expr $xPos($i)+$cellPixWidth($absColIndex)/2]\
                     [expr $yPos($j)+$DC(height)/2]  \
                     -height [expr $DC(height) -1] \
                     -width  $cellPixWidth($absColIndex) \
                     -window $can.e$id -tags entry_$i
	    }

	}

	for {set i $prevCols} {$i <= $showCols} {incr i} {
	    set tmpx [expr $xPos($i)-$DC(rightspace)/2-1]
	    $can create line $tmpx 0 $tmpx $DC(ysize) -width 3 \
		-tags colLine_$i
            $can bind colLine_$i <B1-Motion> \
		[code $this relocateDividLine %x $i]
	    $can bind colLine_$i <Button-1> \
		[code $this startDividLine %x $i]
	    $can bind colLine_$i <ButtonRelease-1> \
		[code $this finalDividLine %x $i]
	    
	}
    }
    reframe
}

body Table::delColsFrTable {prevCols prevRows} {
    set hdr $droot.table.hdr
    set can $droot.table.can
    
    for {set i $showCols} {$i < $prevCols} {incr i} {
	$hdr delete colInfo_$i
	$can delete entry_$i
	catch {destroy $hdr.name$i}
	catch {destroy $hdr.type$i}
	catch {destroy $hdr.unit$i}
	catch {destroy $hdr.vecB$i}
	for {set j 0} {$j < $prevRows } {incr j} {
	    set id ${i}_$j
	    catch {destroy $can.e$id }
	}
    }
    
    for {set i [expr 1+$showCols]} {$i <= $prevCols} {incr i} {
	$can delete colLine_$i
    }
}

body Table::addRowsToTable {prevCols prevRows} {

    set can $droot.table.can

    calXPos $firstCol $showCols

    for {set j $prevRows} {$j < $showRows} {incr j} {
	set realRowNum [expr $firstRow + $j]
	if { $tabType == "Image" } {
	    set rowIndex [expr $numRows -  $realRowNum +1]
	} else {
	    set rowIndex $realRowNum
	}
	label $can.b$j -text $rowIndex -font titleFont
	set yPos([expr $j+1])  [expr $yPos($j)+ $DC(height) + $DC(interline) ]
	$can create window [expr $DC(lmar)+$DC(width)/2] \
	    [expr $yPos($j)+$DC(height)/2]  -window \
	    $droot.table.can.b$j  \
	    -width $DC(width) -height [expr $DC(height)-1] \
	    -tags check
	for {set i 0} {$i < $prevCols } {incr i} {
	    set absColIndex [expr $firstCol -1 +$i]
	    set id ${i}_$j
	    entry $can.e$id -width $cellWidth($absColIndex) \
		-textvariable [scope numEntry($id)] -state disabled \
		-relief sunken -bd 0 -justify right -font entryFont
	    bind $can.e$id <Button-1> [code $this setStartMark $i $j]
	    bind $can.e$id <Button-3> [code $this setEndMark $i $j]
	    bind $can.e$id <Shift-Button-1> [code $this setEndMark $i $j]
#	    bind $can.e$id <Button-2> [code $this unsetMark]
	    $can create  window [expr $xPos($i)+$cellPixWidth($absColIndex)/2]\
		[expr $yPos($j)+$DC(height)/2]  \
		-height [expr $DC(height) -1] \
		-width  $cellPixWidth($absColIndex) \
		-window $can.e$id -tags entry_$i
	}
	$can create line 0 $yPos($j) $DC(xsize) $yPos($j)  -tags rowLine_$j
    }
    
    if { $numRows } {
       $droot.table.vscroll set [expr double($firstRow-1)/$numRows]  \
	     [expr ($firstRow + $showRows - 1.0)/$numRows]
    } else {
       $droot table.vscroll set 0.0 1.0
    }
}

body Table::delRowsFrTable {prevCols prevRows} {
    if {$prevRows > $showRows} {
	set can $droot.table.can
	
	for {set j $showRows} {$j < $prevRows} {incr j} {
	    catch {destroy $can.b$j}
            $can delete rowLine_[expr $j+1]
	    for {set i 0} {$i < $showCols } {incr i} {
		set id ${i}_$j
		catch {destroy $can.e$id }
	    }
	    
	}
	
    }
    refacing
}

body Table::updateLast { } {
   # Update visible cells with current values

   readTabData [expr $firstCol-1] [expr $firstRow-1] $showCols $showRows

   # command in fitsTcl
   # updateCell 

   set col [expr $firstCol-1]
   for {set c 0} {$c<$showCols} {incr c} {
      set row [expr $firstRow-1]
      for {set r 0} {$r<$showRows} {incr r} {
         set id ${c}_${r}
         set val [getFormattedData $col $row]
         if { [string length $val]>$cellWidth($col) } {
            set val "*"
         }
         set numEntry($id) $val
         incr row
      }
      incr col
   }
}

body Table::jumpFrEnt {} {
   jump [$droot.usrEntry.goto_e get]
}

body Table::jump {lineNum} {
    if { $lineNum == "" } {
	puts "Please give me a number"
	return
    }
    if { $lineNum<1 }        { set lineNum 1        }
    if { $lineNum>$numRows } { set lineNum $numRows }
    if { $tabType == "Image" } {
       set realRow [expr $numRows-$lineNum]
    } else {
       set realRow [expr $lineNum-1]    
    }
    setVScroll $realRow
    if { [info exists currentCol] } {
       setStartMark [expr $currentCol-$firstCol+1] \
             [expr $realRow-$firstRow+1]
    } else {
       setStartMark 0 [expr $realRow-$firstRow+1]
    }
}

body Table::selRowsFrExpr { delete } {
   global rowselentry

   if { $delete } {
      set cal ".cald_[namespace tail $this]" 
      if { [winfo exist $cal] == 1 } {
	 raise $cal
	 return 
      }
	    
      # pick out the variable-length vector columns from the calculator
      set calList {}
      for {set i 0} {$i < $dispCols} {incr i} {
	 if { $vecSize($i) > 0 } {
	    lappend calList [lindex $colSelList $i]
	 }
      }
      FitsDelCalculator $cal $this $calList
      $cal configure -title "fv: Delete Rows"
   } else {
      puts "Selection of rows not supported, yet"
   }
}

body Table::addRows {} {
    set addWin .addRow
    catch {destroy .addRow}
    powToplevel $addWin .dummy
    wm title $addWin "fv: Add Rows"

    iwidgets::entryfield $addWin.after -labeltext "After row \#" \
          -labelpos nw -width 10
    iwidgets::entryfield $addWin.number -labeltext "Number of rows" \
          -labelpos nw -width 10
    iwidgets::buttonbox $addWin.bb
    $addWin.bb add OK -text OK -command [code $this addRowsToFile $addWin]
    $addWin.bb add Cancel -text Cancel -command "destroy $addWin"
    pack $addWin.after  -fill x
    pack $addWin.number -fill x
    pack $addWin.bb     -fill x
    tkwait window $addWin
}

body Table::delRowsWithCondition {cond} {
   $fFObj delRowsWithCondition $cond
   $fFObj changeFile

   refresh
   updateRestDisps
}

body Table::delRowsFromList {entry} {
#  don't delete if its an image extension
    if { $tabType == "Image"} {
	error "Cannot delete rows in an image"
	return
    }
# warning
    if { [llength $colSelList] != [llength $colNames] } {
	if { [promptMsg "You are editing only part of the table. \n
Do you want to delete rows from all the columns?" \
		 return Yes No] == "CANCEL"} {
	    return
	}
    }
# get rid of all the white spaces
    regsub -all " " $entry "" tmpEntry 
# break it apart 
    set tmpS [split  $tmpEntry  ","]
# deal with different parts and make a list
    foreach range $tmpS {
	if { [regexp {^[0-9]+$} $range] == 1 } {
	    if {$range <= $numRows} {
		lappend rangeList [list $range $range]
	    } else {
		lappend rangeList [list $numRows $numRows]
	    }
	} else {

	    if {[regsub -- "-" $range "," range1] == 0} {
	
	    } else {
		set tmpPos [string first "," $range1]
	    
		if { $tabType == "Image"} {
		    set n1 [expr $numRows +1 - \
				[string range  $range1 [expr $tmpPos+1] end ] ]
		    set n2 [expr $numRows +1 - \
				[string range  $range1 0 [expr $tmpPos-1]] ]
		} else {
		    set n1 [string range  $range1 0 [expr $tmpPos-1]] 
		    set n2 [string range  $range1 [expr $tmpPos+1] end ] 
		}
		if { $n1 < 1 } {
		    set n1 1
		}
		if { $n2 > $numRows } {
		    set n2 $numRows
		}
		if { $n1 > $n2} {
		    lappend rangeList [list $n2 $n1]
		} else {
		    lappend rangeList [list $n1 $n2]
		}
	    }
	}
    }
# now merge the list chosen.
    
    set numRange [llength $rangeList]
    set leftList $rangeList
    set resultList ""

    while { $numRange > 1} {
	set seedRange [lindex $leftList 0]
	set leftList  [lrange  $leftList 1 end]
	set result [collapse $seedRange $leftList]
	set leftList [lindex $result 1]

	if { [lindex $result 0] == 0 } {
	    lappend resultList $seedRange
	}
	incr numRange -1
    }
    lappend resultList [lindex $leftList 0]
    set resultList [sortRange $resultList]

# if deletion happens before the current firstRow, then the current firstRow will change.
# 
    foreach r $resultList {
	set n0 [lindex $r 0]
	set n1 [lindex $r 1]
	set nn [expr $n1-$n0+1]
# really delete rows in the FITS file
	$fFObj delRows $n0 $nn
	$fFObj changeFile
	if { $firstRow >= $n1 } {
	    incr firstRow [expr -$nn]
	} elseif { $firstRow >= $n0 } {
	    incr firstRow [expr -($firstRow-$n0)]
	} else {

	}
	if { $firstRow < 1} {
	    set firstRow 1
	}
	
    }

    refresh
    updateRestDisps
}

body Table::collapse {seed bed} {
    set flag 0
    set numBedElem [llength $bed]
    set sLow  [lindex $seed 0]
    set sHigh [lindex $seed 1]
#                  |  seed  |
# case 1              **|********|**
# case 2                | ****   | 
# case 3           *****|**      |
# case 4                |     ***|**
#  * bed
    for {set i 0} {$i < $numBedElem} {incr i} {
	set eLow  [lindex [lindex $bed $i] 0] 
	set eHigh [lindex [lindex $bed $i] 1] 
# case 1 
	if { ($sLow > $eLow) && ($sHigh < $eHigh) } {
	    set flag 1
# case 2
	} elseif {($sLow< $eLow) && ($sHigh > $eHigh)} {
	    set flag 1
	    set bed [lreplace $bed $i $i [list $sLow $sHigh]]
# case 3
	} elseif {($sLow>=$eLow) && ($sLow<=$eHigh) && ($sHigh>=$eHigh)  } {
	    set flag 1
	    set bed [lreplace $bed $i $i [list $eLow $sHigh]]
# case 4
	} elseif {($sHigh>=$eLow) && ($sHigh<=$eHigh) && ($sLow<=$eLow)  } {
	    set flag 1
	    set bed [lreplace $bed $i $i [list $sLow $eHigh]]
	} else {

	}
    }
# flag = 1, collapsed
    return [list $flag $bed]
}

body Table::sortRange {bed} {
#
# bed should be a list of ranges, and they are not supposed to have overlaps
# overlap has been delt with in collapse.
#
    foreach i $bed {
	lappend idxList [lindex $i 0]
    }
    set sortedList [lsort -decreasing -integer $idxList]

    for {set j 0} {$j < [llength $sortedList] } {incr j} {
	set tmpIdx [lsearch -exact $idxList [lindex $sortedList $j]]
	if { $tmpIdx == -1} {
	    error "Error sorting"
	    return
	} else {
	    lappend outList [lindex $bed $tmpIdx]
	}
    }
# in a reversed order, since cfitsio should delete the last row first
    return $outList
}

#########################
#
#   modifyTableCell
#
#   Public routine which will modify the contents of a table cell and write
#   it to file if available. col and row are zero-indexed, indicating
#   true row/column of cell to change
#
#########################

body Table::modifyTableCell {col row val} {
   if { $isFailedToCopy } return

   writeTabData $col $row $val

   set id [expr $col-$firstCol+1]_[expr $row-$firstRow+1]
   set numEntry($id) [getFormattedData $col $row]

   $fFObj changeFile
}



body Table::updateColSel {col} {
    set realColNum [expr $firstCol+$col-1] 
    set colState($realColNum) $colSel($this,$col)
}



body Table::resizeCan {x y} {

    set DC(geoX) [winfo width  $droot] 
    set DC(geoY) [winfo height $droot]
    set DC(geoX0) [winfo x $droot]
    set DC(geoY0) [winfo y $droot]
# 
    unselCell
#
    if {$DC(geoX) < 350 } {
	set DC(geoX) 350
	set x 350
    }

    wm geometry $droot [set DC(geoX)]x[set DC(geoY)]+[set DC(geoX0)]+[set DC(geoY0)]
    set DC(xsize) $x 
    set DC(ysize) $y

    $droot.table.hdr configure -width $DC(xsize)
    $droot.table.can configure -width $DC(xsize) -height $DC(ysize)   


    getLastFirstCol

#  determine number of rows and number of columns to display
    layoutCan $DC(xsize) $DC(ysize) 

# to prevent readTabData to be called twice
    if { $justStarted == 1 } {
	set justStarted 0
	return
    }

    reframe 
    refacing 
    setScrolls
    updateLast
# 
    selCell
}

body Table::reframe {} {
    calXPos $firstCol $showCols
    set tmpYPos [expr $showRows*$DC(height) + $DC(tmar) + 1] 
    for {set i 0} {$i<=$showCols} {incr i} {
	set tmpXPos [expr $xPos($i)-$DC(rightspace)/2-1]
	$droot.table.can delete colLine_$i
	$droot.table.can create line $tmpXPos 0 $tmpXPos $tmpYPos \
	      -width 3 -tags colLine_$i
	$droot.table.can bind colLine_$i <B1-Motion> \
	    [code $this relocateDividLine %x $i]
	$droot.table.can bind colLine_$i <Button-1> \
	    [code $this startDividLine %x $i]
	$droot.table.can bind colLine_$i <ButtonRelease-1> \
		[code $this finalDividLine %x $i]
    }    

    for {set j 0} {$j<=$showRows} {incr j} {
	$droot.table.can delete rowLine_$j
	$droot.table.can create line 0 $yPos($j) $DC(xsize) $yPos($j)  \
	    -tags rowLine_$j
    }

    makeJustification
}

body Table::getXYSize {x y} {

    for {set i $firstCol} {$i <= $dispCols} {incr i} {
	set tabXSize [expr $absXPos($i) - $absXPos([expr $firstCol-1]) \
			  + $DC(lmar) + $DC(width) + $DC(rightspace)/2 ]
	if { $tabXSize > $x } break
    }
    set showCols [expr $i - $firstCol]

    for {set j 1} {$j <= $numRows} {incr j} {
	set tabYSize [expr 2*$DC(tmar) + ($j)*($DC(height) + $DC(interline))]
	if { $tabYSize > $y } break
    }
    set showRows [expr $j - 1]

    if { $showRows < 1} {
	set showRows 1
    }

    if { $showCols < 1} {
	set showCols 1
    }
    
    set lastCol [llength $colSelList]

    if {$showRows > $numRows} {
	set showRows $numRows
    }

    if {$showCols > $lastCol} {
	set showCols $lastCol
    }

    if { $firstCol > [expr $lastCol -$showCols+1]} {
	set firstCol [expr $lastCol -$showCols+1]
    }
    if { $firstRow > [expr $numRows -$showRows+1]} {
	set firstRow [expr $numRows -$showRows+1]
    }
}

body Table::layoutCan {x y} {
    set oldShowCols $showCols
    set oldShowRows $showRows
    set oldfirstCol $firstCol

    getXYSize $x $y

    if { $showRows > $oldShowRows } {
	addRowsToTable $oldShowCols $oldShowRows
    } elseif { $showRows <  $oldShowRows} {
	delRowsFrTable $oldShowCols $oldShowRows
    } 

    calXPos $oldfirstCol $showCols
    if { $showCols > $oldShowCols } {
	addColsToTable $oldShowCols $oldShowRows
    } elseif { $showCols <  $oldShowCols} {
	delColsFrTable $oldShowCols $oldShowRows
    } 
}

body Table::saveASCII {} {

   set t [urlTail $fileName]
   set r [file root $t]
   set e [file ext $t]
   if { [lsearch -exact [list .gz .Z .z] $e]!=-1 } {
      set e [file ext $r]
      set r [file root $r]
   }
   set sugName "${r}_t[expr $chdu-1].txt"

    set asciiFileName [getSelectedFileName $sugName]
    if { $asciiFileName == "" } return
    if { [file exist $asciiFileName] == 1 } {
	set feedBack [promptMsg "File $asciiFileName exists.\n overwrite?" \
         return Yes No] 

	if { $feedBack == "CANCEL" } return
    } 

    catch {destroy .table_saveas}
    set fileWin .table_saveas

    powToplevel $fileWin  .dummy
    wm title $fileWin "fv: Save as file dialog"
    wm geometry $fileWin 400x200

    frame ${fileWin}.f 

    iwidgets::feedback ${fileWin}.f.fb -labeltext "Saved" 
    pack ${fileWin}.f.fb -fill x -expand yes
    iwidgets::buttonbox ${fileWin}.f.b 
    pack ${fileWin}.f.b -side top

    ${fileWin}.f.b add continue -text "Save" \
	-command [code $this saveTableToAscii $fileWin $asciiFileName ] 
    ${fileWin}.f.b add quit  -text "Cancel" \
	-command "destroy $fileWin"

    iwidgets::entryfield ${fileWin}.wid -labeltext "Column width:" \
	-textvariable [scope asciiColWidth]
    pack ${fileWin}.wid -side top -fill x -expand 1
    pack ${fileWin}.f -side bottom -fill x -expand 1
}

body Table::saveTableToAscii  {win asciiFileName} {

# setup the grouping 
  set tmpWidth  [expr 1+$cellWidth(0)]
  set tmpFirstCol(0) 0
  set groupCount  0  
  set tmpNumCols [llength $colSelList]
  for {set  n 0} {$n < [expr $tmpNumCols-1]} {incr n} {
      set tmpWidth [expr  $tmpWidth + $cellWidth([expr 1+$n])+1]
      if { $tmpWidth >= [expr $asciiColWidth-4]} {
	 incr groupCount 
	 set tmpWidth  [expr 1+$cellWidth([expr 1+$n])];
	 set tmpFirstCol($groupCount) [expr  $n+1]
      }
  }

  incr groupCount
  set tmpFirstCol($groupCount) $tmpNumCols

# setup the row grouping 
  set niter [expr $numRows/1000]

  $win.f.fb configure -steps [expr (1+$niter)*$groupCount]
  for {set k 0} {$k< $groupCount} {incr k} {
      set tmpWid {}
      for {set i $tmpFirstCol($k) } {$i < $tmpFirstCol([expr $k+1])} {incr i} {
	  lappend tmpWid [expr 1+$cellWidth($i)]
      }     
      set colList [lrange $colSelList  $tmpFirstCol($k) \
		       [expr $tmpFirstCol([expr $k+1])-1]]

      for {set m 0} {$m < [expr $niter+1]} {incr m} {
	  set frow [expr $m*1000+1] 
	  if { $niter == $m} {
	      set nrow [expr $numRows-$m*1000]
	  } else {
	      set nrow 1000
	  }
	  if { ($k ==0) && ($m==0) } {
# write into a new file and write column names...
	      $fFObj saveTabToASCII $asciiFileName 0 \
		  $frow $nrow [expr $tmpFirstCol($k)+1] $colList $tmpWid
	  } elseif { $m==0 } {
# append to that file write column names
	      $fFObj saveTabToASCII $asciiFileName 1 \
		  $frow $nrow [expr $tmpFirstCol($k)+1] $colList $tmpWid
	  } else {
# append to taht file and don't write column names
	      $fFObj saveTabToASCII $asciiFileName 2 \
		  $frow $nrow [expr $tmpFirstCol($k)+1] $colList $tmpWid
	  }

	  if {[catch {$win.f.fb step}] == 1} {
	      file delete $asciiFileName
	      return
	  }
      }
  }
  destroy $win

}

body Table::saveFile {} {

# Save File
    $fFObj save
    updateHL
}

body Table::saveAs {} {
    $fFObj saveAs
}

body Table::updateHL {} {
# Override this function in descendents
}

body Table::closeFrWm {w} {
    if { $w == $droot && !$isBeingDestroyed } {
	closeCmd
    } 
}

body Table::closeCmd {} {
   foreach i $myChildren {
       delete object $i
   }
   updateHL
   realCloseCmd
}


body Table::realCloseCmd {} {

# let the winkeeper know it's gone
    if { $isDirPlot == 0 } {
	.fvwinkeeper signoff $droot
    }

    delete object $this
}


body Table::updateNumRows {} {
    if { $tabType == "Image"} {
	set numRows  [lindex [$fFObj getImgInfo] 1]      
    } else {
	set numRows  [$fFObj getTabInfo nrows]
    }

}

body Table::updateNumCols {} {
   # Do nothing here.  Override in subclasses
}


body Table::addCols {} {
    # Init the variables
    set addcolname ""
    set addcolunit ""
    set addcoldisp ""
    set addcolform ""

    set addWin .addCol
    catch {destroy .addCol}
    powToplevel $addWin .dummy
    wm title $addWin "fv : add column info"

    iwidgets::entryfield $addWin.name -labeltext "Column Name" -labelpos w \
	-validate "validColName %c" -fixed 68 -width 10 \
	-textvariable [scope addcolname]
# the format list
    if { $tabType == "Binary Table"} {
	set formatList {{1A - ASCII string} {1L - logical (T or F)} \
		    {1X - bit} {1B - 1 byte unsigned integer} \
		    {1I - 2 byte integer}  {1J - 4 byte integer}\
		    {1E - 4 byte real} {1D - 8 byte double} \
		    {1C - 8 byte complex} {1M - 16 byte double complex} }
    } elseif { $tabType == "ASCII Table"} {
	set formatList \
	    {{A10 - 10 chars ASCII string} {I10 - 10 digits integer} \
		 {F10.2  - 10 digits real with two sig digits} \
		 {E10.2  - 10 digits real with exp} \
		 {D20.10 - 20 digits double with 10 sig digits}}
    } else {
	set formatList { }
    }

    iwidgets::combobox $addWin.form -labeltext "Column Format" -labelpos w \
	-textvariable [scope addcolform] -completion 0
    eval $addWin.form insert list end $formatList

    iwidgets::entryfield $addWin.unit -labeltext "Column Unit" -labelpos w \
	-fixed 68 -width 10 -textvariable [scope addcolunit]
    iwidgets::entryfield $addWin.disp -labeltext "Display Format" -labelpos w \
	-fixed 68 -width 10 -textvariable [scope addcoldisp]

    set tmpList $colSelList
    set tmpList [lappend tmpList "End of Table"]
    iwidgets::combobox $addWin.colist -labeltext "Insert Before" -labelpos w \
	-editable 0 -textvariable [scope insColNum]
    eval $addWin.colist insert list end $tmpList

    grid $addWin.name   -row 1 -col 1 -sticky ew -padx 10 -pady 2
    grid $addWin.form   -row 2 -col 1 -sticky ew -padx 10 -pady 2
    grid $addWin.unit   -row 3 -col 1 -sticky ew -padx 10 -pady 2
    grid $addWin.disp   -row 4 -col 1 -sticky ew -padx 10 -pady 2
    grid $addWin.colist -row 5 -col 1 -sticky ew -padx 10 -pady 2
    iwidgets::Labeledwidget::alignlabels \
          $addWin.name $addWin.unit $addWin.form $addWin.colist

    iwidgets::buttonbox $addWin.bb

    $addWin.bb add OK -text OK -command [code $this addColsToFile $addWin]
    $addWin.bb add Cancel -text Cancel -command "destroy $addWin"

    grid $addWin.bb     -row 6 -col 1

    tkwait window $addWin
}


body Table::addRowsToFile {inWin} {
    set rowIdx [$inWin.after get]
    set rowNum [$inWin.number get]
    regsub -all " " $rowIdx "" tmpIdx
    regsub -all " " $rowNum "" tmpNum
# delete the input window
    destroy $inWin

    if { ($tmpIdx == "") || ($tmpNum == "") } {
	error "Please input number"
	return
    } elseif { $tmpIdx=="end" } {
       set tmpIdx $numRows
    }
    #  We asked for row "after", but CFITSIO inserts "before"
    incr tmpIdx
    if { $tmpIdx > $numRows} {
	$fFObj addRow $tmpNum
    } else {
	$fFObj insertRow $tmpIdx $tmpNum
    }
    $fFObj changeFile
    refresh
    updateRestDisps
}

body Table::addColsToFile {inWin} {

    set addPos  $insColNum
# delete the input window
    destroy $inWin
    
    set tmpcolform [lindex $addcolform 0] 

    regsub -all " " $addcolname "" tmpName
    regsub -all " " $addcolunit "" tmpUnit
    regsub -all " " $addcoldisp "" tmpDisp
    regsub -all " " $tmpcolform "" tmpForm
    if { ($tmpName == "") || ($tmpForm == "")} {
	error "Column name/form can't be blank"
	return
    }

    if { $addPos == "End of Table" } {
	$fFObj addColumn $addcolname $tmpcolform
	lappend colSelList $addcolname
	lappend colNames   $addcolname
        if { $tmpUnit != "" } {
	   $fFObj putKwd "TUNIT[llength $colNames] '$tmpUnit'" 1 
        }
        if { $tmpDisp != "" } {
	   $fFObj putKwd "TDISP[llength $colNames] '$tmpDisp'" 1 
        }
    } else {
	set tmpIdx  [lsearch $colSelList $addPos]
	set tmpIdx1 [lsearch $colNames   $addPos]
        if { ($tmpIdx == -1) || ($tmpIdx1 == -1)} {
	    error "No such column"
	    return
	}
        $fFObj insertCol [expr $tmpIdx1+1] $addcolname $tmpcolform
        set colSelList [linsert $colSelList $tmpIdx  $addcolname]
        set colNames   [linsert $colNames   $tmpIdx1 $addcolname]
        if { $tmpUnit != "" } {
           $fFObj putKwd "TUNIT[expr $tmpIdx1+1] '$tmpUnit'" 1 
        }
        if { $tmpDisp != "" } {
	   $fFObj putKwd "TDISP[expr $tmpIdx1+1] '$tmpDisp'" 1 
        }
        for {set j $dispCols} {$j > $tmpIdx} {incr j -1} {
           set cellWidth($j) $cellWidth([expr $j-1])
        }
        unset cellWidth($j)
    }

# let the fFObj know that the file has been changed
    $fFObj changeFile
# update the displayed table and children
    refresh 0
    updateRestDisps
}

body Table::refresh { {doChildren 1} } {

    # Re-read table information
    readInTable

    # Check the number of rows and columns in the table
    set oldNumCols $numCols
    set oldNumRows $numRows
    updateNumCols
    updateNumRows
    if { $oldNumCols != $numCols || $oldNumRows != $numRows } {
       layoutCan $DC(xsize) $DC(ysize) 
       reframe
    }
    
    # recalculate the firstCol of the last page
    getLastFirstCol

    # redraw the table and more
    setHScroll [expr $firstCol-1]
    refacing

    # Update any children of this table, if they exist
    if { $doChildren } {
       foreach child $myChildren {
          $child refresh
       }
    }
}

body Table::delCols {} {
    if { $tabType == "Image"} {
	error "Cannot delete columns in an image"
	return
    }
# clean the cell selection
    unselCell

    set delColList {}
    set tmpList {}
    set j 0
    for {set i 0} { $i < $dispCols} {incr i} {
	if { $colState($i) == 1 } {
	    lappend delColList [lindex $colSelList $i]
	} else {
	    lappend tmpList [lindex $colSelList $i]
            set cellWidth($j) $cellWidth($i)
            incr j
	}
    }
    for {} {$j < $dispCols} {incr j} {
       unset cellWidth($j)
    }

    set colSelList $tmpList
#   update the firstRow : updateFirstRow is a fitsTcl command
    set firstCol [updateFirst -c $firstCol $dispCols]

#   delete row in the file
    $fFObj delCols $delColList
    $fFObj changeFile

# then update table info
#    updateNumCols
# refresh the table and children
    refresh
    updateRestDisps
# reselect the cell
    selCell
}

body Table::setArrayAToB {a b} {
    upvar $a tmpA
    upvar $b tmpB

    foreach i [array names tmpA] {
	set tmpB($i) $tmpA($i)
    }
}


body Table::tryDelCols {} {
    promptMsg \
	  "Table columns will be permanently deleted.\nAre you sure?" \
	  [code $this delCols] Yes No
}

########################################################
#
#        Cursor  Motion  Selection
#

body Table::setEndMark {col row} {
    unselCell
#
    if { $oldcstartx == ""} return
    if { $oldcstarty == ""} return

    set cendx   [expr $firstCol + $col -1]
    set cendy   [expr $firstRow + $row -1]
    if { $cendx <= $oldcstartx} {
	set cstartx $cendx
	set cendx $oldcstartx
    } else {
        set cstartx $oldcstartx
    }
    if { $cendy <= $oldcstarty} {
	set cstarty $cendy
	set cendy $oldcstarty
    } else {
        set cstarty $oldcstarty
    }
    
    selCell
}

body Table::unsetMark {} {
    unselCell
    set oldcstartx ""
    set oldcstarty ""
    set cstartx ""
    set cstarty ""
    set cendx ""
    set cendy ""
}

body Table::setStartMark {col row} {
    unsetMark
    set cstartx [expr $firstCol + $col -1]
    set cstarty [expr $firstRow + $row -1]
    set oldcstartx $cstartx
    set oldcstarty $cstarty
    copyCell $col $row
    focus $droot.table.can
}

body Table::copyCell {col row} {
    unselCell
    set currentCol [expr $firstCol+ $col -1]
    set currentRow [expr $firstRow+ $row -1]
    if { $currentCol<0 } {
       set currentCol 0
    } elseif { $currentCol >= $dispCols } {
       set currentCol [expr $dispCols-1]
    }
    if { $currentRow<0 } {
       set currentRow 0
    } elseif { $currentRow >= $numRows } {
       set currentRow [expr $numRows-1]
    }
    selCell
}

body Table::unselCell {} {

# individual cell
    if { [info exist currentCol] } {
	set tmpCol [expr $currentCol - $firstCol+1]
	set tmpRow [expr $currentRow - $firstRow+1]
	if { ($tmpCol >= $showCols) || ($tmpCol < 0) || ($tmpRow >= $showRows) \
		 || ($tmpRow < 0) } {
	    ;
	} else {
	    set id ${tmpCol}_$tmpRow
	    $droot.table.can.e$id configure -bg $fvPref::globalBgColor
	    set cellVar ""
	}
    }
# a block of table
    for {set i 0} { $i < $showCols} { incr i} { 
       for {set j 0} { $j < $showRows} { incr j} { 
          set id ${i}_$j
          $droot.table.can.e$id configure -bg $fvPref::globalBgColor
       }
    }
}

body Table::selCell {} {

    if { [info exist currentCol] } {
	set tmpCol [expr $currentCol - $firstCol+1]
	set tmpRow [expr $currentRow - $firstRow+1]
	if { ($tmpCol >= $showCols) || ($tmpCol < 0) || \
              ($tmpRow >= $showRows) || ($tmpRow < 0) } {
           $droot.usrEntry.sel_e config -state disabled
	} else {
           $droot.usrEntry.sel_e config -state normal
	    set id ${tmpCol}_$tmpRow
	    $droot.table.can.e$id configure -bg yellow
            set cellVar [getRawData $currentCol $currentRow]
            $droot.usrEntry.sel_e selection range 0 end
	}
    }

# a block of table
    if { ($cstartx == "") || ($cstarty == "") || ($cendx == "")  \
	     || ($cendy == "") } {
	return
    } else {
	for {set i 0} {$i< $showCols} {incr i} {
	    set tmpCol [expr $firstCol +$i -1]
	    if { ($tmpCol >= $cstartx) && ($tmpCol<=$cendx) } { 
		for {set j 0} { $j < $showRows} { incr j} { 
		    set tmpRow  [expr $firstRow+$j-1]
		    if { ($tmpRow >= $cstarty) && ($tmpRow<=$cendy) } {  
			set id ${i}_$j
			$droot.table.can.e$id configure -bg green		
		    }
		}
	    }
	}
    }

}



body Table::cellUp {} {
# if no cell is selected do nothing.
    if { [info exist currentRow] == 0} return
# if up to the first row do nothing.
    if { $currentRow <= 0 } return

# if the current row is on the last page scroll up
    if { $currentRow < $firstRow} {
	incr firstRow -1 
	refresh 0
    }
#
    set tmpCol [expr $currentCol - $firstCol+1] 
    set tmpRow [expr $currentRow - $firstRow+1]
    setStartMark $tmpCol [expr $tmpRow-1]
}

body Table::cellDown {} {
# if no cell selected, do nothing
    if { [info exist currentRow] == 0} return
# if down to the last row, do nothing
    if { $currentRow >  $numRows  } return    
    if { $currentRow >= [expr $firstRow + $showRows -2]} {
	incr firstRow 
	refresh 0
    }
    set tmpCol [expr $currentCol - $firstCol+1] 
    set tmpRow [expr $currentRow - $firstRow+1]
    setStartMark $tmpCol [expr $tmpRow+1]
}

body Table::pageUp {} {
    unselCell

    if { [expr $firstRow - $showRows +1 ] < 1} {
	set firstRow 1
    } else {
	set firstRow [expr $firstRow - $showRows + 1 ]
    }

    refresh 0
    selCell
    
}

body Table::pageDown {} {
    unselCell

    if { [expr $firstRow + $showRows -1] >  [expr $numRows - $showRows +1]} {
	set firstRow [expr $numRows - $showRows +1]
    } else {
	set firstRow [expr $firstRow + $showRows -1]
    }
    refresh 0
    selCell
}

body Table::cellLeft {} {
# if no cell is selected do nothing.
    if { [info exist currentCol] == 0} return
# if left to the first row do nothing.
    if { $currentCol <= 0  } return    
# real move
    if { $currentCol < $firstCol } {
	setHScroll [expr $firstCol -2]
    }    
#
    set tmpCol [expr $currentCol - $firstCol+1] 
    set tmpRow [expr $currentRow - $firstRow+1]
    setStartMark [expr $tmpCol-1] $tmpRow
}

body Table::cellRight {} {
# if no cell is selected do nothing.
    if { [info exist currentCol] == 0} return
# if right to the last row do nothing.
    if { $currentCol > $dispCols  } return    
# real move
    while { $currentCol >= [expr $firstCol+$showCols-2] \
          && [expr $firstCol+$showCols]<=$dispCols } {
       setHScroll $firstCol
    }    

#
    set tmpCol [expr $currentCol - $firstCol+1] 
    set tmpRow [expr $currentRow - $firstRow+1]
    setStartMark [expr $tmpCol+1] $tmpRow
}

body Table::editCell {} {
   if { [$droot.usrEntry.sel_e cget -state]=="disabled" } return
   if { $cellVar=="" } {
      # Reset value
      selCell
   } else {
      modifyTableCell $currentCol $currentRow $cellVar
   }
   focus $droot.table.can
   $droot.usrEntry.sel_e selection range 0 end
}


#
#                            End  Cursor Motion Selection
#
###########################################################

body Table::getArray {name index} {
    return [set ${name}($index)]
}


body Table::calculateCmd {} {

    set cal ".cal_[namespace tail $this]"
    if { [winfo exist $cal] == 1 } {
	raise $cal
	return 
    }
    set calList [getCalcCols]
    FitsCalculator $cal $this $calList
    $cal configure -title "fv: Calculator"
}

body Table::getCalcCols {} {
# pick out the variable-length and zero-lngth vector columns from the calculator
    set calList {}
    for {set i 0} {$i < $dispCols} {incr i} {
	if { $vecSize($i) > 0 } {
	    lappend calList [lindex $colSelList $i]
	}
    }
    return $calList
}

body Table::calculateCols {colname colform formula} {

    set result [catch {set isNew \
                   [$fFObj addColumnFrExpr $colname $colform $formula] } err] 

    if { $result == 1 } {
	error "Calculation failed\n$err"
    } 
    $fFObj changeFile

    if { $isNew == 1 } {
	lappend colSelList $colname
    }

    updateNumCols
    reframe
    refresh
    updateRestDisps
}

body Table::updateRestDisps {} {
   # Update any other windows attached to this extension
   $father updateDisps $this
}


body Table::sortCmd {} {

    catch {destroy .fvsort}
    powToplevel .fvsort .dummy
    wm title .fvsort "fv: Sort"

    resetSKey
    set [scope isUniqMerge] 0
    
    label   .fvsort.label -text "Select column name for sorting" 
    label   .fvsort.lbl -text "Columns"
    listbox .fvsort.lb -yscrollcommand ".fvsort.sb set"
    scrollbar .fvsort.sb -command ".fvsort.lb yview"

    checkbutton .fvsort.fkeyc -variable [scope psortcheck] \
	-selectcolor $fvPref::checkBBgColor  \
	-activeforeground black -activebackground $fvPref::globalBgColor \
        -width 0 	
    checkbutton .fvsort.skeyc -variable [scope ssortcheck]  \
	-selectcolor $fvPref::checkBBgColor  \
	-activeforeground black -activebackground $fvPref::globalBgColor \
        -width 0	

    checkbutton .fvsort.tkeyc -variable [scope tsortcheck]  \
	-selectcolor $fvPref::checkBBgColor  \
	-activeforeground black -activebackground $fvPref::globalBgColor \
        -width 0	

    frame   .fvsort.fsep -relief raised -borderwidth 2 -height 4
    frame   .fvsort.fsep1 -relief raised -borderwidth 2 -height 4
    checkbutton .fvsort.merge -variable [scope isUniqMerge] \
	-selectcolor $fvPref::checkBBgColor -text  No \
	-activeforeground black -activebackground $fvPref::globalBgColor \
        -width 0 -command [code $this changeUniqLabel]

    label   .fvsort.mlabel -text "Delete multiple rows that have the same sort column values?"

    button .fvsort.fkeyb -text "Primary Column" -command [code $this getSortKey 1]
    button .fvsort.skeyb -text "Second Column" -command [code $this getSortKey 2]
    button .fvsort.tkeyb -text "Third Column" -command [code $this getSortKey 3]

    entry .fvsort.fkeye -textvariable [scope psortkey] 
    entry .fvsort.skeye -textvariable [scope ssortkey]
    entry .fvsort.tkeye -textvariable [scope tsortkey]
    label .fvsort.ascend  -text "Ascending ?"
    label .fvsort.help  -text "Select Column(s) for sorting"

    iwidgets::buttonbox .fvsort.bb 
    .fvsort.bb add sort -text "Sort" -command [code $this sortColumn]
    .fvsort.bb add clear -text "Clear" -command [code $this resetSKey]
    .fvsort.bb add cancel -text "Cancel" -command "destroy .fvsort"
    .fvsort.bb add help -text "Help" -command "hhelp sortColumn"
    
    foreach i $colSelList {
	.fvsort.lb insert end $i
    }
    grid configure .fvsort.lbl -column 0 -row 0 -sticky "snew" 
    grid configure .fvsort.lb -column 0 -row 1 -sticky "snew"  -rowspan 7
    grid configure .fvsort.sb -column 1 -row 1 -sticky "snew"  -rowspan 7
    grid configure .fvsort.ascend -column 2 -row 0 -sticky "snew" 
    grid configure .fvsort.help  -column 3 -row 0 -sticky "snew" -columnspan 2

    grid configure .fvsort.fkeyc -column 2 -row 1 -sticky "snew" 
    grid configure .fvsort.fkeyb -column 3 -row 1 -sticky "snew" 
    grid configure .fvsort.fkeye -column 4 -row 1 -sticky "snew"

    grid configure .fvsort.skeyc -column 2 -row 2 -sticky "snew"
    grid configure .fvsort.skeyb -column 3 -row 2 -sticky "snew"
    grid configure .fvsort.skeye -column 4 -row 2 -sticky "snew"

    grid configure .fvsort.tkeyc -column 2 -row 3 -sticky "snew"
    grid configure .fvsort.tkeyb -column 3 -row 3 -sticky "snew"
    grid configure .fvsort.tkeye -column 4 -row 3 -sticky "snew"

    grid configure .fvsort.fsep -column 2 -row 4 -sticky "ew" \
	-columnspan 3
    grid configure .fvsort.merge -column 2 -row 5 -sticky "snew"
    grid configure .fvsort.mlabel -column 3 -row 5 -columnspan 2 \
    -sticky "w"
    grid configure .fvsort.fsep1 -column 2 -row 6 -sticky "ew" \
	-columnspan 3
 
    grid configure .fvsort.bb    -column 2 -row 7 -sticky "snew" -columnspan 3
}

body Table::resetSKey {} {
    set psortkey ""
    set ssortkey ""
    set tsortkey ""
    set psortcheck 1
    set ssortcheck 1
    set tsortcheck 1
}

body Table::getSortKey {key} {
    

    if { [catch {set curSel [lindex $colSelList [.fvsort.lb curselection]]} \
	      err] == 1 } {
	error "Please Select a column name from left-hand window first"
	return
    }

    switch $key {
	1 {
	    set psortkey $curSel
	}
	2 {
	    set ssortkey $curSel
	}
	3 {
	    set tsortkey $curSel
	}
	default {
	    error "Unknown key"
	    return
	}
    }
}

body Table::sortColumn {} {
    set sortkey ""
    set sortcheck ""

    if { $psortkey == "" } {
	error "You need to select at least the primary key for sorting"
	return
    } else {
	lappend sortkey $psortkey
	lappend sortcheck $psortcheck
    }
    
    if { $ssortkey != ""} {
	lappend sortkey $ssortkey
	lappend sortcheck $ssortcheck
	
    }
    if { $tsortkey != ""} {
	lappend sortkey $tsortkey
	lappend sortcheck $tsortcheck
    }

    doSort $sortkey $sortcheck $isUniqMerge
    destroy .fvsort
}

body Table::doSort { keys dirs unique } {
   if { [catch {$fFObj sort $keys $dirs $unique} err] } {
      error "Sort failed: $err"
      return
   }

   $fFObj changeFile
   refresh
   updateRestDisps
}


body Table::cpyToCB {} {
    
    # if nothing is selected return
    if { $cstartx == "" } return
    
    set colStart $cstartx
    if { $cendx=="" } {
        set colEnd $cstartx
    } else {
        set colEnd $cendx
    }

    set rowStart $cstarty
    if { $cendy=="" } {
        set rowEnd $rowStart
    } else {
        set rowEnd $cendy
    }

    set clipType "table"

    set dx [expr $colEnd-$colStart+1]
    set dy [expr $rowEnd-$rowStart+1]
    set dataList [getRawDataBlock $colStart $rowStart $colEnd $rowEnd]

    fvClipBoard register $clipType $fileName "${dx}x${dy}" $dataList
}

body Table::cpyFrCB {} {
# make sure the insert point is present
    if { [info exist currentCol] == 0} {
	error "Please highlight the insert point"
	return 
    }
# get info from the clipboard
    if { [fvClipBoard hasRec] } {
	set cbinfo [fvClipBoard report]
	set clipType [lindex $cbinfo 0]
	set clipData [lindex $cbinfo 2]
	if { $clipType == "table" } {
           $fFObj changeFile
           # Clip to Table size
           set nCols [llength $clipData]
           if { [expr $nCols+$currentCol] > $numCols } {
              set clipData [lrange $clipData 0 [expr $numCols-$currentCol-1] ]
           }
           set nRows [llength [lindex $clipData 0]]
           if { [expr $nRows+$currentRow] > $numRows } {
              set lRow [expr $numRows-$currentRow-1]
              set newData {}
              foreach c $clipData {
                 lappend newData [lrange $c 0 $lRow]
              }
              set clipData $newData
           }
           putRawDataBlock $currentCol $currentRow $clipData
	} else {
	    error "The clipboard currently contains \"$clipType\" data.  Cannot\
                paste this into a table."
	} 

    }
    refresh
}

body Table::getFitsFileCmd {} {
    return $fitsfileCmd
}

body Table::changeUniqLabel {} {
    if { $isUniqMerge == 1} {
	.fvsort.merge configure -text Yes
    } else {
	.fvsort.merge configure -text No
    }
}


body Table::statCmd {} {

    catch {destroy .fvstat}
    powToplevel .fvstat .dummy
    wm title .fvstat "fv: Column Statistics"  

    label   .fvstat.lbl -text "Select column:" 
    listbox .fvstat.lb -yscrollcommand ".fvstat.sb set"
    scrollbar .fvstat.sb -command ".fvstat.lb yview" 
    foreach i $colSelList {
	.fvstat.lb insert end $i
    }
    bind .fvstat.lb <Double-Button-1> [code $this statSelCmd]
    bind .fvstat.lb <ButtonRelease-1> [code $this statSelCmd]

    label .fvstat.namel -text "Column Name"
    label .fvstat.numl -text "Number of values"
    label .fvstat.minl -text "Min"
    label .fvstat.maxl -text "Max"
    label .fvstat.meanl -text "Mean"
    label .fvstat.fminl -text "First minimum in row"
    label .fvstat.fmaxl -text "First maximum in row"
    label .fvstat.stdl -text "Standard deviation"
    label .fvstat.rowrangel -text "Row range"

    set [scope  colSName($this)] ""
    set [scope  colNumVal($this)] ""
    set [scope  colMin($this)] ""
    set [scope  colMax($this)] ""
    set [scope  colMean($this)] ""
    set [scope  colFMin($this)] ""
    set [scope  colFMax($this)] ""
    set [scope  colStd($this)] ""
    set colRowRange($this) ""

    entry .fvstat.namee -textvariable [scope colSName($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.nume -textvariable [scope colNumVal($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.mine -textvariable [scope colMin($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.maxe -textvariable [scope colMax($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.meane -textvariable [scope colMean($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.fmine -textvariable [scope colFMin($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.fmaxe -textvariable [scope colFMax($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.stde  -textvariable [scope colStd($this)] \
	-relief raised -borderwidth 1 -stat disabled
    entry .fvstat.rowrange -textvariable [scope colRowRange($this)]
    bind .fvstat.rowrange <Return> +[code $this statSelCmd]

    button .fvstat.ok -text Close -command "destroy .fvstat"
    button .fvstat.help -text Help -command "hhelp columnStatistics"

    grid configure .fvstat.lbl -column 0 -row 0 -columnspan 2 \
	-sticky "snew"
    grid configure .fvstat.lb -column 0 -row 1 -rowspan 9 \
	-sticky "snew" 
    grid configure .fvstat.sb -column 1 -row 1 -rowspan 9 \
	-sticky "snw"

    grid configure .fvstat.namel -column 2 -row 0 \
	-sticky "snw"
    grid configure .fvstat.numl -column 2 -row 1 \
	-sticky "snw"
    grid configure .fvstat.minl -column 2 -row 2 \
	-sticky "snw"
    grid configure .fvstat.maxl -column 2 -row 3 \
	-sticky "snw"
    grid configure .fvstat.meanl -column 2 -row 4 \
	-sticky "snw"
    grid configure .fvstat.fminl -column 2 -row 5 \
	-sticky "snw"
    grid configure .fvstat.fmaxl -column 2 -row 6 \
	-sticky "snw"
    grid configure .fvstat.stdl -column 2 -row 7 \
	-sticky "snw"
    grid configure .fvstat.rowrangel -column 2 -row 8  \
	-sticky "snw"

    grid configure .fvstat.namee -column 3 -row 0 \
	-sticky "snew"
    grid configure .fvstat.nume -column 3 -row 1 \
	-sticky "snew"
    grid configure .fvstat.mine -column 3 -row 2 \
	-sticky "snew"
    grid configure .fvstat.maxe -column 3 -row 3 \
	-sticky "snew"
    grid configure .fvstat.meane -column 3 -row 4 \
	-sticky "snew"
    grid configure .fvstat.fmine -column 3 -row 5 \
	-sticky "snew"
    grid configure .fvstat.fmaxe -column 3 -row 6 \
	-sticky "snew"
    grid configure .fvstat.stde -column 3 -row 7 \
	-sticky "snew"    
    grid configure .fvstat.rowrange -column 3 -row 8 \
	-sticky "snew"    

    grid configure .fvstat.ok -column 2 -row 9 \
	-sticky "s"    
    grid configure .fvstat.help -column 3 -row 9 \
	-sticky "s"    

    
}

body Table::statSelCmd {} {

    set tmpindex [.fvstat.lb curselection]
    if {$tmpindex == "" } return

    set tmpName [.fvstat.lb get $tmpindex]

#    set colRowRange($this) [string trim $colRowRange($this) " " ]

    if { $colRowRange($this) == "" } {
	set tmprange "1-$numRows"
    } else {
#	set tmprange [split $colRowRange($this) ","]
	set tmprange $colRowRange($this)
    }
    set paramList [$fFObj getColStat $tmpName 1 $tmprange]

   .fvstat.namee  configure -state normal
   .fvstat.mine  configure -state normal
   .fvstat.maxe  configure -state normal
   .fvstat.meane configure -state normal
   .fvstat.fmine configure -state normal
   .fvstat.fmaxe configure -state normal
   .fvstat.stde  configure -state normal

    set [scope  colSName($this)] $tmpName
    set [scope  colMin($this)] [lindex $paramList 0]
    set [scope  colFMin($this)] [lindex $paramList 1]
    set [scope  colMax($this)] [lindex $paramList 2]
    set [scope  colFMax($this)] [lindex $paramList 3]
    set [scope  colMean($this)] [lindex $paramList 4]
    set [scope  colStd($this)] [lindex $paramList 5]
    set [scope  colNumVal($this)] [lindex $paramList 6]

   .fvstat.namee  configure  -state disabled
   .fvstat.mine  configure  -state disabled
   .fvstat.maxe  configure  -state disabled
   .fvstat.meane configure  -state disabled
   .fvstat.fmine configure  -state disabled
   .fvstat.fmaxe configure  -state disabled
   .fvstat.stde  configure  -state disabled

}

# column of string can be left or right justified.
body Table::makeJustification {} {

    if { $fvPref::ifLeftJustifyString == 0} return
    for {set i 0} {$i < $showCols} {incr i} {
	set tmpIndex [expr $firstCol + $i -1]
	if { [regexp A $columnType($tmpIndex)] == 1} {
	    for {set j 0} { $j< $showRows} {incr j} {
		set id ${i}_$j
		$droot.table.can.e$id configure -justify left
	    }
	} else {
	    for {set j 0} { $j< $showRows} {incr j} {
		set id ${i}_$j
		$droot.table.can.e$id configure -justify right
	    }

	}
    }
}

body Table::bringToFront {} {
   if { $droot == "" || ![winfo exists $droot] } {return 0}
   if { ![winfo ismapped $droot] } {
       wm deiconify $droot
   }
   raise $droot
   focus $droot
   return 1
}


body Table::openVectorTable { colNum } {
   set fV [VectorTable #auto $colNum $this]
   $fV makeTable
}


body Table::addChild { child } {
   lappend myChildren $child
}


body Table::freeChild { child } {
   set pos [lsearch $myChildren $child]
   if { $pos != -1 } {
      set myChildren [lreplace $myChildren $pos $pos]
   }
}
