%define version 0.60
%define prefix	/usr

Summary: Figaro's Password Manager
Name: fpm
Version: %{version}
Release: 1
Group: Applications/Utilities
Copyright: GPL
Source: fpm-%{version}.tar.gz
URL: http://fpm.sourceforge.net/
Requires: gtk+ >= 1.2
BuildRoot: %{_tmppath}/%{name}-%{version}-root
Prefix: %prefix

%description
Figaro's Password Manager is a program that allows you to securely store the
passwords you use on the web.  Features include:
- Passwords are encrypted with the blowfish algorithm
- Copy passwords or usernames to the clipboard
- Copy passwords or usernames to the primary selection. (And paste them with a
  middle mouse button click)
- If the password is for a web site, FPM can keep track of the URLs of your
  login screens and can automatically launch your browser.  In this capacity,
  FPM acts as a kind of bookmark manager.
- Combine all three features: you can configure FPM to bring you to a web
  login screen, copy your username to the clipboard and your password to the
  primary selection, all with a single button click.
- FPM also has a passord generator that can choose passwords for you.  It
  allows you to determine how long the password should be, and what types of
  characters (lower case, upper case, numbers and symbols) should be used.
  You can even have it avoid ambiguous characters such as a capital O or the
  number zero.
         
%prep
%setup

%build
./configure --prefix=/usr
make

%install
make prefix=$RPM_BUILD_ROOT%{prefix} install

%files
%defattr(-, root, root)

%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/bin/fpm
%{prefix}/share/pixmaps/fpm/*
%{prefix}/man/man1/fpm.1.gz
