/* font.h
 * 
 * This program is distributed under the GNU General Public License.
 * Copyright (C) 2000 Eugene Osintsev <gene@linuxave.net>
 */

#ifndef _FONT_H_
#define _FONT_H_

/* The structure describing font */
struct CFE_FONT {
    char *name;
    unsigned char *file;
    unsigned char *data;
    unsigned short *unicode_data;
    int size;
    int type;
    int height;
    int offset;
    int num_of_chars;
};

/* Font data types */
enum CFE_FONT_TYPE {
    F_RAW,
    F_PSF,
    F_ERR       /* corrupted font data */
};

/* The structure for working with glyph */
struct CFE_GLYPH {
    unsigned char *data;
    int num;
    int x;
    int y;
};
    
/* Create font file */
int create_font_file(struct CFE_FONT *font);

/* Load font file.
 * Returns -1 if file doesn't exist.
 */
int load_font_file(struct CFE_FONT *font,
                   int is_offset, int is_height);

/* Save font file */
int save_font_file(struct CFE_FONT *font);

/* Autodetects whether it is PSF or RAW font file. Returns FONT_TYPE. */
int psf_or_raw(struct CFE_FONT *font);

/* On success the string with Unicode numbers matched
 * by glyph_num is copied into str.
 * Returns zero if font doesn't contain Unicode table.
 */
int get_unicode_data(struct CFE_FONT *font, int glyph_num, char *str);

/* Set the data in the row and in the current row.
 * Operates only on glyph[0] !
 */
void set_glyph_row(int row, unsigned char data);
void set_glyph_cur_row(unsigned char data);

/* Get the data from the row and from the current row.
 * Operates only on glyph[0] !
 */
unsigned char get_glyph_row(int row);
unsigned char get_glyph_cur_row();


#endif  /* _FONT_H_ */


/* EOF */
