#ifndef VIDEODEVICEINPUT_HPP
#define VIDEODEVICEINPUT_HPP

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


#include <qobject.h>
#include <qvector.h>

#include "VideoDeviceTuner.h"

class CVideoDevice;

class CVideoDeviceInput: public QObject
{
   Q_OBJECT
private:
   CVideoDevice *pVideo;
   int Channel;
   QVector <CVideoDeviceTuner>Tuners;
   int CurrentTuner;

   QString Name;
   int Type;

   int flags;

public:
   enum {
     Unknown,
     TV,
     Camera
   } InputTypes;
   CVideoDeviceInput(CVideoDevice *video, int channel);

   int GetNumber() const;   
   QString GetName() const;
   bool HasAudio() const;
   int GetType() const;
   
   int GetTuners() const;
   int GetCurrentTuner() const;
   CVideoDeviceTuner *GetTuner(int number = -1) const;
   bool SelectTuner(int number);
   
   bool Select();
};


#endif
