/* (PD) 2001 The Bitzi Corporation
 * Please see file COPYING or http://bitzi.com/publicdomain 
 * for more info.
 *
 * $Id: gui.c,v 1.5 2001/07/24 00:58:04 mayhemchaos Exp $
 */

#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include "bitcollider.h"
#include "list.h"
#include "dirsearch.h"
#include "gui_win32.h"
#include "resource.h"

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
	MSG    msg;
    HWND   hWnd;
    DWORD  dwThreadId;
    List  *list;
    int    argIndex = 1;

    list = create_list();
	if (__argc > 1 && __argv[argIndex][0] == '@')
	{
		FILE *temp;
		char  line[MAX_PATH];

		temp = fopen(__argv[argIndex] + 1, "r");
		if (temp == NULL)
		{
            MessageBox(NULL, "Cannot read file list from shell extension.", "Bitcollider", MB_OK);
			return 0;
		}

		for(;;)
		{
            if (fgets(line, MAX_PATH, temp) == NULL)
			    break;

			line[strlen(line) - 1] = 0;
			add_to_list(list, strdup(line));
		}

		fclose(temp);

		// get rid of the temp file
		unlink(__argv[argIndex] + 1);
	}
	else
        for(; argIndex < __argc; argIndex++)
		{
            add_to_list(list, __argv[argIndex]);
		}

	// Perform application initialization:
	hWnd = init_gui();
    if (hWnd == NULL) 
	{
		return FALSE;
	}

    if (CreateThread(NULL, 0, BitcolliderThread, list, 0, &dwThreadId) == NULL)
       MessageBox(NULL, "Cannot create thread.", "Bitcollider", MB_OK);

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
        if (!IsDialogMessage(hWnd, &msg))
        {
            TranslateMessage(&msg);
  		    DispatchMessage(&msg);
        }
	}
    delete_list(list);

	return msg.wParam;
}



