;*=====================================================================*/
;*    serrano/prgm/project/bigloo/comptime/Ast/build.scm               */
;*    -------------------------------------------------------------    */
;*    Author      :  Manuel Serrano                                    */
;*    Creation    :  Fri May 31 14:00:21 1996                          */
;*    Last change :  Mon Dec  9 12:19:00 2002 (serrano)                */
;*    -------------------------------------------------------------    */
;*    From the code definition, we build the Ast                       */
;*=====================================================================*/

;*---------------------------------------------------------------------*/
;*    The module                                                       */
;*---------------------------------------------------------------------*/
(module ast_build
   (include "Engine/pass.sch"
	    "Ast/node.sch")
   (import  ast_unit
	    ast_sexp
	    ast_env
	    ast_find-gdefs
	    ast_remove
	    ast_local
	    tools_args
	    tools_progn
	    tools_location
	    tools_error
	    tools_shape)
   (export  (build-ast             ::obj)
	    (build-ast-sans-remove ::obj)))

;*---------------------------------------------------------------------*/
;*    build-ast ...                                                    */
;*    -------------------------------------------------------------    */
;*    All global variables are now bound, we can now, build the ast.   */
;*---------------------------------------------------------------------*/
(define (build-ast units)
   (remove-var 'ast (build-ast-sans-remove units)))

;*---------------------------------------------------------------------*/
;*    build-ast-sans-remove ...                                        */
;*    -------------------------------------------------------------    */
;*    All global variables are now bound, we can now, build the ast.   */
;*---------------------------------------------------------------------*/
(define (build-ast-sans-remove units)
   (pass-prelude "Ast")
   ;; there are two separate `map' because we can't build
   ;; node of the ast _until_ all the units have been processed
   ;; (otherwise some global variables could be unbound).
   (let* ((nberr *nb-error-on-pass*)
	  (defs (apply append (map unit->defs units))))
      (if (=fx nberr *nb-error-on-pass*)
	  (begin
	     ;; we can now check if all declared global variables are defined.
	     (check-to-be-define)
	     ;; and build the regular ast
	     (let ((ast (map sfun-def->ast defs)))
		;; and we return the constructed ast
		(pass-postlude ast)))
	  (pass-postlude '()))))

;*---------------------------------------------------------------------*/
;*    sfun-def->ast ...                                                */
;*---------------------------------------------------------------------*/
(define (sfun-def->ast::global def::global)
   (enter-function (global-id def))
   (let* ((sfun          (global-value def))
	  (sfun-args     (sfun-args sfun))
	  (sfun-body-exp (sfun-body sfun))
	  (def-loc       (find-location (global-src def)))
	  (body          (sexp->node sfun-body-exp
				     sfun-args
				     (find-location/loc sfun-body-exp
							def-loc)
				     'value)))
      (sfun-body-set! sfun body)
      (leave-function)
      def))

