#!/bin/sh
# -*- mode: sh; coding: utf-8 -*-
# Test archive registration
# Copyright © 2003 Colin Walters <walters@verbum.org>
#
# See the file "COPYING" for further information about
# the copyright and warranty status of this work.

set -e

arg0="$0"
srcdir=`dirname "$arg0"`

. ${srcdir}/test-framework

setup_workdir

setup_with_empty_archives

test_class "Archive registration"

begin_test "Registration with no name given"
tla register-archive -d jane@example.com--2003
tla register-archive ${ARCHIVEDIR}/jane-archive
test $(tla whereis-archive jane@example.com--2003) = ${ARCHIVEDIR}/jane-archive""
end_test 

begin_test "Registration with archive name given"
tla register-archive -d jane@example.com--2003
tla register-archive jane@example.com--2003 ${ARCHIVEDIR}/jane-archive
test $(tla whereis-archive jane@example.com--2003) = ${ARCHIVEDIR}/jane-archive""
end_test 

begin_test "Registering with mirror source name given"
tla register-archive jane@example.com--2003-SOURCE ${ARCHIVEDIR}/jane-archive
test $(tla whereis-archive jane@example.com--2003-SOURCE) = ${ARCHIVEDIR}/jane-archive""
tla register-archive -d jane@example.com--2003-SOURCE
end_test

begin_test "Properly refuses mystyped name for existing archive"
(tla register-archive notjane@example.com--2003 \
     ${ARCHIVEDIR}/jane-archive 2>&1 | grep "invalid name") \
     || test_fail "Did not detect incorrect archive registration"
end_test

begin_test "Archive unregistration"
tla register-archive -d jane@example.com--2003
if tla whereis-archive jane@example.com--2003 2>/dev/null; then
  exit 1
fi    
end_test

begin_test "Registration with no .arch-params"
rm $HOME/.arch-params -R
tla register-archive ${CACHEDARCHIVEDIR}/jane-archive
test $(tla whereis-archive jane@example.com--2003) = ${CACHEDARCHIVEDIR}/jane-archive""
end_test 

clean_workdir

# tag: Colin Walters Tue, 16 Sep 2003 20:35:26 -0400 (test-register-archive.sh)
#
