(in-package "ACL2")

(local (include-book "flooreric"))
(local (include-book "arith2"))
(local (include-book "expt2")) ;remove this?
(local (include-book "expt")) ;remove this?
(local (include-book "power2p"))
;(local (include-book "expo2"))
(local (include-book "fl2"))
(local (include-book "mod"))
(local (include-book "fp2"))
(local (include-book "integerp"))
(local (include-book "product"))
(local (include-book "complex-rationalp"))
(local (include-book "../../../meta/meta-plus-equal"))
(local (include-book "../../../meta/meta-plus-lessp"))
;(include-book "expo")

;rules like these for rem too?


(DEFUN FL (X) (FLOOR X 1))


(defthm mod-by-0
  (equal (mod x 0)
         (fix x)))

(defthm mod-with-x-0
  (equal (mod 0 y)
         0))

;gen
;simlar to mod-lower-bound
(defthm mod-non-negative-rationalp
  (implies (and (< 0 y) ;cant gen!
                (rationalp x)
                (rationalp y)
                )
           (and (rationalp (mod x y))
                (<= 0 (mod x y))))
  :hints (("goal" :cases ((= y 0))
           :in-theory (disable floor)))
  :rule-classes (:rewrite :type-prescription))






;see todo




(defthm mod-non-negative-case-x-not-acl2-numberp
  (implies (not (acl2-numberp x))
           (<= 0 (mod x y))))

(in-theory (disable mod-non-negative-case-x-not-acl2-numberp))

;a weak t-p rule
(defthm mod-non-negative
  (implies (and (< 0 y) 
                (not (complex-rationalp x))
                (rationalp y)
                )
           (and (<= 0 (mod x y))
                (acl2-numberp (mod x y)))) ;this part doesn't help
  :otf-flg t
  :hints (("goal"
           :use (mod-non-negative-case-x-not-acl2-numberp
                 (:instance fl-def-linear-part-1 (x (/ x y))))
           :in-theory (disable floor  
                               fl-weak-monotone
                               fl-def-linear-part-1
                               ;; *-strongly-monotonic  ;; RBK: f-c and lin
                               )))
  :rule-classes (:rewrite :type-prescription))



(include-book "complex-rationalp")


(defthm mod-complex-rationalp
  (implies (rationalp y)
           (equal (complex-rationalp (mod x y))
                  (complex-rationalp x))))

#|

(defthm mod-non-negative-2
  (implies (and (not (complex-rationalp x))
                (not (complex-rationalp y))
                (> y 0) 
                )
           (>= (mod x y) 0))
  :otf-flg t
  :hints (("Goal" ;:cases ((= y 0))
           :in-theory (disable floor  FL-WEAK-MONOTONE *-STRONGLY-MONOTONIC  FL-DEF-LINEAR-part-1)
           :use (:instance FL-DEF-LINEAR-part-1 (x (/ x y)))))
))
  :rule-classes (:rewrite :type-prescription))
|#


#| not true for negative complex-rationalps
(defthm mod-<-0
  (<= 0 (mod x y))
  :hints (("Goal" :in-theory (enable mod)))
)

)
|#

(local (in-theory (enable mod)))

(defthm mod-non-positive
  (implies (and (< y 0)
                (rationalp x)
                (rationalp y)
                )
           (and (rationalp (mod x y))
                (<= (mod x y) 0 )))
  :hints (("Goal" :cases ((= y 0))
           :in-theory (disable floor)))
  :rule-classes (:rewrite :type-prescription))
;other cases for signs of m and n?


(defthm mod-integerp
  (implies (and (integerp x)
                (integerp y)
                )
           (integerp (mod x y)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable mod)
                              '(floor-fl))))
  :rule-classes (:rewrite :type-prescription))


;similar lemma when x is a known int?
(defthm integerp-mod-2
  (implies (and (integerp y)
                (case-split (acl2-numberp x))
                )
           (equal (integerp (mod x y))
                  (integerp x)))
  :hints (("Goal" :in-theory (enable mod))))

;cute; why does this help so much?
(defthm MOD-Fl-2
  (implies (case-split (acl2-numberp x))
           (equal (+ (* y (fl (/ x y))) (mod x y))
                  x))
  :rule-classes ()
  :hints (("Goal" :in-theory (enable floor-fl))))

;from doc?
(defthm mod+-eric
    (implies (and (integerp x)
		  (integerp y)
		  (integerp a))
	     (equal (mod (+ x (* a y)) y)
                    (mod x y)))
  :hints (("Goal"  :in-theory (disable mod)
           :use ((:instance mod-fl-2)
                 (:instance mod-fl-2 (x (+ x (* a y))))
                 ))))

(defthm mod-drop-irrelevant-second-term
    (implies (and (integerp (* k (/ y)))
                  (case-split (not (complex-rationalp x)));(rationalp x) ;(integerp x)
		  (case-split (rationalp y)) ;(integerp y)
                  (case-split (not (equal y 0))) ;handle in concl?
;(rationalp k)
                  )
	     (equal (mod (+ x k) y)
                    (mod x y)))
  :hints (("Goal"  :in-theory (enable mod))))

(defthm mod-drop-irrelevant-first-term
  (implies (and (integerp (* k (/ y)))
                (case-split (not (complex-rationalp x))) ;(rationalp x) ;(integerp x)
                (case-split (rationalp y)) ;(integerp y)
                (case-split (not (equal y 0))) ;handle in concl?
;                (rationalp k)
                )
           (equal (mod (+ k x) y)
                  (mod x y)))
  :hints (("Goal"  :in-theory (enable mod))))


;redundant
;(local (include-book "fl"))


(defthm mod+mod-2
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp y))
           (equal (mod (+ a (mod b y)) y)
                  (mod (+ a b) y)))
  :hints (("Goal" :cases ((equal y 0))
           :in-theory (enable mod))))

;remove?
(defthm mod+mod-alt
  (implies (and (rationalp a)
                (rationalp b)
                (rationalp y))
           (equal (mod (+ (mod b y) a) y)
                  (mod (+ a b) y)))
  :hints (("Goal" :cases ((equal y 0))
           :in-theory (enable mod))))



;elim some of these events?

;mod-sum is just mod+mod

;replace the old version (in merge4)
(defthm mod-mod-sum-2
    (implies (and (integerp a)
		  (integerp b)
                  (integerp y))
	     (equal (mod (+ (mod a y) (mod b y)) y)
		    (mod (+ a b) y)))
    :hints (("Goal" :cases ((equal 0 y))
             :in-theory (set-difference-theories
                                (enable mod)
                                '()))))

(defthm mod-by-1
  (implies (integerp x)
           (equal (mod x 1)
                  0))
  :hints (("goal" :in-theory (enable mod floor))))

(defthm mod-mult-of-n
  (implies (and (rationalp x) ;(acl2-numberp m)
                (rationalp y)
                (not (equal y 0))
                (INTEGERP (* x (/ y))))
           (equal (mod x y)
                  0)))

(defthm mod-negative-y
  (implies (and (integerp x)
                (integerp y)
                (> y 0))
           (equal (mod x (- y))
                  (if (integerp (/ x y))
                      0
                    (+ (- y) (mod x y))))))

;negative first arg?



;more general than the above but the above makes a nice linear rule
(defthm mod-upper-bound-3
  (implies (and (<= y z)
                (case-split (not (complex-rationalp x))) ;(rationalp x)
;                (rationalp x)
                (rationalp y)
                (< 0 y)
                )
           (< (mod x y) z))
  :hints (("Goal" :in-theory (disable mod)))
)


;rewrite! wont fire!
(defthm mod-upper-bound-2
  (implies (and (rationalp x)
                (rationalp y)
                (> y 0)
                (> x 0)
                )
           (<= (mod x y) x))
  :rule-classes (:rewrite (:linear :trigger-terms ((mod x y))))
)

(defthm mod-lower-bound
  (implies (and (rationalp x)
                (rationalp y)
                (> y 0)
                )
           (<= 0 (mod x y)))
  :rule-classes (:rewrite (:linear :trigger-terms ((mod x y)))))

(defthm mod-unique
  (implies (and (< x y)
                (rationalp x)
                (rationalp y)
                (>= x 0)

                )
           (equal (mod x y)
                  x)))



;(local (in-theory (disable a8)))

;really should disable mod b/f this
(defthm mod-idempotent
  (implies (and (case-split (rationalp x)) ;(integerp x)
                (case-split (rationalp y)) ;(integerp y)
                (>= y 0)
                (>= x 0))
           (equal (mod (mod x y) y)
                  (mod x y)))

)

;make an equal rule?
(defthm mod-rationalp
  (implies (rationalp x)
           (rationalp (mod x y)))
  :hints (("Goal" :cases ((complex-rationalp y))
           :in-theory (enable mod)))
  :rule-classes (:rewrite :type-prescription))

;a is a free var
; mod-squeeze-2-eric was similar to this
(defthm mod-force-eric
  (implies (and (<= (* a y) x)
                (< x (* (1+ a) y))
                (rationalp x)
                (rationalp y)
                (integerp a)
                )
           (equal (mod x y) (- x (* a y))))
  :hints
  (("goal" :in-theory (enable floor)
    :use ((:instance mod-fl-2)
          (:instance fl-unique (x (/ x y)) (n a))))))

(in-theory (disable mod-force-eric))

;chose a in mod-force-eric to be -1
;expensive?
(defthm mod-force-chosen-a-neg
    (implies (and (< x 0)
		  (<= (* -1 y) x)
                  (rationalp x)
                  (rationalp y)
                  )
	     (equal (mod x y) (- x (* -1 y))))
    :hints (("Goal" :in-theory (disable mod-force-eric)
         :use (:instance mod-force-eric (a -1)))))

(include-book "type")

;gen?
(defthm mod-even
  (implies (rationalp x)
           (equal (INTEGERP (* 1/2 (MOD X 2)))
                  (integerp (* 1/2 x)))))

;gen 2 to m?
(defthm mod-even-gen
  (implies (and (rationalp x)
                (integerp n)
                (integerp (* 1/2 n)) ;address the other case?
                )
           (equal (INTEGERP (* 1/2 (MOD X n)))
                  (integerp (* 1/2 x))))
  :hints (("Goal" :in-theory (enable mod))))




(in-theory (disable mod))

#|

(defthm mod-blah
    (implies (and (integerp m)
                  (integerp n)
                  (<= 0 n)
;		  (nat p n)
		  (> 0 m)
		  (>= m (* -1 n)))
	     (= (mod m n) (- m (* -1 n))))
:hints (("Goal" :use (:instance mod-force-eric (a -1)))))
|#


;disable? will occur rarely?
(defthm mod-of-non-acl2-numberp
  (implies (not (acl2-numberp x))
           (equal (mod x y)
                  0))
  :hints (("Goal" :in-theory (enable mod floor)))
)

#|
not quite right
(defthm mod-of-complex
  (implies (complex-rationalp x)
           (equal (mod x y)
                  (eric)))
  :otf-flg t
  :hints (("Goal" :in-theory (enable mod floor)
           :cases ((rationalp y) (not (acl2-numberp y))))))
|#


;make a version of inverse-of-* that's better for rewriting (hyp free)


;enforces a new normal form for mod: force second arg to 1
(defthm mod-cancel
  (implies (syntaxp (not (and (quotep y) (equal (cadr y) 1)))) ;prevents looping
           (equal (mod x y)
                  (if (acl2-numberp x)
                      (if (acl2-numberp y)
                          (if (equal 0 y)
                              x
                            (* y (mod (/ x y) 1)))
                        x)
                    0)))
  :hints (("Goal" :in-theory (enable mod inverse-of-*)))
  )


(in-theory (disable mod-cancel)) ; would someday like to export this enabled

(defthm mod-minus-case-non-integerp
  (implies (and (not (integerp (/ x y)))
                (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y)))
                )
           (equal (mod (* -1 x) y)
                  (mod (- y (mod x y)) y)))
  :hints (("Goal" :in-theory (enable mod))))

(defthm mod-minus-case-integerp
  (implies (and (integerp (/ x y))
                (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y)))
                )
           (equal (mod (* -1 x) y)
                  (mod (- y (mod x y)) y)))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable mod)
                              '())
           :cases ((equal y 0)))))

(in-theory (disable mod-minus-case-non-integerp mod-minus-case-integerp))

;new version:
(defthm mod-minus
  (implies (and (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y)))
                )
           (equal (mod (* -1 x) y)
                  (mod (- y (mod x y)) y)))
  :hints (("Goal" :use ( mod-minus-case-non-integerp mod-minus-case-integerp)
)))



(defthm mod-minus-2-case-non-integerp
  (implies (and (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y)))
                (not (integerp (/ x y))))
           (equal (mod (* -1 x) y)
                  (- y (mod x y))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable mod)
                              '(mod-minus)))))

(defthm mod-minus-2-case-integerp
  (implies (and (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y)))
                (integerp (/ x y)))
           (equal (mod (* -1 x) y)
                  (- (mod x y))))
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable mod)
                              '( mod-minus)))))


;old version
(defthm mod-minus-2
  (implies (and (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y))))
           (equal (mod (* -1 x) y)
                  (if (integerp (/ x y))
                      (- (mod x y))
                    (- y (mod x y)))))
  :hints (("Goal" :in-theory (disable mod-minus)
           :cases ((integerp (/ x y))))))  

(in-theory (disable mod-minus-2-case-non-integerp mod-minus-2-case-integerp))

(defthm mod-minus-2-alt
  (implies (and (syntaxp (negative-syntaxp x))
                (case-split (not (complex-rationalp x)))
                (case-split (not (complex-rationalp y)))
                )
           (equal (mod x y)
                  (if (integerp (/ (- x) y))
                      (- (mod (- x) y))
                    (- y (mod (- x) y)))))
  :hints (("Goal" :in-theory (disable mod-minus)
           :cases ((integerp (/ (- x) y))))))

(defthm mod-1-integerp
  (implies (case-split (acl2-numberp x))
           (equal (integerp (mod x 1))
                  (integerp x)))
  :hints (("Goal" :in-theory (enable mod)))
  )




; needs fl-of-odd/2
;the disable shouldn't be necessary
(defthm mod-by-2-rewrite-to-even
  (implies (integerp x)
           (equal (equal (mod x 2) 0)
                  (integerp (* 1/2 x))))
  :otf-flg t
  :hints (("Goal" :in-theory (set-difference-theories
                              (enable mod)
                              '(;REARRANGE-NEGATIVE-COEFS-EQUAL-ERIC
                                ))))
)


(defthm fl-plus-md
  (implies (rationalp x)
           (equal (+ (fl x) (mod x 1))
                  x))
  :hints (("Goal" :in-theory (enable mod))))

(defthm mod-1-sum-integer
  (implies (and (rationalp x)
                (rationalp y))
           (equal (INTEGERP (+ x (MOD y 1)))
                  (integerp (+ x y))))
  :hints (("Goal" :in-theory (enable mod))))

;needed?
;expensive?
#|
??
ex:   (INTEGERP (* (/ (EXPT 2 J))
               (MOD X (* 2 (EXPT 2 I)))))
|#

(defthm mod-quotient-integerp
  (implies (and (rationalp x)
                (rationalp y)
                (rationalp k)
                (integerp (* y k))
                )
           (equal (integerp (* k (mod x y)))
                  (integerp (* k x))))
  :hints (("Goal" :in-theory (enable mod))))

;included to help a hyp which matches this rule's conclusion get written away quickly
(defthm mod-upper-bound-less-tight-rewrite
  (implies (and (rationalp x)
                (rationalp y)
                (> y 0)
                )
           (<= (mod x y) y)))


(defthm mod-mod-e
  (implies (and (integerp (/ y1 y2))
                (case-split (rationalp y1))
                (case-split (rationalp y2))
                (case-split (not (equal y2 0)))
                )
           (equal (mod (mod x y1) y2)
                  (mod x y2)))
  :hints (("Goal" :cases ((complex-rationalp x))
           :in-theory (enable mod))))



;gen
;may someday subsume mod-idempotent
(defthm mod-mod-2-thm
  (implies (and (<= y1 y2)
                (case-split (<= 0 y2))
                (case-split (< 0 y1))                 ;drop?
                (case-split (acl2-numberp x)) ;gen?
                (case-split (rationalp y1))
                (case-split (rationalp y2))
                (case-split (not (equal y1 0)))
                )
           (equal (mod (mod x y1) y2)
                  (mod x y1)))
  :otf-flg t
  :hints (("Goal" :in-theory (enable mod))))



;thms about fl and mod

(local (in-theory (disable a15)))



;new
(defthm mod-equal-0
  (implies (and ;(case-split (rationalp x))
                (case-split (rationalp y)) ;gen?
                (case-split (not (equal y 0)))
                )
           (equal (equal (mod x y) 0)
                  (integerp (* (/ y) x))))
  :hints (("Goal" 
           :in-theory (enable mod)))
)

;expensive?
(defthm mod-does-nothing
  (implies (and (< x y)
                (<= 0 x)
                (rationalp x)
                (rationalp y)
                )
           (equal (mod x y)
                  x))
  :hints (("Goal" :in-theory (enable mod)))
)

;perhaps try leaving it enabled
(in-theory (disable mod-does-nothing))

(defthm mod-2-1-means-odd
  (implies (integerp x)
           (equal (equal (mod x 2) 1)
                  (not (integerp (* 1/2 x)))))
  :hints (("Goal" :in-theory (enable mod))))

;unlikely to fire automatically
(defthm mod-integerp-2-2
  (implies (and (integerp y)
                (integerp x))
           (integerp (mod x (/ y))))
  :hints (("Goal" :cases ((equal 0 y))
           :in-theory (enable mod))))



(defthm mod-cancel-special-1
  (implies (and (acl2-numberp x)
                (rationalp k)
                (acl2-numberp y)
                (not (equal y 0))
                (not (equal k 0)))
           (equal (MOD (* k x)
                       (* y k))
                  (* k (mod x y))))
  :hints (("Goal" :in-theory (enable mod-cancel))))

;move up
(defthm mod-integerp-when-y-is-an-inverse
  (implies (and (integerp x)
                (integerp (/ y)))
           (integerp (mod x y)))
  :hints (("Goal" :in-theory (enable mod)))
)

(defthm mod-when-y-is-an-inverse
  (implies (and (integerp (/ y))
                (case-split (< 0 y))
                (integerp x)
                )
           (equal (mod x y)
                  0))
  :hints (("Goal" :in-theory (enable mod)))
)



;perhaps my approach to the types of the params to mod should be to case-split when x isn't an acl2-number and
;y isn't a rational?

#|
(defthm mod-with-y-not-rational
  (implies (and (acl2-numberp x)
                (not (rationalp y)))
           (equal (mod x y)
                  x))
  :hints (("Goal" :in-theory (enable mod)))
)
|#

(defthm mod-by-1-rationalp
  (implies (and (rationalp y)
                (case-split (acl2-numberp x)))
           (equal (RATIONALP (MOD X y))
                  (rationalp x)))
  :hints (("Goal" :in-theory (enable mod)))
  )

(defthm fl-mod-x-1
  (equal (FL (MOD X 1)) 0))

(defthm mod-by-2
  (implies (integerp x)
           (equal (mod x 2)
                  (if (integerp (* 1/2 x))
                      0
                    1))))
(in-theory (disable mod-by-2))